/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v407.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.packet.ItemStackResponsePacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ItemStackResponseSerializer_v407
implements BedrockPacketSerializer<ItemStackResponsePacket> {
    public static final ItemStackResponseSerializer_v407 INSTANCE = new ItemStackResponseSerializer_v407();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket packet) {
        helper.writeArray(buffer, (Collection)packet.getEntries(), (buf, response) -> {
            buf.writeBoolean(response.isSuccess());
            VarInts.writeInt((ByteBuf)buffer, (int)response.getRequestId());
            if (!response.isSuccess()) {
                return;
            }
            helper.writeArray(buf, (Collection)response.getContainers(), (buf2, containerEntry) -> {
                buf2.writeByte(containerEntry.getContainer().ordinal());
                helper.writeArray(buf2, (Collection)containerEntry.getItems(), this::writeItemEntry);
            });
        });
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket packet) {
        List entries = packet.getEntries();
        helper.readArray(buffer, (Collection)entries, buf -> {
            boolean success = buf.readBoolean();
            int requestId = VarInts.readInt((ByteBuf)buf);
            if (!success) {
                return new ItemStackResponsePacket.Response(success, requestId, Collections.emptyList());
            }
            ArrayList containerEntries = new ArrayList();
            helper.readArray(buf, containerEntries, buf2 -> {
                ContainerSlotType container = ContainerSlotType.values()[buf2.readByte()];
                ArrayList itemEntries = new ArrayList();
                helper.readArray(buf2, itemEntries, byteBuf -> this.readItemEntry((ByteBuf)byteBuf, helper));
                return new ItemStackResponsePacket.ContainerEntry(container, itemEntries);
            });
            return new ItemStackResponsePacket.Response(success, requestId, containerEntries);
        });
    }

    protected ItemStackResponsePacket.ItemEntry readItemEntry(ByteBuf buffer, BedrockPacketHelper helper) {
        return new ItemStackResponsePacket.ItemEntry(buffer.readByte(), buffer.readByte(), buffer.readByte(), VarInts.readInt((ByteBuf)buffer), "", 0);
    }

    protected void writeItemEntry(ByteBuf buffer, BedrockPacketHelper helper, ItemStackResponsePacket.ItemEntry itemEntry) {
        buffer.writeByte((int)itemEntry.getSlot());
        buffer.writeByte((int)itemEntry.getHotbarSlot());
        buffer.writeByte((int)itemEntry.getCount());
        VarInts.writeInt((ByteBuf)buffer, (int)itemEntry.getStackNetworkId());
    }

    protected ItemStackResponseSerializer_v407() {
    }
}

