/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v407.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.inventory.EnchantData;
import com.nukkitx.protocol.bedrock.data.inventory.EnchantOptionData;
import com.nukkitx.protocol.bedrock.packet.PlayerEnchantOptionsPacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;

public class PlayerEnchantOptionsSerializer_v407
implements BedrockPacketSerializer<PlayerEnchantOptionsPacket> {
    public static final PlayerEnchantOptionsSerializer_v407 INSTANCE = new PlayerEnchantOptionsSerializer_v407();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, PlayerEnchantOptionsPacket packet) {
        helper.writeArray(buffer, (Collection)packet.getOptions(), this::writeOption);
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, PlayerEnchantOptionsPacket packet) {
        helper.readArray(buffer, (Collection)packet.getOptions(), this::readOption);
    }

    protected void writeOption(ByteBuf buffer, BedrockPacketHelper helper, EnchantOptionData option) {
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)option.getCost());
        buffer.writeIntLE(option.getPrimarySlot());
        helper.writeArray(buffer, (Collection)option.getEnchants0(), this::serializeEnchant);
        helper.writeArray(buffer, (Collection)option.getEnchants1(), this::serializeEnchant);
        helper.writeArray(buffer, (Collection)option.getEnchants2(), this::serializeEnchant);
        helper.writeString(buffer, option.getEnchantName());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)option.getEnchantNetId());
    }

    protected EnchantOptionData readOption(ByteBuf buffer, BedrockPacketHelper helper) {
        int cost = VarInts.readUnsignedInt((ByteBuf)buffer);
        int primarySlot = buffer.readIntLE();
        ObjectArrayList enchants1 = new ObjectArrayList();
        helper.readArray(buffer, (Collection)enchants1, this::deserializeEnchant);
        ObjectArrayList enchants2 = new ObjectArrayList();
        helper.readArray(buffer, (Collection)enchants2, this::deserializeEnchant);
        ObjectArrayList enchants3 = new ObjectArrayList();
        helper.readArray(buffer, (Collection)enchants3, this::deserializeEnchant);
        String enchantName = helper.readString(buffer);
        int enchantNetId = VarInts.readUnsignedInt((ByteBuf)buffer);
        return new EnchantOptionData(cost, primarySlot, (List)enchants1, (List)enchants2, (List)enchants3, enchantName, enchantNetId);
    }

    protected void serializeEnchant(ByteBuf buffer, EnchantData enchant) {
        buffer.writeByte(enchant.getType());
        buffer.writeByte(enchant.getLevel());
    }

    protected EnchantData deserializeEnchant(ByteBuf buffer) {
        short type = buffer.readUnsignedByte();
        short level = buffer.readUnsignedByte();
        return new EnchantData((int)type, (int)level);
    }

    protected PlayerEnchantOptionsSerializer_v407() {
    }
}

