/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v407.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.LegacySetItemSlotData;
import com.nukkitx.protocol.bedrock.data.inventory.TransactionType;
import com.nukkitx.protocol.bedrock.packet.InventoryTransactionPacket;
import com.nukkitx.protocol.bedrock.v291.serializer.InventoryTransactionSerializer_v291;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class InventoryTransactionSerializer_v407
extends InventoryTransactionSerializer_v291 {
    public static final InventoryTransactionSerializer_v407 INSTANCE = new InventoryTransactionSerializer_v407();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, InventoryTransactionPacket packet, BedrockSession session) {
        int legacyRequestId = packet.getLegacyRequestId();
        VarInts.writeInt((ByteBuf)buffer, (int)legacyRequestId);
        if (legacyRequestId < -1 && (legacyRequestId & 1) == 0) {
            helper.writeArray(buffer, (Collection)packet.getLegacySlots(), (buf, packetHelper, data) -> {
                buf.writeByte(data.getContainerId());
                packetHelper.writeByteArray(buf, data.getSlots());
            });
        }
        TransactionType transactionType = packet.getTransactionType();
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)transactionType.ordinal());
        helper.writeInventoryActions(buffer, session, packet.getActions(), packet.isUsingNetIds());
        switch (transactionType) {
            case ITEM_USE: {
                helper.writeItemUse(buffer, packet, session);
                break;
            }
            case ITEM_USE_ON_ENTITY: {
                this.writeItemUseOnEntity(buffer, helper, packet, session);
                break;
            }
            case ITEM_RELEASE: {
                this.writeItemRelease(buffer, helper, packet, session);
            }
        }
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, InventoryTransactionPacket packet, BedrockSession session) {
        int legacyRequestId = VarInts.readInt((ByteBuf)buffer);
        packet.setLegacyRequestId(legacyRequestId);
        if (legacyRequestId < -1 && (legacyRequestId & 1) == 0) {
            helper.readArray(buffer, (Collection)packet.getLegacySlots(), (buf, packetHelper) -> {
                byte containerId = buf.readByte();
                byte[] slots = packetHelper.readByteArray(buf);
                return new LegacySetItemSlotData((int)containerId, slots);
            });
        }
        TransactionType transactionType = TransactionType.values()[VarInts.readUnsignedInt((ByteBuf)buffer)];
        packet.setTransactionType(transactionType);
        packet.setUsingNetIds(helper.readInventoryActions(buffer, session, packet.getActions()));
        switch (transactionType) {
            case ITEM_USE: {
                helper.readItemUse(buffer, packet, session);
                break;
            }
            case ITEM_USE_ON_ENTITY: {
                this.readItemUseOnEntity(buffer, helper, packet, session);
                break;
            }
            case ITEM_RELEASE: {
                this.readItemRelease(buffer, helper, packet, session);
            }
        }
    }

    protected InventoryTransactionSerializer_v407() {
    }
}

