/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.ResourcePackType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.skin.AnimatedTextureType;
import com.nukkitx.protocol.bedrock.data.skin.AnimationData;
import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.data.structure.StructureAnimationMode;
import com.nukkitx.protocol.bedrock.data.structure.StructureMirror;
import com.nukkitx.protocol.bedrock.data.structure.StructureRotation;
import com.nukkitx.protocol.bedrock.data.structure.StructureSettings;
import com.nukkitx.protocol.bedrock.v361.BedrockPacketHelper_v361;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;

public class BedrockPacketHelper_v388
extends BedrockPacketHelper_v361 {
    public static final BedrockPacketHelper_v388 INSTANCE = new BedrockPacketHelper_v388();
    protected static final AnimatedTextureType[] TEXTURE_TYPES = AnimatedTextureType.values();

    protected void registerEntityData() {
        super.registerEntityData();
        this.addEntityData(107, EntityData.AMBIENT_SOUND_INTERVAL);
        this.addEntityData(108, EntityData.AMBIENT_SOUND_INTERVAL_RANGE);
        this.addEntityData(109, EntityData.AMBIENT_SOUND_EVENT_NAME);
        this.addEntityData(110, EntityData.FALL_DAMAGE_MULTIPLIER);
        this.addEntityData(111, EntityData.NAME_RAW_TEXT);
        this.addEntityData(112, EntityData.CAN_RIDE_TARGET);
    }

    protected void registerEntityFlags() {
        super.registerEntityFlags();
        this.addEntityFlag(88, EntityFlag.IS_IN_UI);
        this.addEntityFlag(89, EntityFlag.STALKING);
        this.addEntityFlag(90, EntityFlag.EMOTING);
        this.addEntityFlag(91, EntityFlag.CELEBRATING);
    }

    protected void registerCommandParams() {
        this.addCommandParam(1, CommandParam.INT);
        this.addCommandParam(2, CommandParam.FLOAT);
        this.addCommandParam(3, CommandParam.VALUE);
        this.addCommandParam(4, CommandParam.WILDCARD_INT);
        this.addCommandParam(5, CommandParam.OPERATOR);
        this.addCommandParam(6, CommandParam.TARGET);
        this.addCommandParam(7, CommandParam.WILDCARD_TARGET);
        this.addCommandParam(14, CommandParam.FILE_PATH);
        this.addCommandParam(29, CommandParam.STRING);
        this.addCommandParam(37, CommandParam.BLOCK_POSITION);
        this.addCommandParam(38, CommandParam.POSITION);
        this.addCommandParam(41, CommandParam.MESSAGE);
        this.addCommandParam(43, CommandParam.TEXT);
        this.addCommandParam(47, CommandParam.JSON);
        this.addCommandParam(54, CommandParam.COMMAND);
    }

    protected void registerEntityEvents() {
        super.registerEntityEvents();
        this.addEntityEvent(74, EntityEventType.FINISHED_CHARGING_CROSSBOW);
    }

    protected void registerLevelEvents() {
        super.registerLevelEvents();
        int particle = 2000;
        this.addLevelEvent(24 + particle, LevelEventType.PARTICLE_POINT_CLOUD);
        this.addLevelEvent(25 + particle, LevelEventType.PARTICLE_EXPLOSION);
        this.addLevelEvent(26 + particle, LevelEventType.PARTICLE_BLOCK_EXPLOSION);
    }

    protected void registerSoundEvents() {
        super.registerSoundEvents();
        this.addSoundEvent(274, SoundEvent.AMBIENT_IN_RAID);
        this.addSoundEvent(275, SoundEvent.UI_CARTOGRAPHY_TABLE_USE);
        this.addSoundEvent(276, SoundEvent.UI_STONECUTTER_USE);
        this.addSoundEvent(277, SoundEvent.UI_LOOM_USE);
        this.addSoundEvent(278, SoundEvent.SMOKER_USE);
        this.addSoundEvent(279, SoundEvent.BLAST_FURNACE_USE);
        this.addSoundEvent(280, SoundEvent.SMITHING_TABLE_USE);
        this.addSoundEvent(281, SoundEvent.SCREECH);
        this.addSoundEvent(282, SoundEvent.SLEEP);
        this.addSoundEvent(283, SoundEvent.FURNACE_USE);
        this.addSoundEvent(284, SoundEvent.MOOSHROOM_CONVERT);
        this.addSoundEvent(285, SoundEvent.MILK_SUSPICIOUSLY);
        this.addSoundEvent(286, SoundEvent.CELEBRATE);
    }

    protected void registerResourcePackTypes() {
        this.addResourcePackType(0, ResourcePackType.INVALID);
        this.addResourcePackType(1, ResourcePackType.ADDON);
        this.addResourcePackType(2, ResourcePackType.CACHED);
        this.addResourcePackType(3, ResourcePackType.COPY_PROTECTED);
        this.addResourcePackType(4, ResourcePackType.BEHAVIOR);
        this.addResourcePackType(5, ResourcePackType.PERSONA_PIECE);
        this.addResourcePackType(6, ResourcePackType.RESOURCE);
        this.addResourcePackType(7, ResourcePackType.SKINS);
        this.addResourcePackType(8, ResourcePackType.WORLD_TEMPLATE);
    }

    public SerializedSkin readSkin(ByteBuf buffer) {
        String skinId = this.readString(buffer);
        String skinResourcePatch = this.readString(buffer);
        ImageData skinData = this.readImage(buffer);
        int animationCount = buffer.readIntLE();
        ObjectArrayList animations = new ObjectArrayList(animationCount);
        for (int i = 0; i < animationCount; ++i) {
            animations.add(this.readAnimationData(buffer));
        }
        ImageData capeData = this.readImage(buffer);
        String geometryData = this.readString(buffer);
        String animationData = this.readString(buffer);
        boolean premium = buffer.readBoolean();
        boolean persona = buffer.readBoolean();
        boolean capeOnClassic = buffer.readBoolean();
        String capeId = this.readString(buffer);
        String fullSkinId = this.readString(buffer);
        return SerializedSkin.of((String)skinId, (String)"", (String)skinResourcePatch, (ImageData)skinData, (List)animations, (ImageData)capeData, (String)geometryData, (String)animationData, (boolean)premium, (boolean)persona, (boolean)capeOnClassic, (String)capeId, (String)fullSkinId);
    }

    public void writeSkin(ByteBuf buffer, SerializedSkin skin) {
        Objects.requireNonNull(skin, "Skin is null");
        this.writeString(buffer, skin.getSkinId());
        this.writeString(buffer, skin.getSkinResourcePatch());
        this.writeImage(buffer, skin.getSkinData());
        List animations = skin.getAnimations();
        buffer.writeIntLE(animations.size());
        for (AnimationData animation : animations) {
            this.writeAnimationData(buffer, animation);
        }
        this.writeImage(buffer, skin.getCapeData());
        this.writeString(buffer, skin.getGeometryData());
        this.writeString(buffer, skin.getAnimationData());
        buffer.writeBoolean(skin.isPremium());
        buffer.writeBoolean(skin.isPersona());
        buffer.writeBoolean(skin.isCapeOnClassic());
        this.writeString(buffer, skin.getCapeId());
        this.writeString(buffer, skin.getFullSkinId());
    }

    public AnimationData readAnimationData(ByteBuf buffer) {
        ImageData image = this.readImage(buffer);
        AnimatedTextureType type = TEXTURE_TYPES[buffer.readIntLE()];
        float frames = buffer.readFloatLE();
        return new AnimationData(image, type, frames);
    }

    public void writeAnimationData(ByteBuf buffer, AnimationData animation) {
        this.writeImage(buffer, animation.getImage());
        buffer.writeIntLE(animation.getTextureType().ordinal());
        buffer.writeFloatLE(animation.getFrames());
    }

    public ImageData readImage(ByteBuf buffer) {
        Objects.requireNonNull(buffer, "buffer is null");
        int width = buffer.readIntLE();
        int height = buffer.readIntLE();
        byte[] image = this.readByteArray(buffer);
        return ImageData.of((int)width, (int)height, (byte[])image);
    }

    public void writeImage(ByteBuf buffer, ImageData image) {
        Objects.requireNonNull(buffer, "buffer is null");
        Objects.requireNonNull(image, "image is null");
        buffer.writeIntLE(image.getWidth());
        buffer.writeIntLE(image.getHeight());
        this.writeByteArray(buffer, image.getImage());
    }

    public StructureSettings readStructureSettings(ByteBuf buffer) {
        String paletteName = this.readString(buffer);
        boolean ignoringEntities = buffer.readBoolean();
        boolean ignoringBlocks = buffer.readBoolean();
        Vector3i size = this.readBlockPosition(buffer);
        Vector3i offset = this.readBlockPosition(buffer);
        long lastEditedByEntityId = VarInts.readLong((ByteBuf)buffer);
        StructureRotation rotation = StructureRotation.from((int)buffer.readByte());
        StructureMirror mirror = StructureMirror.from((int)buffer.readByte());
        float integrityValue = buffer.readFloatLE();
        int integritySeed = buffer.readIntLE();
        Vector3f pivot = this.readVector3f(buffer);
        return new StructureSettings(paletteName, ignoringEntities, ignoringBlocks, size, offset, lastEditedByEntityId, rotation, mirror, StructureAnimationMode.NONE, 0.0f, integrityValue, integritySeed, pivot);
    }

    public void writeStructureSettings(ByteBuf buffer, StructureSettings settings) {
        super.writeStructureSettings(buffer, settings);
        this.writeVector3f(buffer, settings.getPivot());
    }

    protected BedrockPacketHelper_v388() {
    }
}

