/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.math.vector.Vector2f;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.ClientPlayMode;
import com.nukkitx.protocol.bedrock.data.InputMode;
import com.nukkitx.protocol.bedrock.data.PlayerAuthInputData;
import com.nukkitx.protocol.bedrock.packet.PlayerAuthInputPacket;
import io.netty.buffer.ByteBuf;
import java.util.Set;

public class PlayerAuthInputSerializer_v388
implements BedrockPacketSerializer<PlayerAuthInputPacket> {
    public static final PlayerAuthInputSerializer_v388 INSTANCE = new PlayerAuthInputSerializer_v388();
    protected static final InputMode[] INPUT_MODES = InputMode.values();
    protected static final ClientPlayMode[] CLIENT_PLAY_MODES = ClientPlayMode.values();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, PlayerAuthInputPacket packet) {
        Vector3f rotation = packet.getRotation();
        buffer.writeFloatLE(rotation.getX());
        buffer.writeFloatLE(rotation.getY());
        helper.writeVector3f(buffer, packet.getPosition());
        buffer.writeFloatLE(packet.getMotion().getX());
        buffer.writeFloatLE(packet.getMotion().getY());
        buffer.writeFloatLE(rotation.getZ());
        long flagValue = 0L;
        for (PlayerAuthInputData data : packet.getInputData()) {
            flagValue |= 1L << data.ordinal();
        }
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)flagValue);
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getInputMode().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getPlayMode().ordinal());
        this.writeInteractionModel(buffer, helper, packet);
        if (packet.getPlayMode() == ClientPlayMode.REALITY) {
            helper.writeVector3f(buffer, packet.getVrGazeDirection());
        }
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, PlayerAuthInputPacket packet) {
        float x = buffer.readFloatLE();
        float y = buffer.readFloatLE();
        packet.setPosition(helper.readVector3f(buffer));
        packet.setMotion(Vector2f.from((float)buffer.readFloatLE(), (float)buffer.readFloatLE()));
        float z = buffer.readFloatLE();
        packet.setRotation(Vector3f.from((float)x, (float)y, (float)z));
        long flagValue = VarInts.readUnsignedLong((ByteBuf)buffer);
        Set flags = packet.getInputData();
        for (PlayerAuthInputData flag : PlayerAuthInputData.values()) {
            if ((flagValue & 1L << flag.ordinal()) == 0L) continue;
            flags.add(flag);
        }
        packet.setInputMode(INPUT_MODES[VarInts.readUnsignedInt((ByteBuf)buffer)]);
        packet.setPlayMode(CLIENT_PLAY_MODES[VarInts.readUnsignedInt((ByteBuf)buffer)]);
        this.readInteractionModel(buffer, helper, packet);
        if (packet.getPlayMode() == ClientPlayMode.REALITY) {
            packet.setVrGazeDirection(helper.readVector3f(buffer));
        }
    }

    protected void readInteractionModel(ByteBuf buffer, BedrockPacketHelper helper, PlayerAuthInputPacket packet) {
    }

    protected void writeInteractionModel(ByteBuf buffer, BedrockPacketHelper helper, PlayerAuthInputPacket packet) {
    }

    protected PlayerAuthInputSerializer_v388() {
    }
}

