/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v340;

import com.nukkitx.nbt.NBTInputStream;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.InventoryTransactionPacket;
import com.nukkitx.protocol.bedrock.v332.BedrockPacketHelper_v332;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BedrockPacketHelper_v340
extends BedrockPacketHelper_v332 {
    public static final BedrockPacketHelper INSTANCE = new BedrockPacketHelper_v340();

    protected void registerCommandParams() {
        this.addCommandParam(1, CommandParam.INT);
        this.addCommandParam(2, CommandParam.FLOAT);
        this.addCommandParam(3, CommandParam.VALUE);
        this.addCommandParam(4, CommandParam.WILDCARD_INT);
        this.addCommandParam(5, CommandParam.OPERATOR);
        this.addCommandParam(6, CommandParam.TARGET);
        this.addCommandParam(7, CommandParam.WILDCARD_TARGET);
        this.addCommandParam(14, CommandParam.FILE_PATH);
        this.addCommandParam(18, CommandParam.INT_RANGE);
        this.addCommandParam(27, CommandParam.STRING);
        this.addCommandParam(29, CommandParam.POSITION);
        this.addCommandParam(32, CommandParam.MESSAGE);
        this.addCommandParam(34, CommandParam.TEXT);
        this.addCommandParam(37, CommandParam.JSON);
        this.addCommandParam(44, CommandParam.COMMAND);
    }

    protected void registerEntityData() {
        super.registerEntityData();
        this.addEntityData(39, EntityData.HAS_NPC_COMPONENT);
        this.addEntityData(99, EntityData.INTERACTIVE_TAG);
        this.addEntityData(100, EntityData.TRADE_TIER);
        this.addEntityData(101, EntityData.MAX_TRADE_TIER);
    }

    protected void registerEntityFlags() {
        super.registerEntityFlags();
        this.addEntityFlag(71, EntityFlag.BLOCKING);
        this.addEntityFlag(72, EntityFlag.TRANSITION_BLOCKING);
        this.addEntityFlag(73, EntityFlag.BLOCKED_USING_SHIELD);
        this.addEntityFlag(74, EntityFlag.SLEEPING);
        this.addEntityFlag(75, EntityFlag.WANTS_TO_WAKE);
        this.addEntityFlag(76, EntityFlag.TRADE_INTEREST);
        this.addEntityFlag(77, EntityFlag.DOOR_BREAKER);
        this.addEntityFlag(78, EntityFlag.BREAKING_OBSTRUCTION);
        this.addEntityFlag(79, EntityFlag.DOOR_OPENER);
    }

    protected void registerSoundEvents() {
        super.registerSoundEvents();
        this.addSoundEvent(255, SoundEvent.SHIELD_BLOCK);
        this.addSoundEvent(256, SoundEvent.LECTERN_BOOK_PLACE);
        this.addSoundEvent(257, SoundEvent.UNDEFINED);
    }

    public ItemData readItem(ByteBuf buffer, BedrockSession session) {
        NbtMap compoundTag;
        int count;
        int damage;
        int id;
        block36: {
            id = VarInts.readInt((ByteBuf)buffer);
            if (id == 0) {
                return ItemData.AIR;
            }
            int aux = VarInts.readInt((ByteBuf)buffer);
            damage = aux >> 8;
            if (damage == Short.MAX_VALUE) {
                damage = -1;
            }
            count = aux & 0xFF;
            short nbtSize = buffer.readShortLE();
            compoundTag = null;
            if (nbtSize > 0) {
                try (NBTInputStream reader = NbtUtils.createReaderLE((InputStream)new ByteBufInputStream(buffer.readSlice((int)nbtSize)));){
                    compoundTag = (NbtMap)reader.readTag();
                    break block36;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load NBT data", e);
                }
            }
            if (nbtSize == -1) {
                short tagCount = buffer.readUnsignedByte();
                if (tagCount != 1) {
                    throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
                }
                try (NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));){
                    compoundTag = (NbtMap)reader.readTag();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load NBT data", e);
                }
            }
        }
        String[] canPlace = new String[VarInts.readInt((ByteBuf)buffer)];
        for (int i = 0; i < canPlace.length; ++i) {
            canPlace[i] = this.readString(buffer);
        }
        String[] canBreak = new String[VarInts.readInt((ByteBuf)buffer)];
        for (int i = 0; i < canBreak.length; ++i) {
            canBreak[i] = this.readString(buffer);
        }
        long blockingTicks = 0L;
        if (this.isBlockingItem(id, session)) {
            blockingTicks = VarInts.readLong((ByteBuf)buffer);
        }
        return ItemData.builder().id(id).damage(damage).count(count).tag(compoundTag).canPlace(canPlace).canBreak(canBreak).blockingTicks(blockingTicks).build();
    }

    public void writeItem(ByteBuf buffer, ItemData item, BedrockSession session) {
        super.writeItem(buffer, item, session);
        if (this.isBlockingItem(item.getId(), session)) {
            VarInts.writeLong((ByteBuf)buffer, (long)item.getBlockingTicks());
        }
    }

    public void readItemUse(ByteBuf buffer, InventoryTransactionPacket packet, BedrockSession session) {
        super.readItemUse(buffer, packet, session);
        packet.setBlockRuntimeId(VarInts.readUnsignedInt((ByteBuf)buffer));
    }

    public void writeItemUse(ByteBuf buffer, InventoryTransactionPacket packet, BedrockSession session) {
        super.writeItemUse(buffer, packet, session);
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getBlockRuntimeId());
    }

    protected BedrockPacketHelper_v340() {
    }
}

