/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v332.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.event.EventData;
import com.nukkitx.protocol.bedrock.data.event.EventDataType;
import com.nukkitx.protocol.bedrock.data.event.MobBornEventData;
import com.nukkitx.protocol.bedrock.data.event.PetDiedEventData;
import com.nukkitx.protocol.bedrock.v291.serializer.EventSerializer_v291;
import io.netty.buffer.ByteBuf;

public class EventSerializer_v332
extends EventSerializer_v291 {
    public static final EventSerializer_v332 INSTANCE = new EventSerializer_v332();

    protected EventSerializer_v332() {
        this.readers.put(EventDataType.MOB_BORN, this::readMobBorn);
        this.readers.put(EventDataType.PET_DIED, this::readPetDied);
        this.writers.put(EventDataType.MOB_BORN, this::writeMobBorn);
        this.writers.put(EventDataType.PET_DIED, this::writePetDied);
    }

    protected MobBornEventData readMobBorn(ByteBuf buffer, BedrockPacketHelper helper) {
        int entityType = VarInts.readInt((ByteBuf)buffer);
        int variant = VarInts.readInt((ByteBuf)buffer);
        short color = buffer.readUnsignedByte();
        return new MobBornEventData(entityType, variant, (int)color);
    }

    protected void writeMobBorn(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        MobBornEventData event = (MobBornEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getEntityType());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getVariant());
        buffer.writeByte(event.getColor());
    }

    protected PetDiedEventData readPetDied(ByteBuf buffer, BedrockPacketHelper helper) {
        boolean killedByOwner = buffer.readBoolean();
        long killerUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
        long petUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
        int entityDamageCause = VarInts.readInt((ByteBuf)buffer);
        return new PetDiedEventData(killedByOwner, killerUniqueEntityId, petUniqueEntityId, entityDamageCause, -1);
    }

    protected void writePetDied(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        PetDiedEventData event = (PetDiedEventData)eventData;
        buffer.writeBoolean(event.isOwnerKilled());
        VarInts.writeLong((ByteBuf)buffer, (long)event.getKillerUniqueEntityId());
        VarInts.writeLong((ByteBuf)buffer, (long)event.getPetUniqueEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getEntityDamageCause());
    }
}

