/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.AttributeData;
import com.nukkitx.protocol.bedrock.packet.AddEntityPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Objects;

public class AddEntitySerializer_v291
implements BedrockPacketSerializer<AddEntityPacket> {
    public static final AddEntitySerializer_v291 INSTANCE = new AddEntitySerializer_v291();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, AddEntityPacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getEntityType());
        helper.writeVector3f(buffer, packet.getPosition());
        helper.writeVector3f(buffer, packet.getMotion());
        helper.writeVector3f(buffer, packet.getRotation());
        helper.writeArray(buffer, (Collection)packet.getAttributes(), this::writeAttribute);
        helper.writeEntityData(buffer, packet.getMetadata());
        helper.writeArray(buffer, (Collection)packet.getEntityLinks(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeEntityLink(arg_0, arg_1));
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, AddEntityPacket packet) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setEntityType(VarInts.readUnsignedInt((ByteBuf)buffer));
        packet.setPosition(helper.readVector3f(buffer));
        packet.setMotion(helper.readVector3f(buffer));
        packet.setRotation(helper.readVector3f(buffer));
        helper.readArray(buffer, (Collection)packet.getAttributes(), this::readAttribute);
        helper.readEntityData(buffer, packet.getMetadata());
        helper.readArray(buffer, (Collection)packet.getEntityLinks(), arg_0 -> ((BedrockPacketHelper)helper).readEntityLink(arg_0));
    }

    public AttributeData readAttribute(ByteBuf buffer, BedrockPacketHelper helper) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        String name = helper.readString(buffer);
        float min = buffer.readFloatLE();
        float max = buffer.readFloatLE();
        float val = buffer.readFloatLE();
        return new AttributeData(name, min, max, val);
    }

    public void writeAttribute(ByteBuf buffer, BedrockPacketHelper helper, AttributeData attribute) {
        Objects.requireNonNull(attribute, "attribute is null");
        helper.writeString(buffer, attribute.getName());
        buffer.writeFloatLE(attribute.getMinimum());
        buffer.writeFloatLE(attribute.getMaximum());
        buffer.writeFloatLE(attribute.getValue());
    }

    protected AddEntitySerializer_v291() {
    }
}

