/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.packet.PlayerListPacket;
import io.netty.buffer.ByteBuf;

public class PlayerListSerializer_v291
implements BedrockPacketSerializer<PlayerListPacket> {
    public static final PlayerListSerializer_v291 INSTANCE = new PlayerListSerializer_v291();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, PlayerListPacket packet) {
        buffer.writeByte(packet.getAction().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getEntries().size());
        for (PlayerListPacket.Entry entry : packet.getEntries()) {
            helper.writeUuid(buffer, entry.getUuid());
            if (packet.getAction() != PlayerListPacket.Action.ADD) continue;
            VarInts.writeLong((ByteBuf)buffer, (long)entry.getEntityId());
            helper.writeString(buffer, entry.getName());
            SerializedSkin skin = entry.getSkin();
            helper.writeString(buffer, skin.getSkinId());
            skin.getSkinData().checkLegacySkinSize();
            helper.writeByteArray(buffer, skin.getSkinData().getImage());
            skin.getCapeData().checkLegacyCapeSize();
            helper.writeByteArray(buffer, skin.getCapeData().getImage());
            helper.writeString(buffer, skin.getGeometryName());
            helper.writeString(buffer, skin.getGeometryData());
            helper.writeString(buffer, entry.getXuid());
            helper.writeString(buffer, entry.getPlatformChatId());
        }
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, PlayerListPacket packet) {
        PlayerListPacket.Action action = PlayerListPacket.Action.values()[buffer.readUnsignedByte()];
        packet.setAction(action);
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        for (int i = 0; i < length; ++i) {
            PlayerListPacket.Entry entry = new PlayerListPacket.Entry(helper.readUuid(buffer));
            if (action == PlayerListPacket.Action.ADD) {
                entry.setEntityId(VarInts.readLong((ByteBuf)buffer));
                entry.setName(helper.readString(buffer));
                String skinId = helper.readString(buffer);
                ImageData skinData = ImageData.of((byte[])helper.readByteArray(buffer));
                ImageData capeData = ImageData.of((int)64, (int)32, (byte[])helper.readByteArray(buffer));
                String geometryName = helper.readString(buffer);
                String geometryData = helper.readString(buffer);
                entry.setSkin(SerializedSkin.of((String)skinId, (String)"", (ImageData)skinData, (ImageData)capeData, (String)geometryName, (String)geometryData, (boolean)false));
                entry.setXuid(helper.readString(buffer));
                entry.setPlatformChatId(helper.readString(buffer));
            }
            packet.getEntries().add(entry);
        }
    }

    protected PlayerListSerializer_v291() {
    }
}

