/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ItemStackResponsePacket
extends BedrockPacket {
    private final List<Response> entries = new ArrayList<Response>();

    @Override
    public boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.ITEM_STACK_RESPONSE;
    }

    public List<Response> getEntries() {
        return this.entries;
    }

    @Override
    public String toString() {
        return "ItemStackResponsePacket(entries=" + this.getEntries() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackResponsePacket)) {
            return false;
        }
        ItemStackResponsePacket other = (ItemStackResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Response> this$entries = this.getEntries();
        List<Response> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ItemStackResponsePacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Response> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public static final class ItemEntry {
        private final byte slot;
        private final byte hotbarSlot;
        private final byte count;
        private final int stackNetworkId;
        @NonNull
        private final String customName;
        private final int durabilityCorrection;

        public ItemEntry(byte slot, byte hotbarSlot, byte count, int stackNetworkId, @NonNull String customName, int durabilityCorrection) {
            if (customName == null) {
                throw new NullPointerException("customName is marked non-null but is null");
            }
            this.slot = slot;
            this.hotbarSlot = hotbarSlot;
            this.count = count;
            this.stackNetworkId = stackNetworkId;
            this.customName = customName;
            this.durabilityCorrection = durabilityCorrection;
        }

        public byte getSlot() {
            return this.slot;
        }

        public byte getHotbarSlot() {
            return this.hotbarSlot;
        }

        public byte getCount() {
            return this.count;
        }

        public int getStackNetworkId() {
            return this.stackNetworkId;
        }

        @NonNull
        public String getCustomName() {
            return this.customName;
        }

        public int getDurabilityCorrection() {
            return this.durabilityCorrection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemEntry)) {
                return false;
            }
            ItemEntry other = (ItemEntry)o;
            if (this.getSlot() != other.getSlot()) {
                return false;
            }
            if (this.getHotbarSlot() != other.getHotbarSlot()) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.getStackNetworkId() != other.getStackNetworkId()) {
                return false;
            }
            String this$customName = this.getCustomName();
            String other$customName = other.getCustomName();
            if (this$customName == null ? other$customName != null : !this$customName.equals(other$customName)) {
                return false;
            }
            return this.getDurabilityCorrection() == other.getDurabilityCorrection();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSlot();
            result = result * 59 + this.getHotbarSlot();
            result = result * 59 + this.getCount();
            result = result * 59 + this.getStackNetworkId();
            String $customName = this.getCustomName();
            result = result * 59 + ($customName == null ? 43 : $customName.hashCode());
            result = result * 59 + this.getDurabilityCorrection();
            return result;
        }

        public String toString() {
            return "ItemStackResponsePacket.ItemEntry(slot=" + this.getSlot() + ", hotbarSlot=" + this.getHotbarSlot() + ", count=" + this.getCount() + ", stackNetworkId=" + this.getStackNetworkId() + ", customName=" + this.getCustomName() + ", durabilityCorrection=" + this.getDurabilityCorrection() + ")";
        }
    }

    public static final class ContainerEntry {
        private final ContainerSlotType container;
        private final List<ItemEntry> items;

        public ContainerEntry(ContainerSlotType container, List<ItemEntry> items) {
            this.container = container;
            this.items = items;
        }

        public ContainerSlotType getContainer() {
            return this.container;
        }

        public List<ItemEntry> getItems() {
            return this.items;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContainerEntry)) {
                return false;
            }
            ContainerEntry other = (ContainerEntry)o;
            ContainerSlotType this$container = this.getContainer();
            ContainerSlotType other$container = other.getContainer();
            if (this$container == null ? other$container != null : !((Object)((Object)this$container)).equals((Object)other$container)) {
                return false;
            }
            List<ItemEntry> this$items = this.getItems();
            List<ItemEntry> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ContainerSlotType $container = this.getContainer();
            result = result * 59 + ($container == null ? 43 : ((Object)((Object)$container)).hashCode());
            List<ItemEntry> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        public String toString() {
            return "ItemStackResponsePacket.ContainerEntry(container=" + (Object)((Object)this.getContainer()) + ", items=" + this.getItems() + ")";
        }
    }

    public static final class Response {
        @Deprecated
        private final boolean success;
        private final ResponseStatus result;
        private final int requestId;
        private final List<ContainerEntry> containers;

        @Deprecated
        public Response(boolean success, int requestId, List<ContainerEntry> containers) {
            this.success = success;
            this.requestId = requestId;
            this.containers = containers;
            this.result = success ? ResponseStatus.OK : ResponseStatus.ERROR;
        }

        public Response(ResponseStatus result, int requestId, List<ContainerEntry> containers) {
            this.result = result;
            this.requestId = requestId;
            this.containers = containers;
            this.success = false;
        }

        @Deprecated
        public boolean isSuccess() {
            return this.success;
        }

        public ResponseStatus getResult() {
            return this.result;
        }

        public int getRequestId() {
            return this.requestId;
        }

        public List<ContainerEntry> getContainers() {
            return this.containers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            ResponseStatus this$result = this.getResult();
            ResponseStatus other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            List<ContainerEntry> this$containers = this.getContainers();
            List<ContainerEntry> other$containers = other.getContainers();
            return !(this$containers == null ? other$containers != null : !((Object)this$containers).equals(other$containers));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            ResponseStatus $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
            result = result * 59 + this.getRequestId();
            List<ContainerEntry> $containers = this.getContainers();
            result = result * 59 + ($containers == null ? 43 : ((Object)$containers).hashCode());
            return result;
        }

        public String toString() {
            return "ItemStackResponsePacket.Response(result=" + (Object)((Object)this.getResult()) + ", requestId=" + this.getRequestId() + ", containers=" + this.getContainers() + ")";
        }
    }

    public static enum ResponseStatus {
        OK,
        ERROR;

    }
}

