/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.data.inventory.InventoryActionData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.data.inventory.LegacySetItemSlotData;
import com.nukkitx.protocol.bedrock.data.inventory.TransactionType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class InventoryTransactionPacket
extends BedrockPacket {
    private int legacyRequestId;
    private final List<LegacySetItemSlotData> legacySlots = new ObjectArrayList();
    private final List<InventoryActionData> actions = new ObjectArrayList();
    private TransactionType transactionType;
    private int actionType;
    private long runtimeEntityId;
    private Vector3i blockPosition;
    private int blockFace;
    private int hotbarSlot;
    private ItemData itemInHand;
    private Vector3f playerPosition;
    private Vector3f clickPosition;
    private Vector3f headPosition;
    private boolean usingNetIds;
    private int blockRuntimeId;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.INVENTORY_TRANSACTION;
    }

    public int getLegacyRequestId() {
        return this.legacyRequestId;
    }

    public List<LegacySetItemSlotData> getLegacySlots() {
        return this.legacySlots;
    }

    public List<InventoryActionData> getActions() {
        return this.actions;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public int getActionType() {
        return this.actionType;
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public int getBlockFace() {
        return this.blockFace;
    }

    public int getHotbarSlot() {
        return this.hotbarSlot;
    }

    public ItemData getItemInHand() {
        return this.itemInHand;
    }

    public Vector3f getPlayerPosition() {
        return this.playerPosition;
    }

    public Vector3f getClickPosition() {
        return this.clickPosition;
    }

    public Vector3f getHeadPosition() {
        return this.headPosition;
    }

    @Deprecated
    public boolean isUsingNetIds() {
        return this.usingNetIds;
    }

    public int getBlockRuntimeId() {
        return this.blockRuntimeId;
    }

    public void setLegacyRequestId(int legacyRequestId) {
        this.legacyRequestId = legacyRequestId;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public void setBlockFace(int blockFace) {
        this.blockFace = blockFace;
    }

    public void setHotbarSlot(int hotbarSlot) {
        this.hotbarSlot = hotbarSlot;
    }

    public void setItemInHand(ItemData itemInHand) {
        this.itemInHand = itemInHand;
    }

    public void setPlayerPosition(Vector3f playerPosition) {
        this.playerPosition = playerPosition;
    }

    public void setClickPosition(Vector3f clickPosition) {
        this.clickPosition = clickPosition;
    }

    public void setHeadPosition(Vector3f headPosition) {
        this.headPosition = headPosition;
    }

    @Deprecated
    public void setUsingNetIds(boolean usingNetIds) {
        this.usingNetIds = usingNetIds;
    }

    public void setBlockRuntimeId(int blockRuntimeId) {
        this.blockRuntimeId = blockRuntimeId;
    }

    @Override
    public String toString() {
        return "InventoryTransactionPacket(legacyRequestId=" + this.getLegacyRequestId() + ", legacySlots=" + this.getLegacySlots() + ", actions=" + this.getActions() + ", transactionType=" + (Object)((Object)this.getTransactionType()) + ", actionType=" + this.getActionType() + ", runtimeEntityId=" + this.getRuntimeEntityId() + ", blockPosition=" + this.getBlockPosition() + ", blockFace=" + this.getBlockFace() + ", hotbarSlot=" + this.getHotbarSlot() + ", itemInHand=" + this.getItemInHand() + ", playerPosition=" + this.getPlayerPosition() + ", clickPosition=" + this.getClickPosition() + ", headPosition=" + this.getHeadPosition() + ", usingNetIds=" + this.isUsingNetIds() + ", blockRuntimeId=" + this.getBlockRuntimeId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryTransactionPacket)) {
            return false;
        }
        InventoryTransactionPacket other = (InventoryTransactionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.legacyRequestId != other.legacyRequestId) {
            return false;
        }
        List<LegacySetItemSlotData> this$legacySlots = this.legacySlots;
        List<LegacySetItemSlotData> other$legacySlots = other.legacySlots;
        if (this$legacySlots == null ? other$legacySlots != null : !((Object)this$legacySlots).equals(other$legacySlots)) {
            return false;
        }
        List<InventoryActionData> this$actions = this.actions;
        List<InventoryActionData> other$actions = other.actions;
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        TransactionType this$transactionType = this.transactionType;
        TransactionType other$transactionType = other.transactionType;
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        if (this.actionType != other.actionType) {
            return false;
        }
        if (this.runtimeEntityId != other.runtimeEntityId) {
            return false;
        }
        Vector3i this$blockPosition = this.blockPosition;
        Vector3i other$blockPosition = other.blockPosition;
        if (this$blockPosition == null ? other$blockPosition != null : !this$blockPosition.equals(other$blockPosition)) {
            return false;
        }
        if (this.blockFace != other.blockFace) {
            return false;
        }
        if (this.hotbarSlot != other.hotbarSlot) {
            return false;
        }
        ItemData this$itemInHand = this.itemInHand;
        ItemData other$itemInHand = other.itemInHand;
        if (this$itemInHand == null ? other$itemInHand != null : !((Object)this$itemInHand).equals(other$itemInHand)) {
            return false;
        }
        Vector3f this$playerPosition = this.playerPosition;
        Vector3f other$playerPosition = other.playerPosition;
        if (this$playerPosition == null ? other$playerPosition != null : !this$playerPosition.equals(other$playerPosition)) {
            return false;
        }
        Vector3f this$clickPosition = this.clickPosition;
        Vector3f other$clickPosition = other.clickPosition;
        if (this$clickPosition == null ? other$clickPosition != null : !this$clickPosition.equals(other$clickPosition)) {
            return false;
        }
        Vector3f this$headPosition = this.headPosition;
        Vector3f other$headPosition = other.headPosition;
        if (this$headPosition == null ? other$headPosition != null : !this$headPosition.equals(other$headPosition)) {
            return false;
        }
        if (this.usingNetIds != other.usingNetIds) {
            return false;
        }
        return this.blockRuntimeId == other.blockRuntimeId;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InventoryTransactionPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.legacyRequestId;
        List<LegacySetItemSlotData> $legacySlots = this.legacySlots;
        result = result * 59 + ($legacySlots == null ? 43 : ((Object)$legacySlots).hashCode());
        List<InventoryActionData> $actions = this.actions;
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        TransactionType $transactionType = this.transactionType;
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        result = result * 59 + this.actionType;
        long $runtimeEntityId = this.runtimeEntityId;
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        Vector3i $blockPosition = this.blockPosition;
        result = result * 59 + ($blockPosition == null ? 43 : $blockPosition.hashCode());
        result = result * 59 + this.blockFace;
        result = result * 59 + this.hotbarSlot;
        ItemData $itemInHand = this.itemInHand;
        result = result * 59 + ($itemInHand == null ? 43 : ((Object)$itemInHand).hashCode());
        Vector3f $playerPosition = this.playerPosition;
        result = result * 59 + ($playerPosition == null ? 43 : $playerPosition.hashCode());
        Vector3f $clickPosition = this.clickPosition;
        result = result * 59 + ($clickPosition == null ? 43 : $clickPosition.hashCode());
        Vector3f $headPosition = this.headPosition;
        result = result * 59 + ($headPosition == null ? 43 : $headPosition.hashCode());
        result = result * 59 + (this.usingNetIds ? 79 : 97);
        result = result * 59 + this.blockRuntimeId;
        return result;
    }
}

