/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;

public class PlaySoundPacket
extends BedrockPacket {
    private String sound;
    private Vector3f position;
    private float volume;
    private float pitch;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.PLAY_SOUND;
    }

    public String getSound() {
        return this.sound;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Override
    public String toString() {
        return "PlaySoundPacket(sound=" + this.getSound() + ", position=" + this.getPosition() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlaySoundPacket)) {
            return false;
        }
        PlaySoundPacket other = (PlaySoundPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sound = this.sound;
        String other$sound = other.sound;
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        Vector3f this$position = this.position;
        Vector3f other$position = other.position;
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        if (Float.compare(this.volume, other.volume) != 0) {
            return false;
        }
        return Float.compare(this.pitch, other.pitch) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PlaySoundPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sound = this.sound;
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        Vector3f $position = this.position;
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        result = result * 59 + Float.floatToIntBits(this.volume);
        result = result * 59 + Float.floatToIntBits(this.pitch);
        return result;
    }
}

