/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormattedUrl;", "", "scheme", "", "host", "port", "", "path", "query", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getScheme", "()Ljava/lang/String;", "getHost", "getPort", "()I", "getPath", "getQuery", "pathWithQuery", "getPathWithQuery", "url", "getUrl", "shouldShowPort", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class FormattedUrl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scheme;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String path;
    @NotNull
    private final String query;
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;

    private FormattedUrl(String scheme, String host, int port, String path, String query) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    @NotNull
    public final String getPathWithQuery() {
        return StringsKt.isBlank((CharSequence)this.query) ? this.path : this.path + "?" + this.query;
    }

    @NotNull
    public final String getUrl() {
        return this.shouldShowPort() ? this.scheme + "://" + this.host + ":" + this.port + this.getPathWithQuery() : this.scheme + "://" + this.host + this.getPathWithQuery();
    }

    private final boolean shouldShowPort() {
        if (Intrinsics.areEqual((Object)this.scheme, (Object)"https") && this.port == 443) {
            return false;
        }
        return !Intrinsics.areEqual((Object)this.scheme, (Object)"http") || this.port != 80;
    }

    public /* synthetic */ FormattedUrl(String scheme, String host, int port, String path, String query, DefaultConstructorMarker $constructor_marker) {
        this(scheme, host, port, path, query);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormattedUrl$Companion;", "", "<init>", "()V", "HTTPS_PORT", "", "HTTP_PORT", "fromHttpUrl", "Lcom/chuckerteam/chucker/internal/support/FormattedUrl;", "httpUrl", "Lokhttp3/HttpUrl;", "encoded", "", "encodedUrl", "decodedUrl", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FormattedUrl fromHttpUrl(@NotNull HttpUrl httpUrl, boolean encoded) {
            Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"httpUrl");
            return encoded ? this.encodedUrl(httpUrl) : this.decodedUrl(httpUrl);
        }

        private final FormattedUrl encodedUrl(HttpUrl httpUrl) {
            String path = CollectionsKt.joinToString$default((Iterable)httpUrl.encodedPathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String string2 = httpUrl.scheme();
            String string3 = httpUrl.host();
            int n = httpUrl.port();
            Object object = !StringsKt.isBlank((CharSequence)path) ? "/" + path : "";
            String string4 = httpUrl.encodedQuery();
            if (string4 == null) {
                string4 = "";
            }
            return new FormattedUrl(string2, string3, n, (String)object, string4, null);
        }

        private final FormattedUrl decodedUrl(HttpUrl httpUrl) {
            String path = CollectionsKt.joinToString$default((Iterable)httpUrl.pathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String string2 = httpUrl.scheme();
            String string3 = httpUrl.host();
            int n = httpUrl.port();
            Object object = !StringsKt.isBlank((CharSequence)path) ? "/" + path : "";
            String string4 = httpUrl.query();
            if (string4 == null) {
                string4 = "";
            }
            return new FormattedUrl(string2, string3, n, (String)object, string4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

