/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.BodyDecoder;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.LimitingSource;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.OkHttpUtilsKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/chuckerteam/chucker/internal/support/RequestProcessor;", "", "context", "Landroid/content/Context;", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "maxContentLength", "", "headersToRedact", "", "", "bodyDecoders", "", "Lcom/chuckerteam/chucker/api/BodyDecoder;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLjava/util/Set;Ljava/util/List;)V", "decodePayload", "request", "Lokhttp3/Request;", "body", "Lokio/ByteString;", "isGraphQLRequest", "", "graphQLOperationName", "process", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "processMetadata", "processPayload", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nRequestProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestProcessor.kt\ncom/chuckerteam/chucker/internal/support/RequestProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class RequestProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final ChuckerCollector collector;
    private final long maxContentLength;
    @NotNull
    private final Set<String> headersToRedact;
    @NotNull
    private final List<BodyDecoder> bodyDecoders;

    public RequestProcessor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull Set<String> headersToRedact, @NotNull List<? extends BodyDecoder> bodyDecoders) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter(headersToRedact, (String)"headersToRedact");
        Intrinsics.checkNotNullParameter(bodyDecoders, (String)"bodyDecoders");
        this.context = context;
        this.collector = collector;
        this.maxContentLength = maxContentLength;
        this.headersToRedact = headersToRedact;
        this.bodyDecoders = bodyDecoders;
    }

    public final void process(@NotNull Request request, @NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.processMetadata(request, transaction);
        this.processPayload(request, transaction);
        this.collector.onRequestSent$com_github_ChuckerTeam_Chucker_library(transaction);
    }

    private final void processMetadata(Request request, HttpTransaction transaction) {
        HttpTransaction httpTransaction;
        HttpTransaction $this$processMetadata_u24lambda_u241 = httpTransaction = transaction;
        boolean bl = false;
        $this$processMetadata_u24lambda_u241.setRequestHeadersSize(request.headers().byteCount());
        Headers it = OkHttpUtilsKt.redact(request.headers(), (Iterable<String>)this.headersToRedact);
        boolean bl2 = false;
        $this$processMetadata_u24lambda_u241.setRequestHeaders(it);
        $this$processMetadata_u24lambda_u241.setGraphQlOperationName(it);
        $this$processMetadata_u24lambda_u241.populateUrl(request.url());
        $this$processMetadata_u24lambda_u241.setGraphQlDetected(this.isGraphQLRequest($this$processMetadata_u24lambda_u241.getGraphQlOperationName(), request));
        $this$processMetadata_u24lambda_u241.setRequestDate(System.currentTimeMillis());
        $this$processMetadata_u24lambda_u241.setMethod(request.method());
        RequestBody requestBody = request.body();
        $this$processMetadata_u24lambda_u241.setRequestContentType(requestBody != null && (requestBody = requestBody.contentType()) != null ? requestBody.toString() : null);
        RequestBody requestBody2 = request.body();
        $this$processMetadata_u24lambda_u241.setRequestPayloadSize(requestBody2 != null ? Long.valueOf(requestBody2.contentLength()) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processPayload(Request request, HttpTransaction transaction) {
        Buffer buffer3;
        Buffer buffer2;
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return;
        }
        RequestBody body = requestBody;
        if (body.isOneShot()) {
            Logger.DefaultImpls.info$default(Logger.Companion, "Skipping one shot request body", null, 2, null);
            return;
        }
        if (body.isDuplex()) {
            Logger.DefaultImpls.info$default(Logger.Companion, "Skipping duplex request body", null, 2, null);
            return;
        }
        try {
            Buffer $this$processPayload_u24lambda_u242 = buffer2 = new Buffer();
            boolean buffer3 = false;
            body.writeTo((BufferedSink)$this$processPayload_u24lambda_u242);
        }
        catch (IOException e) {
            Logger.Companion.error("Failed to read request payload", e);
            return;
        }
        Buffer requestSource = buffer2;
        LimitingSource limitingSource = new LimitingSource(OkHttpUtilsKt.uncompress((Source)requestSource, request.headers()), this.maxContentLength);
        Buffer $this$processPayload_u24lambda_u244 = buffer3 = new Buffer();
        boolean bl = false;
        Closeable closeable = (Closeable)((Object)limitingSource);
        Throwable throwable = null;
        try {
            LimitingSource it = (LimitingSource)((Object)closeable);
            boolean bl2 = false;
            $this$processPayload_u24lambda_u244.writeAll((Source)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Buffer contentBuffer = buffer3;
        String decodedContent = this.decodePayload(request, contentBuffer.readByteString());
        transaction.setRequestBody(decodedContent);
        transaction.setRequestBodyEncoded(decodedContent == null);
        if (decodedContent != null && limitingSource.isThresholdReached()) {
            transaction.setRequestBody(transaction.getRequestBody() + this.context.getString(R.string.chucker_body_content_truncated));
        }
    }

    private final String decodePayload(Request request, ByteString body) {
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.bodyDecoders), (Function1)((Function1)new Function1<BodyDecoder, String>(request, body){
            final /* synthetic */ Request $request;
            final /* synthetic */ ByteString $body;
            {
                this.$request = $request;
                this.$body = $body;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull BodyDecoder decoder) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                try {
                    Logger.DefaultImpls.info$default(Logger.Companion, "Decoding with: " + decoder, null, 2, null);
                    string2 = decoder.decodeRequest(this.$request, this.$body);
                }
                catch (IOException e) {
                    Logger.Companion.warn("Decoder " + decoder + " failed to process request payload", e);
                    string2 = null;
                }
                return string2;
            }
        })));
    }

    private final boolean isGraphQLRequest(String graphQLOperationName, Request request) {
        return graphQLOperationName != null || request.url().pathSegments().contains("graphql") || StringsKt.contains$default((CharSequence)request.url().host(), (CharSequence)"graphql", (boolean)false, (int)2, null);
    }
}

