/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.chuckerteam.chucker.api.BodyDecoder;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.CacheDirectoryProvider;
import com.chuckerteam.chucker.internal.support.PlainTextDecoder;
import com.chuckerteam.chucker.internal.support.RequestProcessor;
import com.chuckerteam.chucker.internal.support.ResponseProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001f\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001d\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "builder", "Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Builder;", "(Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Builder;)V", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "decoders", "", "Lcom/chuckerteam/chucker/api/BodyDecoder;", "headersToRedact", "", "", "requestProcessor", "Lcom/chuckerteam/chucker/internal/support/RequestProcessor;", "responseProcessor", "Lcom/chuckerteam/chucker/internal/support/ResponseProcessor;", "skipPaths", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "redactHeader", "", "headerName", "", "([Ljava/lang/String;)V", "Builder", "Companion", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nChuckerInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChuckerInterceptor.kt\ncom/chuckerteam/chucker/api/ChuckerInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1747#2,3:199\n*S KotlinDebug\n*F\n+ 1 ChuckerInterceptor.kt\ncom/chuckerteam/chucker/api/ChuckerInterceptor\n*L\n74#1:199,3\n*E\n"})
public final class ChuckerInterceptor
implements Interceptor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> headersToRedact;
    @NotNull
    private final List<BodyDecoder> decoders;
    @NotNull
    private final ChuckerCollector collector;
    @NotNull
    private final RequestProcessor requestProcessor;
    @NotNull
    private final ResponseProcessor responseProcessor;
    @NotNull
    private final Set<String> skipPaths;
    private static final long MAX_CONTENT_LENGTH = 250000L;
    @NotNull
    private static final List<PlainTextDecoder> BUILT_IN_DECODERS = CollectionsKt.listOf((Object)PlainTextDecoder.INSTANCE);

    private ChuckerInterceptor(Builder builder) {
        this.headersToRedact = CollectionsKt.toMutableSet((Iterable)builder.getHeadersToRedact$com_github_ChuckerTeam_Chucker_library());
        this.decoders = CollectionsKt.plus((Collection)builder.getDecoders$com_github_ChuckerTeam_Chucker_library(), (Iterable)BUILT_IN_DECODERS);
        ChuckerCollector chuckerCollector = builder.getCollector$com_github_ChuckerTeam_Chucker_library();
        if (chuckerCollector == null) {
            chuckerCollector = new ChuckerCollector(builder.getContext$com_github_ChuckerTeam_Chucker_library(), false, null, 6, null);
        }
        this.collector = chuckerCollector;
        this.requestProcessor = new RequestProcessor(builder.getContext$com_github_ChuckerTeam_Chucker_library(), this.collector, builder.getMaxContentLength$com_github_ChuckerTeam_Chucker_library(), this.headersToRedact, this.decoders);
        CacheDirectoryProvider cacheDirectoryProvider = builder.getCacheDirectoryProvider$com_github_ChuckerTeam_Chucker_library();
        if (cacheDirectoryProvider == null) {
            cacheDirectoryProvider = () -> ChuckerInterceptor.responseProcessor$lambda$0(builder);
        }
        this.responseProcessor = new ResponseProcessor(this.collector, cacheDirectoryProvider, builder.getMaxContentLength$com_github_ChuckerTeam_Chucker_library(), this.headersToRedact, builder.getAlwaysReadResponseBody$com_github_ChuckerTeam_Chucker_library(), this.decoders);
        this.skipPaths = CollectionsKt.toSet((Iterable)builder.getSkipPaths$com_github_ChuckerTeam_Chucker_library());
        if (builder.getCreateShortcut$com_github_ChuckerTeam_Chucker_library()) {
            Chucker.INSTANCE.createShortcut$com_github_ChuckerTeam_Chucker_library(builder.getContext$com_github_ChuckerTeam_Chucker_library());
        }
    }

    public ChuckerInterceptor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new Builder(context));
    }

    public final void redactHeader(String ... headerName) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        CollectionsKt.addAll((Collection)this.headersToRedact, (Object[])headerName);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        boolean shouldProcessTheRequest;
        boolean bl;
        Request request;
        HttpTransaction transaction;
        block6: {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            transaction = new HttpTransaction();
            request = chain.request();
            Iterable $this$any$iv = this.skipPaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)request.url().encodedPath())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl3 = shouldProcessTheRequest = !bl;
        if (shouldProcessTheRequest) {
            this.requestProcessor.process(request, transaction);
        }
        try {
            response = chain.proceed(request);
        }
        catch (IOException e) {
            transaction.setError(e.toString());
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction);
            throw e;
        }
        Response response2 = response;
        return shouldProcessTheRequest ? this.responseProcessor.process(response2, transaction) : response2;
    }

    private static final File responseProcessor$lambda$0(Builder $builder) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        return $builder.getContext$com_github_ChuckerTeam_Chucker_library().getFilesDir();
    }

    public /* synthetic */ ChuckerInterceptor(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u001fJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0006J\u0006\u00108\u001a\u000209J\u0015\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b<J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010=\u001a\u00020,J\u001f\u0010>\u001a\u00020\u00002\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0@\"\u00020&\u00a2\u0006\u0002\u0010AJ\u0014\u0010>\u001a\u00020\u00002\f\u0010?\u001a\b\u0012\u0004\u0012\u00020&0BJ\u001f\u00101\u001a\u00020\u00002\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0@\"\u00020&\u00a2\u0006\u0002\u0010AR\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u0004R\u001a\u0010\u001a\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\nR \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R \u00101\u001a\b\u0012\u0004\u0012\u00020&02X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010(\"\u0004\b4\u0010*\u00a8\u0006C"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alwaysReadResponseBody", "", "getAlwaysReadResponseBody$com_github_ChuckerTeam_Chucker_library", "()Z", "setAlwaysReadResponseBody$com_github_ChuckerTeam_Chucker_library", "(Z)V", "cacheDirectoryProvider", "Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;", "getCacheDirectoryProvider$com_github_ChuckerTeam_Chucker_library", "()Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;", "setCacheDirectoryProvider$com_github_ChuckerTeam_Chucker_library", "(Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;)V", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "getCollector$com_github_ChuckerTeam_Chucker_library", "()Lcom/chuckerteam/chucker/api/ChuckerCollector;", "setCollector$com_github_ChuckerTeam_Chucker_library", "(Lcom/chuckerteam/chucker/api/ChuckerCollector;)V", "getContext$com_github_ChuckerTeam_Chucker_library", "()Landroid/content/Context;", "setContext$com_github_ChuckerTeam_Chucker_library", "createShortcut", "getCreateShortcut$com_github_ChuckerTeam_Chucker_library", "setCreateShortcut$com_github_ChuckerTeam_Chucker_library", "decoders", "", "Lcom/chuckerteam/chucker/api/BodyDecoder;", "getDecoders$com_github_ChuckerTeam_Chucker_library", "()Ljava/util/List;", "setDecoders$com_github_ChuckerTeam_Chucker_library", "(Ljava/util/List;)V", "headersToRedact", "", "", "getHeadersToRedact$com_github_ChuckerTeam_Chucker_library", "()Ljava/util/Set;", "setHeadersToRedact$com_github_ChuckerTeam_Chucker_library", "(Ljava/util/Set;)V", "maxContentLength", "", "getMaxContentLength$com_github_ChuckerTeam_Chucker_library", "()J", "setMaxContentLength$com_github_ChuckerTeam_Chucker_library", "(J)V", "skipPaths", "", "getSkipPaths$com_github_ChuckerTeam_Chucker_library", "setSkipPaths$com_github_ChuckerTeam_Chucker_library", "addBodyDecoder", "decoder", "enable", "build", "Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "cacheDirectorProvider", "provider", "cacheDirectorProvider$com_github_ChuckerTeam_Chucker_library", "length", "redactHeaders", "headerNames", "", "([Ljava/lang/String;)Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Builder;", "", "com.github.ChuckerTeam.Chucker.library"})
    @SourceDebugExtension(value={"SMAP\nChuckerInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChuckerInterceptor.kt\ncom/chuckerteam/chucker/api/ChuckerInterceptor$Builder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,198:1\n13579#2,2:199\n*S KotlinDebug\n*F\n+ 1 ChuckerInterceptor.kt\ncom/chuckerteam/chucker/api/ChuckerInterceptor$Builder\n*L\n177#1:199,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private Context context;
        @Nullable
        private ChuckerCollector collector;
        private long maxContentLength;
        @Nullable
        private CacheDirectoryProvider cacheDirectoryProvider;
        private boolean alwaysReadResponseBody;
        @NotNull
        private Set<String> headersToRedact;
        @NotNull
        private List<? extends BodyDecoder> decoders;
        private boolean createShortcut;
        @NotNull
        private Set<String> skipPaths;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.maxContentLength = 250000L;
            this.headersToRedact = SetsKt.emptySet();
            this.decoders = CollectionsKt.emptyList();
            this.createShortcut = true;
            this.skipPaths = new LinkedHashSet();
        }

        @NotNull
        public final Context getContext$com_github_ChuckerTeam_Chucker_library() {
            return this.context;
        }

        public final void setContext$com_github_ChuckerTeam_Chucker_library(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
            this.context = context;
        }

        @Nullable
        public final ChuckerCollector getCollector$com_github_ChuckerTeam_Chucker_library() {
            return this.collector;
        }

        public final void setCollector$com_github_ChuckerTeam_Chucker_library(@Nullable ChuckerCollector chuckerCollector) {
            this.collector = chuckerCollector;
        }

        public final long getMaxContentLength$com_github_ChuckerTeam_Chucker_library() {
            return this.maxContentLength;
        }

        public final void setMaxContentLength$com_github_ChuckerTeam_Chucker_library(long l) {
            this.maxContentLength = l;
        }

        @Nullable
        public final CacheDirectoryProvider getCacheDirectoryProvider$com_github_ChuckerTeam_Chucker_library() {
            return this.cacheDirectoryProvider;
        }

        public final void setCacheDirectoryProvider$com_github_ChuckerTeam_Chucker_library(@Nullable CacheDirectoryProvider cacheDirectoryProvider) {
            this.cacheDirectoryProvider = cacheDirectoryProvider;
        }

        public final boolean getAlwaysReadResponseBody$com_github_ChuckerTeam_Chucker_library() {
            return this.alwaysReadResponseBody;
        }

        public final void setAlwaysReadResponseBody$com_github_ChuckerTeam_Chucker_library(boolean bl) {
            this.alwaysReadResponseBody = bl;
        }

        @NotNull
        public final Set<String> getHeadersToRedact$com_github_ChuckerTeam_Chucker_library() {
            return this.headersToRedact;
        }

        public final void setHeadersToRedact$com_github_ChuckerTeam_Chucker_library(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.headersToRedact = set;
        }

        @NotNull
        public final List<BodyDecoder> getDecoders$com_github_ChuckerTeam_Chucker_library() {
            return this.decoders;
        }

        public final void setDecoders$com_github_ChuckerTeam_Chucker_library(@NotNull List<? extends BodyDecoder> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.decoders = list;
        }

        public final boolean getCreateShortcut$com_github_ChuckerTeam_Chucker_library() {
            return this.createShortcut;
        }

        public final void setCreateShortcut$com_github_ChuckerTeam_Chucker_library(boolean bl) {
            this.createShortcut = bl;
        }

        @NotNull
        public final Set<String> getSkipPaths$com_github_ChuckerTeam_Chucker_library() {
            return this.skipPaths;
        }

        public final void setSkipPaths$com_github_ChuckerTeam_Chucker_library(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.skipPaths = set;
        }

        @NotNull
        public final Builder collector(@NotNull ChuckerCollector collector) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            Builder $this$collector_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$collector_u24lambda_u240.collector = collector;
            return builder;
        }

        @NotNull
        public final Builder maxContentLength(long length) {
            Builder builder;
            Builder $this$maxContentLength_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$maxContentLength_u24lambda_u241.maxContentLength = length;
            return builder;
        }

        @NotNull
        public final Builder redactHeaders(@NotNull Iterable<String> headerNames) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headerNames, (String)"headerNames");
            Builder $this$redactHeaders_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$redactHeaders_u24lambda_u242.headersToRedact = CollectionsKt.toSet(headerNames);
            return builder;
        }

        @NotNull
        public final Builder redactHeaders(String ... headerNames) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headerNames, (String)"headerNames");
            Builder $this$redactHeaders_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$redactHeaders_u24lambda_u243.headersToRedact = ArraysKt.toSet((Object[])headerNames);
            return builder;
        }

        @NotNull
        public final Builder alwaysReadResponseBody(boolean enable) {
            Builder builder;
            Builder $this$alwaysReadResponseBody_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$alwaysReadResponseBody_u24lambda_u244.alwaysReadResponseBody = enable;
            return builder;
        }

        @NotNull
        public final Builder addBodyDecoder(@NotNull BodyDecoder decoder) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Builder $this$addBodyDecoder_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$addBodyDecoder_u24lambda_u245.decoders = CollectionsKt.plus((Collection)$this$addBodyDecoder_u24lambda_u245.decoders, (Object)decoder);
            return builder;
        }

        @NotNull
        public final Builder createShortcut(boolean enable) {
            Builder builder;
            Builder $this$createShortcut_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$createShortcut_u24lambda_u246.createShortcut = enable;
            return builder;
        }

        @VisibleForTesting
        @NotNull
        public final Builder cacheDirectorProvider$com_github_ChuckerTeam_Chucker_library(@NotNull CacheDirectoryProvider provider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Builder $this$cacheDirectorProvider_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$cacheDirectorProvider_u24lambda_u247.cacheDirectoryProvider = provider;
            return builder;
        }

        @NotNull
        public final Builder skipPaths(String ... skipPaths) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)skipPaths, (String)"skipPaths");
            Builder $this$skipPaths_u24lambda_u249 = builder = this;
            boolean bl = false;
            String[] $this$forEach$iv = skipPaths;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String candidatePath = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host("example.com").addPathSegment(candidatePath).build();
                this.skipPaths.add(httpUrl.encodedPath());
            }
            return builder;
        }

        @NotNull
        public final ChuckerInterceptor build() {
            return new ChuckerInterceptor(this, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Companion;", "", "()V", "BUILT_IN_DECODERS", "", "Lcom/chuckerteam/chucker/internal/support/PlainTextDecoder;", "MAX_CONTENT_LENGTH", "", "com.github.ChuckerTeam.Chucker.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

