/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0018R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "Landroidx/lifecycle/ViewModel;", "transactionId", "", "(J)V", "doesRequestBodyRequireEncoding", "Landroidx/lifecycle/LiveData;", "", "getDoesRequestBodyRequireEncoding", "()Landroidx/lifecycle/LiveData;", "doesUrlRequireEncoding", "getDoesUrlRequireEncoding", "encodeUrl", "getEncodeUrl", "formatRequestBody", "getFormatRequestBody", "mutableEncodeUrl", "Landroidx/lifecycle/MutableLiveData;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "getTransaction", "transactionTitle", "", "getTransactionTitle", "", "encode", "switchUrlEncoding", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionViewModel
extends ViewModel {
    @NotNull
    private final MutableLiveData<Boolean> mutableEncodeUrl = new MutableLiveData((Object)false);
    @NotNull
    private final LiveData<Boolean> encodeUrl = (LiveData)this.mutableEncodeUrl;
    @NotNull
    private final LiveData<String> transactionTitle;
    @NotNull
    private final LiveData<Boolean> doesUrlRequireEncoding;
    @NotNull
    private final LiveData<Boolean> doesRequestBodyRequireEncoding;
    @NotNull
    private final LiveData<HttpTransaction> transaction;
    @NotNull
    private final LiveData<Boolean> formatRequestBody;

    public TransactionViewModel(long transactionId) {
        this.transactionTitle = LiveDataUtilsKt.combineLatest(RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId), this.encodeUrl, transactionTitle.1.INSTANCE);
        LiveData<HttpTransaction> $this$map$iv = RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId);
        boolean $i$f$map = false;
        LiveData liveData = Transformations.map($this$map$iv, (Function)((Function)new Function<HttpTransaction, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                HttpTransaction transaction = (HttpTransaction)it;
                boolean bl = false;
                return transaction == null ? false : !Intrinsics.areEqual((Object)transaction.getFormattedPath(true), (Object)transaction.getFormattedPath(false));
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"Transformations.map(this) { transform(it) }");
        this.doesUrlRequireEncoding = liveData;
        $this$map$iv = RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId);
        $i$f$map = false;
        LiveData liveData2 = Transformations.map($this$map$iv, (Function)((Function)new Function<HttpTransaction, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                boolean bl;
                String string2;
                HttpTransaction transaction = (HttpTransaction)it;
                boolean bl2 = false;
                HttpTransaction httpTransaction = transaction;
                return httpTransaction == null ? false : ((string2 = httpTransaction.getRequestContentType()) == null ? false : (bl = StringsKt.contains((CharSequence)string2, (CharSequence)"x-www-form-urlencoded", (boolean)true)));
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)liveData2, (String)"Transformations.map(this) { transform(it) }");
        this.doesRequestBodyRequireEncoding = liveData2;
        this.transaction = RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId);
        this.formatRequestBody = LiveDataUtilsKt.combineLatest(this.doesRequestBodyRequireEncoding, this.encodeUrl, formatRequestBody.1.INSTANCE);
    }

    @NotNull
    public final LiveData<Boolean> getEncodeUrl() {
        return this.encodeUrl;
    }

    @NotNull
    public final LiveData<String> getTransactionTitle() {
        return this.transactionTitle;
    }

    @NotNull
    public final LiveData<Boolean> getDoesUrlRequireEncoding() {
        return this.doesUrlRequireEncoding;
    }

    @NotNull
    public final LiveData<Boolean> getDoesRequestBodyRequireEncoding() {
        return this.doesRequestBodyRequireEncoding;
    }

    @NotNull
    public final LiveData<HttpTransaction> getTransaction() {
        return this.transaction;
    }

    @NotNull
    public final LiveData<Boolean> getFormatRequestBody() {
        return this.formatRequestBody;
    }

    public final void switchUrlEncoding() {
        Object object = this.encodeUrl.getValue();
        Intrinsics.checkNotNull((Object)object);
        this.encodeUrl((Boolean)object == false);
    }

    public final void encodeUrl(boolean encode) {
        this.mutableEncodeUrl.setValue((Object)encode);
    }
}

