/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormattedUrl;", "", "scheme", "", "host", "port", "", "path", "query", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPath", "pathWithQuery", "getPathWithQuery", "getPort", "()I", "getQuery", "getScheme", "url", "getUrl", "shouldShowPort", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class FormattedUrl {
    @NotNull
    private final String scheme;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String path;
    @NotNull
    private final String query;
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getPathWithQuery() {
        return StringsKt.isBlank((CharSequence)this.query) ? this.path : this.path + '?' + this.query;
    }

    @NotNull
    public final String getUrl() {
        return this.shouldShowPort() ? this.scheme + "://" + this.host + ':' + this.port + this.getPathWithQuery() : this.scheme + "://" + this.host + this.getPathWithQuery();
    }

    private final boolean shouldShowPort() {
        if (Intrinsics.areEqual((Object)this.scheme, (Object)"https") && this.port == 443) {
            return false;
        }
        return !Intrinsics.areEqual((Object)this.scheme, (Object)"http") || this.port != 80;
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    private FormattedUrl(String scheme, String host, int port, String path, String query) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
    }

    public /* synthetic */ FormattedUrl(String scheme, String host, int port, String path, String query, DefaultConstructorMarker $constructor_marker) {
        this(scheme, host, port, path, query);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormattedUrl$Companion;", "", "()V", "HTTPS_PORT", "", "HTTP_PORT", "decodedUrl", "Lcom/chuckerteam/chucker/internal/support/FormattedUrl;", "httpUrl", "Lokhttp3/HttpUrl;", "encodedUrl", "fromHttpUrl", "encoded", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        @NotNull
        public final FormattedUrl fromHttpUrl(@NotNull HttpUrl httpUrl, boolean encoded) {
            Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"httpUrl");
            return encoded ? this.encodedUrl(httpUrl) : this.decodedUrl(httpUrl);
        }

        private final FormattedUrl encodedUrl(HttpUrl httpUrl) {
            List list = httpUrl.encodedPathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"httpUrl.encodedPathSegments()");
            String path = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String string2 = httpUrl.scheme();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"httpUrl.scheme()");
            String string3 = httpUrl.host();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"httpUrl.host()");
            int n = httpUrl.port();
            CharSequence charSequence = path;
            boolean bl = false;
            String string4 = !StringsKt.isBlank((CharSequence)charSequence) ? '/' + path : "";
            charSequence = httpUrl.encodedQuery();
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                charSequence2 = "";
            }
            return new FormattedUrl(string2, string3, n, string4, (String)charSequence2, null);
        }

        private final FormattedUrl decodedUrl(HttpUrl httpUrl) {
            List list = httpUrl.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"httpUrl.pathSegments()");
            String path = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String string2 = httpUrl.scheme();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"httpUrl.scheme()");
            String string3 = httpUrl.host();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"httpUrl.host()");
            int n = httpUrl.port();
            CharSequence charSequence = path;
            boolean bl = false;
            String string4 = !StringsKt.isBlank((CharSequence)charSequence) ? '/' + path : "";
            charSequence = httpUrl.query();
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                charSequence2 = "";
            }
            return new FormattedUrl(string2, string3, n, string4, (String)charSequence2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

