/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.support.JsonConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormatUtils;", "", "()V", "BASE_TWO_MULTIPLE", "", "SI_MULTIPLE", "formatByteCount", "", "bytes", "", "si", "", "formatHeaders", "httpHeaders", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpHeader;", "withMarkup", "formatJson", "json", "formatThrowable", "throwable", "", "formatUrlEncodedForm", "form", "formatXml", "xml", "com.github.ChuckerTeam.Chucker.library"})
public final class FormatUtils {
    private static final int SI_MULTIPLE = 1000;
    private static final int BASE_TWO_MULTIPLE = 1024;
    public static final FormatUtils INSTANCE;

    @NotNull
    public final String formatHeaders(@Nullable List<HttpHeader> httpHeaders, boolean withMarkup) {
        List<HttpHeader> list = httpHeaders;
        if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<HttpHeader, CharSequence>(withMarkup){
            final /* synthetic */ boolean $withMarkup;

            @NotNull
            public final CharSequence invoke(@NotNull HttpHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return this.$withMarkup ? (CharSequence)("<b> " + header.getName() + ": </b>" + header.getValue() + " <br />") : (CharSequence)(header.getName() + ": " + header.getValue() + '\n');
            }
            {
                this.$withMarkup = bl;
                super(1);
            }
        }), (int)30, null)) == null) {
            list = "";
        }
        return list;
    }

    @NotNull
    public final String formatByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        double d = bytes;
        boolean bl = false;
        double d2 = Math.log(d);
        d = unit;
        bl = false;
        int exp = (int)(d2 / Math.log(d));
        char c = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        Object object = si ? "" : "i";
        boolean bl2 = false;
        String pre = String.valueOf(c) + (String)object;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        object = Locale.US;
        String string2 = "%.1f %sB";
        Object[] objectArray = new Object[2];
        double d3 = unit;
        double d4 = exp;
        boolean bl3 = false;
        objectArray[0] = (double)bytes / Math.pow(d3, d4);
        objectArray[1] = pre;
        Object[] objectArray2 = objectArray;
        boolean bl4 = false;
        String string3 = String.format((Locale)object, string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        return string3;
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            JsonElement je = JsonParser.parseString((String)json);
            String string3 = JsonConverter.INSTANCE.getInstance().toJson(je);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"JsonConverter.instance.toJson(je)");
            string2 = string3;
        }
        catch (JsonParseException e) {
            string2 = json;
        }
        return string2;
    }

    @NotNull
    public final String formatXml(@NotNull String xml) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"DocumentBuilderFactory.newInstance()");
            DocumentBuilderFactory documentFactory = documentBuilderFactory;
            documentFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"documentFactory.newDocumentBuilder()");
            DocumentBuilder documentBuilder2 = documentBuilder;
            String string3 = xml;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
            Charset charset2 = charset;
            boolean bl = false;
            byte[] byArray = string3.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilder2.parse(inputSource);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"documentBuilder.parse(inputSource)");
            Document document2 = document;
            DOMSource domSource = new DOMSource(document2);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Object object = TransformerFactory.newInstance();
            boolean bl2 = false;
            boolean bl3 = false;
            Object $this$apply = object;
            boolean bl4 = false;
            ((TransformerFactory)$this$apply).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            object = ((TransformerFactory)object).newTransformer();
            bl2 = false;
            bl3 = false;
            $this$apply = object;
            boolean bl5 = false;
            ((Transformer)$this$apply).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ((Transformer)$this$apply).setOutputProperty("indent", "yes");
            ((Transformer)$this$apply).transform(domSource, result);
            String string4 = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"writer.toString()");
            string2 = string4;
        }
        catch (SAXParseException e) {
            string2 = xml;
        }
        catch (IOException io) {
            string2 = xml;
        }
        catch (TransformerException t) {
            string2 = xml;
        }
        return string2;
    }

    @NotNull
    public final String formatUrlEncodedForm(@NotNull String form) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        try {
            if (StringsKt.isBlank((CharSequence)form)) {
                return form;
            }
            string2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)form, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)formatUrlEncodedForm.1.INSTANCE, (int)30, null);
        }
        catch (IllegalArgumentException e) {
            string2 = form;
        }
        catch (UnsupportedEncodingException e) {
            string2 = form;
        }
        return string2;
    }

    @NotNull
    public final String formatThrowable(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sw.toString()");
        return string2;
    }

    private FormatUtils() {
    }

    static {
        FormatUtils formatUtils;
        INSTANCE = formatUtils = new FormatUtils();
    }
}

