/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.repository;

import androidx.lifecycle.LiveData;
import com.chuckerteam.chucker.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.internal.data.entity.RecordedThrowableTuple;
import com.chuckerteam.chucker.internal.data.repository.RecordedThrowableRepository;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\rH\u0016J\u0019\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/chuckerteam/chucker/internal/data/repository/RecordedThrowableDatabaseRepository;", "Lcom/chuckerteam/chucker/internal/data/repository/RecordedThrowableRepository;", "database", "Lcom/chuckerteam/chucker/internal/data/room/ChuckerDatabase;", "(Lcom/chuckerteam/chucker/internal/data/room/ChuckerDatabase;)V", "deleteAllThrowables", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteOldThrowables", "threshold", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRecordedThrowable", "Landroidx/lifecycle/LiveData;", "Lcom/chuckerteam/chucker/internal/data/entity/RecordedThrowable;", "id", "getSortedThrowablesTuples", "", "Lcom/chuckerteam/chucker/internal/data/entity/RecordedThrowableTuple;", "saveThrowable", "throwable", "(Lcom/chuckerteam/chucker/internal/data/entity/RecordedThrowable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "com.github.ChuckerTeam.Chucker.library"})
public final class RecordedThrowableDatabaseRepository
implements RecordedThrowableRepository {
    private final ChuckerDatabase database;

    @Override
    @NotNull
    public LiveData<RecordedThrowable> getRecordedThrowable(long id2) {
        return LiveDataUtilsKt.distinctUntilChanged$default(this.database.throwableDao().getById(id2), null, null, 3, null);
    }

    @Override
    @Nullable
    public Object deleteAllThrowables(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.database.throwableDao().deleteAll($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public LiveData<List<RecordedThrowableTuple>> getSortedThrowablesTuples() {
        return this.database.throwableDao().getTuples();
    }

    @Override
    @Nullable
    public Object saveThrowable(@NotNull RecordedThrowable throwable, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.database.throwableDao().insert(throwable, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object deleteOldThrowables(long threshold, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.database.throwableDao().deleteBefore(threshold, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public RecordedThrowableDatabaseRepository(@NotNull ChuckerDatabase database) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        this.database = database;
    }
}

