/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.CacheDirectoryProvider;
import com.chuckerteam.chucker.internal.support.DepletingSource;
import com.chuckerteam.chucker.internal.support.FileFactory;
import com.chuckerteam.chucker.internal.support.IOUtils;
import com.chuckerteam.chucker.internal.support.OkHttpUtilsKt;
import com.chuckerteam.chucker.internal.support.ReportingSink;
import com.chuckerteam.chucker.internal.support.TeeSource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0003-./B=\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBE\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010%\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010(\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001f\u0010)\u001a\u00020\"2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0+\"\u00020\n\u00a2\u0006\u0002\u0010,R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "maxContentLength", "", "headersToRedact", "", "", "alwaysReadResponseBody", "", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLjava/util/Set;Z)V", "cacheDirectoryProvider", "Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;ZLjava/util/Set;)V", "", "io", "Lcom/chuckerteam/chucker/internal/support/IOUtils;", "createTempTransactionFile", "Ljava/io/File;", "filterHeaders", "Lokhttp3/Headers;", "headers", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "multiCastResponseBody", "response", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "processRequest", "", "request", "Lokhttp3/Request;", "processResponseBody", "responseBodyBuffer", "Lokio/Buffer;", "processResponseMetadata", "redactHeader", "headerName", "", "([Ljava/lang/String;)V", "Builder", "ChuckerTransactionReportingSinkCallback", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class ChuckerInterceptor
implements Interceptor {
    private final IOUtils io;
    private final Set<String> headersToRedact;
    private final Context context;
    private final ChuckerCollector collector;
    private final long maxContentLength;
    private final CacheDirectoryProvider cacheDirectoryProvider;
    private final boolean alwaysReadResponseBody;
    private static final Charset UTF8;
    private static final long MAX_CONTENT_LENGTH = 250000L;
    private static final long MAX_BLOB_SIZE = 1000000L;
    private static final String CONTENT_TYPE_IMAGE = "image";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final Companion Companion;

    public final void redactHeader(String ... headerName) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        CollectionsKt.addAll((Collection)this.headersToRedact, (Object[])headerName);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = null;
        HttpTransaction transaction = new HttpTransaction();
        Request request2 = request;
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"request");
        this.processRequest(request2, transaction);
        this.collector.onRequestSent$com_github_ChuckerTeam_Chucker_library(transaction);
        try {
            Response response2 = chain.proceed(request);
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"chain.proceed(request)");
            response = response2;
        }
        catch (IOException e) {
            transaction.setError(e.toString());
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction);
            throw (Throwable)e;
        }
        this.processResponseMetadata(response, transaction);
        return this.multiCastResponseBody(response, transaction);
    }

    private final void processRequest(Request request, HttpTransaction transaction) {
        RequestBody requestBody = request.body();
        boolean encodingIsSupported = this.io.bodyHasSupportedEncoding(request.headers().get(CONTENT_ENCODING));
        HttpTransaction httpTransaction = transaction;
        boolean bl = false;
        boolean bl2 = false;
        HttpTransaction $this$apply = httpTransaction;
        boolean bl3 = false;
        Headers headers = request.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"request.headers()");
        $this$apply.setRequestHeaders(headers);
        HttpUrl httpUrl = request.url();
        Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"request.url()");
        $this$apply.populateUrl(httpUrl);
        $this$apply.setRequestBodyPlainText(encodingIsSupported);
        $this$apply.setRequestDate(System.currentTimeMillis());
        $this$apply.setMethod(request.method());
        RequestBody requestBody2 = requestBody;
        $this$apply.setRequestContentType(requestBody2 != null && (requestBody2 = requestBody2.contentType()) != null ? requestBody2.toString() : null);
        RequestBody requestBody3 = requestBody;
        $this$apply.setRequestPayloadSize(requestBody3 != null ? requestBody3.contentLength() : 0L);
        if (requestBody != null && encodingIsSupported) {
            BufferedSource source = this.io.getNativeSource((BufferedSource)new Buffer(), OkHttpUtilsKt.isGzipped(request));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF8");
            Charset charset2 = charset;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                Charset charset3 = contentType.charset(UTF8);
                if (charset3 == null) {
                    Charset charset4 = UTF8;
                    charset3 = charset4;
                    Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"UTF8");
                }
                charset2 = charset3;
            }
            Buffer buffer2 = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)buffer2, (String)"buffer");
            if (this.io.isPlaintext(buffer2)) {
                String content2 = this.io.readFromBuffer(buffer, charset2, this.maxContentLength);
                transaction.setRequestBody(content2);
            } else {
                transaction.setResponseBodyPlainText(false);
            }
        }
    }

    private final void processResponseMetadata(Response response, HttpTransaction transaction) {
        boolean responseEncodingIsSupported = this.io.bodyHasSupportedEncoding(response.headers().get(CONTENT_ENCODING));
        HttpTransaction httpTransaction = transaction;
        boolean bl = false;
        boolean bl2 = false;
        HttpTransaction $this$apply = httpTransaction;
        boolean bl3 = false;
        Headers headers = response.request().headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"response.request().headers()");
        $this$apply.setRequestHeaders(this.filterHeaders(headers));
        Headers headers2 = response.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"response.headers()");
        $this$apply.setResponseHeaders(this.filterHeaders(headers2));
        $this$apply.setResponseBodyPlainText(responseEncodingIsSupported);
        $this$apply.setRequestDate(response.sentRequestAtMillis());
        $this$apply.setResponseDate(response.receivedResponseAtMillis());
        $this$apply.setProtocol(response.protocol().toString());
        $this$apply.setResponseCode(response.code());
        $this$apply.setResponseMessage(response.message());
        Handshake handshake = response.handshake();
        if (handshake != null) {
            Handshake handshake2 = handshake;
            boolean bl4 = false;
            boolean bl5 = false;
            Handshake handshake3 = handshake2;
            boolean bl6 = false;
            $this$apply.setResponseTlsVersion(handshake3.tlsVersion().javaName());
            $this$apply.setResponseCipherSuite(handshake3.cipherSuite().javaName());
        }
        $this$apply.setResponseContentType(OkHttpUtilsKt.getContentType(response));
        $this$apply.setTookMs(response.receivedResponseAtMillis() - response.sentRequestAtMillis());
    }

    private final Response multiCastResponseBody(Response response, HttpTransaction transaction) {
        ResponseBody responseBody = response.body();
        if (!OkHttpUtilsKt.hasBody(response) || responseBody == null) {
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction);
            return response;
        }
        MediaType contentType = responseBody.contentType();
        long contentLength = responseBody.contentLength();
        ReportingSink sideStream = new ReportingSink(this.createTempTransactionFile(), new ChuckerTransactionReportingSinkCallback(response, transaction), this.maxContentLength);
        BufferedSource bufferedSource = responseBody.source();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedSource, (String)"responseBody.source()");
        Source upstream = new TeeSource((Source)bufferedSource, sideStream);
        if (this.alwaysReadResponseBody) {
            upstream = (Source)new DepletingSource(upstream);
        }
        Response response2 = response.newBuilder().body(ResponseBody.create((MediaType)contentType, (long)contentLength, (BufferedSource)Okio.buffer((Source)upstream))).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response.newBuilder()\n  \u2026m)))\n            .build()");
        return response2;
    }

    private final File createTempTransactionFile() {
        File file;
        File cache = this.cacheDirectoryProvider.provide();
        if (cache == null) {
            new IOException("Failed to obtain a valid cache directory for Chucker transaction file").printStackTrace();
            file = null;
        } else {
            file = FileFactory.INSTANCE.create(cache);
        }
        return file;
    }

    private final void processResponseBody(Response response, Buffer responseBodyBuffer, HttpTransaction transaction) {
        Object charset;
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)responseBody, (String)"response.body() ?: return");
        ResponseBody responseBody2 = responseBody;
        MediaType contentType = responseBody2.contentType();
        Object object = contentType;
        if (object == null || (object = object.charset(UTF8)) == null) {
            object = charset = UTF8;
        }
        if (this.io.isPlaintext(responseBodyBuffer)) {
            transaction.setResponseBodyPlainText(true);
            if (responseBodyBuffer.size() != 0L) {
                transaction.setResponseBody(responseBodyBuffer.readString((Charset)charset));
            }
        } else {
            boolean isImageContentType;
            transaction.setResponseBodyPlainText(false);
            Object object2 = contentType;
            boolean bl = object2 != null && (object2 = object2.toString()) != null && StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)CONTENT_TYPE_IMAGE, (boolean)true) ? true : (isImageContentType = false);
            if (isImageContentType && responseBodyBuffer.size() < 1000000L) {
                transaction.setResponseImageData(responseBodyBuffer.readByteArray());
            }
        }
    }

    private final Headers filterHeaders(Headers headers) {
        Headers.Builder builder = headers.newBuilder();
        for (String name : headers.names()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.headersToRedact;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String userHeader = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)userHeader, (String)name, (boolean)true)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            builder.set(name, "**");
        }
        Headers headers2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"builder.build()");
        return headers2;
    }

    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull CacheDirectoryProvider cacheDirectoryProvider, boolean alwaysReadResponseBody, @NotNull Set<String> headersToRedact) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)cacheDirectoryProvider, (String)"cacheDirectoryProvider");
        Intrinsics.checkNotNullParameter(headersToRedact, (String)"headersToRedact");
        this.context = context;
        this.collector = collector;
        this.maxContentLength = maxContentLength;
        this.cacheDirectoryProvider = cacheDirectoryProvider;
        this.alwaysReadResponseBody = alwaysReadResponseBody;
        this.io = new IOUtils(this.context);
        this.headersToRedact = CollectionsKt.toMutableSet((Iterable)headersToRedact);
    }

    public /* synthetic */ ChuckerInterceptor(Context context, ChuckerCollector chuckerCollector, long l, CacheDirectoryProvider cacheDirectoryProvider, boolean bl, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chuckerCollector = new ChuckerCollector(context, false, null, 6, null);
        }
        if ((n & 4) != 0) {
            l = 250000L;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            set = SetsKt.emptySet();
        }
        this(context, chuckerCollector, l, cacheDirectoryProvider, bl, set);
    }

    @Deprecated(message="Customisation of ChuckerInterceptor should be replaced with a builder pattern unless you pass only Context.", replaceWith=@ReplaceWith(imports={}, expression="ChuckerInterceptor.Builder(context)\n.collector(collector)\n.maxContentLength(maxContentLength)\n.redactHeaders(headersToRedact)\n.alwaysReadResponseBody(alwaysReadResponseBody)\n.build()"))
    @JvmOverloads
    public ChuckerInterceptor(final @NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull Set<String> headersToRedact, boolean alwaysReadResponseBody) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter(headersToRedact, (String)"headersToRedact");
        this(context, collector, maxContentLength, new CacheDirectoryProvider(){

            @Override
            @Nullable
            public final File provide() {
                return context.getCacheDir();
            }
        }, alwaysReadResponseBody, headersToRedact);
    }

    public /* synthetic */ ChuckerInterceptor(Context context, ChuckerCollector chuckerCollector, long l, Set set, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chuckerCollector = new ChuckerCollector(context, false, null, 6, null);
        }
        if ((n & 4) != 0) {
            l = 250000L;
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(context, chuckerCollector, l, set, bl);
    }

    @Deprecated(message="Customisation of ChuckerInterceptor should be replaced with a builder pattern unless you pass only Context.", replaceWith=@ReplaceWith(imports={}, expression="ChuckerInterceptor.Builder(context)\n.collector(collector)\n.maxContentLength(maxContentLength)\n.redactHeaders(headersToRedact)\n.alwaysReadResponseBody(alwaysReadResponseBody)\n.build()"))
    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull Set<String> headersToRedact) {
        this(context, collector, maxContentLength, headersToRedact, false, 16, null);
    }

    @Deprecated(message="Customisation of ChuckerInterceptor should be replaced with a builder pattern unless you pass only Context.", replaceWith=@ReplaceWith(imports={}, expression="ChuckerInterceptor.Builder(context)\n.collector(collector)\n.maxContentLength(maxContentLength)\n.redactHeaders(headersToRedact)\n.alwaysReadResponseBody(alwaysReadResponseBody)\n.build()"))
    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength) {
        this(context, collector, maxContentLength, null, false, 24, null);
    }

    @Deprecated(message="Customisation of ChuckerInterceptor should be replaced with a builder pattern unless you pass only Context.", replaceWith=@ReplaceWith(imports={}, expression="ChuckerInterceptor.Builder(context)\n.collector(collector)\n.maxContentLength(maxContentLength)\n.redactHeaders(headersToRedact)\n.alwaysReadResponseBody(alwaysReadResponseBody)\n.build()"))
    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector) {
        this(context, collector, 0L, null, false, 28, null);
    }

    @Deprecated(message="Customisation of ChuckerInterceptor should be replaced with a builder pattern unless you pass only Context.", replaceWith=@ReplaceWith(imports={}, expression="ChuckerInterceptor.Builder(context)\n.collector(collector)\n.maxContentLength(maxContentLength)\n.redactHeaders(headersToRedact)\n.alwaysReadResponseBody(alwaysReadResponseBody)\n.build()"))
    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context) {
        this(context, null, 0L, null, false, 30, null);
    }

    static {
        Companion = new Companion(null);
        UTF8 = Charset.forName("UTF-8");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$ChuckerTransactionReportingSinkCallback;", "Lcom/chuckerteam/chucker/internal/support/ReportingSink$Callback;", "response", "Lokhttp3/Response;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "(Lcom/chuckerteam/chucker/api/ChuckerInterceptor;Lokhttp3/Response;Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;)V", "onClosed", "", "file", "Ljava/io/File;", "sourceByteCount", "", "onFailure", "exception", "Ljava/io/IOException;", "readResponseBuffer", "Lokio/Buffer;", "responseBody", "isGzipped", "", "com.github.ChuckerTeam.Chucker.library"})
    private final class ChuckerTransactionReportingSinkCallback
    implements ReportingSink.Callback {
        private final Response response;
        private final HttpTransaction transaction;

        @Override
        public void onClosed(@Nullable File file, long sourceByteCount) {
            block1: {
                Buffer buffer;
                if (file != null && (buffer = this.readResponseBuffer(file, OkHttpUtilsKt.isGzipped(this.response))) != null) {
                    ChuckerInterceptor.this.processResponseBody(this.response, buffer, this.transaction);
                }
                this.transaction.setResponsePayloadSize(sourceByteCount);
                ChuckerInterceptor.this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(this.transaction);
                File file2 = file;
                if (file2 == null) break block1;
                file2.delete();
            }
        }

        @Override
        public void onFailure(@Nullable File file, @NotNull IOException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            exception.printStackTrace();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Buffer readResponseBuffer(File responseBody, boolean isGzipped) {
            Buffer buffer;
            try {
                BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((File)responseBody));
                Source source = isGzipped ? (Source)new GzipSource((Source)bufferedSource) : (Source)bufferedSource;
                Buffer buffer2 = new Buffer();
                boolean bl = false;
                boolean bl2 = false;
                Buffer $this$apply = buffer2;
                boolean bl3 = false;
                Closeable closeable = (Closeable)source;
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    Source it = (Source)closeable;
                    boolean bl6 = false;
                    $this$apply.writeAll(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                buffer = buffer2;
            }
            catch (IOException e) {
                new IOException("Response payload couldn't be processed by Chucker", e).printStackTrace();
                buffer = null;
            }
            return buffer;
        }

        public ChuckerTransactionReportingSinkCallback(@NotNull Response response, HttpTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            this.response = response;
            this.transaction = transaction;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000fJ\u001f\u0010\u0014\u001a\u00020\u00002\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0016\"\u00020\r\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alwaysReadResponseBody", "", "cacheDirectoryProvider", "Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "headersToRedact", "", "", "maxContentLength", "", "enable", "build", "Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "length", "redactHeaders", "headerNames", "", "([Ljava/lang/String;)Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Builder;", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Builder {
        private ChuckerCollector collector;
        private long maxContentLength;
        private CacheDirectoryProvider cacheDirectoryProvider;
        private boolean alwaysReadResponseBody;
        private Set<String> headersToRedact;
        private Context context;

        @NotNull
        public final Builder collector(@NotNull ChuckerCollector collector) {
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.collector = collector;
            return builder;
        }

        @NotNull
        public final Builder maxContentLength(long length) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.maxContentLength = length;
            return builder;
        }

        @NotNull
        public final Builder redactHeaders(@NotNull Iterable<String> headerNames) {
            Intrinsics.checkNotNullParameter(headerNames, (String)"headerNames");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.headersToRedact = CollectionsKt.toSet(headerNames);
            return builder;
        }

        @NotNull
        public final Builder redactHeaders(String ... headerNames) {
            Intrinsics.checkNotNullParameter((Object)headerNames, (String)"headerNames");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.headersToRedact = ArraysKt.toSet((Object[])headerNames);
            return builder;
        }

        @NotNull
        public final Builder alwaysReadResponseBody(boolean enable) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.alwaysReadResponseBody = enable;
            return builder;
        }

        @NotNull
        public final ChuckerInterceptor build() {
            CacheDirectoryProvider cacheDirectoryProvider;
            ChuckerCollector chuckerCollector = this.collector;
            if (chuckerCollector == null) {
                chuckerCollector = new ChuckerCollector(this.context, false, null, 6, null);
            }
            if ((cacheDirectoryProvider = this.cacheDirectoryProvider) == null) {
                cacheDirectoryProvider = new CacheDirectoryProvider(this){
                    final /* synthetic */ Builder this$0;

                    @Nullable
                    public final File provide() {
                        return Builder.access$getContext$p(this.this$0).getFilesDir();
                    }
                    {
                        this.this$0 = builder;
                    }
                };
            }
            return new ChuckerInterceptor(this.context, chuckerCollector, this.maxContentLength, cacheDirectoryProvider, this.alwaysReadResponseBody, this.headersToRedact);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            Companion;
            this.maxContentLength = 250000L;
            this.headersToRedact = SetsKt.emptySet();
        }

        public static final /* synthetic */ Context access$getContext$p(Builder $this) {
            return $this.context;
        }

        public static final /* synthetic */ void access$setContext$p(Builder $this, Context context) {
            $this.context = context;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Companion;", "", "()V", "CONTENT_ENCODING", "", "CONTENT_TYPE_IMAGE", "MAX_BLOB_SIZE", "", "MAX_CONTENT_LENGTH", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "com.github.ChuckerTeam.Chucker.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

