/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.repository;

import androidx.lifecycle.LiveData;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionDatabaseRepository;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionRepository;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00110\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00110\u0014H\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00142\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0019\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionDatabaseRepository;", "Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionRepository;", "database", "Lcom/chuckerteam/chucker/internal/data/room/ChuckerDatabase;", "(Lcom/chuckerteam/chucker/internal/data/room/ChuckerDatabase;)V", "transactionDao", "Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao;", "getTransactionDao", "()Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao;", "deleteAllTransactions", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteOldTransactions", "threshold", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllTransactions", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "getFilteredTransactionTuples", "Landroidx/lifecycle/LiveData;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "code", "", "path", "getSortedTransactionTuples", "getTransaction", "transactionId", "insertTransaction", "transaction", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateTransaction", "", "com.github.ChuckerTeam.Chucker.library"})
public final class HttpTransactionDatabaseRepository
implements HttpTransactionRepository {
    private final ChuckerDatabase database;

    private final HttpTransactionDao getTransactionDao() {
        return this.database.transactionDao();
    }

    @Override
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getFilteredTransactionTuples(@NotNull String code, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = path;
        boolean bl = false;
        String pathQuery = charSequence.length() > 0 ? '%' + path + '%' : "%";
        return this.getTransactionDao().getFilteredTuples(code + '%', pathQuery);
    }

    @Override
    @NotNull
    public LiveData<HttpTransaction> getTransaction(long transactionId) {
        return LiveDataUtilsKt.distinctUntilChanged$default(this.getTransactionDao().getById(transactionId), null, getTransaction.1.INSTANCE, 1, null);
    }

    @Override
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getSortedTransactionTuples() {
        return this.getTransactionDao().getSortedTuples();
    }

    @Override
    @Nullable
    public Object deleteAllTransactions(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.getTransactionDao().deleteAll($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object insertTransaction(@NotNull HttpTransaction transaction, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof insertTransaction.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ HttpTransactionDatabaseRepository this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.insertTransaction(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = httpTransactionDatabaseRepository;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = transaction;
                $continuation.label = 1;
                v0 = this.getTransactionDao().insert(transaction, (Continuation<? super Long>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                transaction = (HttpTransaction)$continuation.L$1;
                this = (HttpTransactionDatabaseRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = id = (Long)v0;
                transaction.setId(v1 != null ? v1 : 0L);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public int updateTransaction(@NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return this.getTransactionDao().update(transaction);
    }

    @Override
    @Nullable
    public Object deleteOldTransactions(long threshold, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.getTransactionDao().deleteBefore(threshold, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getAllTransactions(@NotNull Continuation<? super List<HttpTransaction>> $completion) {
        return this.getTransactionDao().getAll($completion);
    }

    public HttpTransactionDatabaseRepository(@NotNull ChuckerDatabase database) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        this.database = database;
    }
}

