/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ShareCompat;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerActivityTransactionBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPagerAdapter;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModelFactory;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionActivity;", "Lcom/chuckerteam/chucker/internal/ui/BaseChuckerActivity;", "()V", "transactionBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerActivityTransactionBinding;", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "setUpUrlEncoding", "setupViewPager", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "share", "transactionDetailsText", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionActivity
extends BaseChuckerActivity {
    private TransactionViewModel viewModel;
    private ChuckerActivityTransactionBinding transactionBinding;
    private static final String MIME_TYPE = "text/plain";
    private static final String EXTRA_TRANSACTION_ID = "transaction_id";
    private static int selectedTabPosition;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ChuckerActivityTransactionBinding chuckerActivityTransactionBinding = ChuckerActivityTransactionBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkExpressionValueIsNotNull((Object)chuckerActivityTransactionBinding, (String)"ChuckerActivityTransacti\u2026g.inflate(layoutInflater)");
        this.transactionBinding = chuckerActivityTransactionBinding;
        long transactionId = this.getIntent().getLongExtra(EXTRA_TRANSACTION_ID, 0L);
        ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new TransactionViewModelFactory(transactionId)).get(TransactionViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProvider(this, \u2026ionViewModel::class.java)");
        this.viewModel = (TransactionViewModel)viewModel;
        ChuckerActivityTransactionBinding chuckerActivityTransactionBinding2 = this.transactionBinding;
        if (chuckerActivityTransactionBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionBinding");
        }
        ChuckerActivityTransactionBinding chuckerActivityTransactionBinding3 = chuckerActivityTransactionBinding2;
        boolean bl = false;
        boolean bl2 = false;
        ChuckerActivityTransactionBinding $this$with = chuckerActivityTransactionBinding3;
        boolean bl3 = false;
        this.setContentView((View)$this$with.getRoot());
        this.setSupportActionBar((Toolbar)$this$with.toolbar);
        ViewPager viewPager = $this$with.viewPager;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"viewPager");
        this.setupViewPager(viewPager);
        $this$with.tabLayout.setupWithViewPager($this$with.viewPager);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        TransactionViewModel transactionViewModel = this.viewModel;
        if (transactionViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        transactionViewModel.getTransactionTitle().observe((LifecycleOwner)this, (Observer)new Observer<String>(this){
            final /* synthetic */ TransactionActivity this$0;

            public final void onChanged(String it) {
                TextView textView = TransactionActivity.access$getTransactionBinding$p((TransactionActivity)this.this$0).toolbarTitle;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"transactionBinding.toolbarTitle");
                textView.setText((CharSequence)it);
            }
            {
                this.this$0 = transactionActivity;
            }
        });
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.chucker_transaction, menu2);
        this.setUpUrlEncoding(menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    private final void setUpUrlEncoding(Menu menu2) {
        MenuItem encodeUrlMenuItem = menu2.findItem(R.id.encode_url);
        encodeUrlMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(this){
            final /* synthetic */ TransactionActivity this$0;

            public final boolean onMenuItemClick(MenuItem it) {
                TransactionActivity.access$getViewModel$p(this.this$0).switchUrlEncoding();
                return true;
            }
            {
                this.this$0 = transactionActivity;
            }
        });
        TransactionViewModel transactionViewModel = this.viewModel;
        if (transactionViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        transactionViewModel.getEncodeUrl().observe((LifecycleOwner)this, (Observer)new Observer<Boolean>(encodeUrlMenuItem){
            final /* synthetic */ MenuItem $encodeUrlMenuItem;

            public final void onChanged(Boolean encode) {
                Boolean bl = encode;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"encode");
                int icon = bl != false ? R.drawable.chucker_ic_encoded_url_white : R.drawable.chucker_ic_decoded_url_white;
                this.$encodeUrlMenuItem.setIcon(icon);
            }
            {
                this.$encodeUrlMenuItem = menuItem;
            }
        });
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.share_text) {
            TransactionViewModel transactionViewModel = this.viewModel;
            if (transactionViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            HttpTransaction httpTransaction = (HttpTransaction)transactionViewModel.getTransaction().getValue();
            if (httpTransaction != null) {
                HttpTransaction httpTransaction2 = httpTransaction;
                boolean bl2 = false;
                boolean bl3 = false;
                HttpTransaction it = httpTransaction2;
                boolean bl4 = false;
                Context context = (Context)this;
                HttpTransaction httpTransaction3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpTransaction3, (String)"it");
                TransactionViewModel transactionViewModel2 = this.viewModel;
                if (transactionViewModel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                }
                Object object = transactionViewModel2.getEncodeUrl().getValue();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"viewModel.encodeUrl.value!!");
                this.share(FormatUtils.INSTANCE.getShareText(context, httpTransaction3, (Boolean)object));
            } else {
                String string2 = this.getString(R.string.chucker_request_not_ready);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.chucker_request_not_ready)");
                this.showToast(string2);
            }
            bl = true;
        } else if (n == R.id.share_curl) {
            TransactionViewModel transactionViewModel = this.viewModel;
            if (transactionViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            HttpTransaction httpTransaction = (HttpTransaction)transactionViewModel.getTransaction().getValue();
            if (httpTransaction != null) {
                HttpTransaction httpTransaction4 = httpTransaction;
                boolean bl5 = false;
                boolean bl6 = false;
                HttpTransaction it = httpTransaction4;
                boolean bl7 = false;
                HttpTransaction httpTransaction5 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpTransaction5, (String)"it");
                this.share(FormatUtils.INSTANCE.getShareCurlCommand(httpTransaction5));
            } else {
                String string3 = this.getString(R.string.chucker_request_not_ready);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"getString(R.string.chucker_request_not_ready)");
                this.showToast(string3);
            }
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    private final void setupViewPager(ViewPager viewPager) {
        Context context = (Context)this;
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        viewPager.setAdapter((PagerAdapter)new TransactionPagerAdapter(context, fragmentManager));
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                TransactionActivity.access$setSelectedTabPosition$cp(position);
            }
        });
        viewPager.setCurrentItem(selectedTabPosition);
    }

    private final void share(String transactionDetailsText) {
        this.startActivity(ShareCompat.IntentBuilder.from((Activity)((Activity)this)).setType(MIME_TYPE).setChooserTitle((CharSequence)this.getString(R.string.chucker_share_transaction_title)).setSubject(this.getString(R.string.chucker_share_transaction_subject)).setText((CharSequence)transactionDetailsText).createChooserIntent());
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ ChuckerActivityTransactionBinding access$getTransactionBinding$p(TransactionActivity $this) {
        ChuckerActivityTransactionBinding chuckerActivityTransactionBinding = $this.transactionBinding;
        if (chuckerActivityTransactionBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionBinding");
        }
        return chuckerActivityTransactionBinding;
    }

    public static final /* synthetic */ void access$setTransactionBinding$p(TransactionActivity $this, ChuckerActivityTransactionBinding chuckerActivityTransactionBinding) {
        $this.transactionBinding = chuckerActivityTransactionBinding;
    }

    public static final /* synthetic */ TransactionViewModel access$getViewModel$p(TransactionActivity $this) {
        TransactionViewModel transactionViewModel = $this.viewModel;
        if (transactionViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return transactionViewModel;
    }

    public static final /* synthetic */ void access$setViewModel$p(TransactionActivity $this, TransactionViewModel transactionViewModel) {
        $this.viewModel = transactionViewModel;
    }

    public static final /* synthetic */ int access$getSelectedTabPosition$cp() {
        return selectedTabPosition;
    }

    public static final /* synthetic */ void access$setSelectedTabPosition$cp(int n) {
        selectedTabPosition = n;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionActivity$Companion;", "", "()V", "EXTRA_TRANSACTION_ID", "", "MIME_TYPE", "selectedTabPosition", "", "start", "", "context", "Landroid/content/Context;", "transactionId", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        public final void start(@NotNull Context context, long transactionId) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intent intent = new Intent(context, TransactionActivity.class);
            intent.putExtra(TransactionActivity.EXTRA_TRANSACTION_ID, transactionId);
            context.startActivity(intent);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

