/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/chuckerteam/chucker/internal/support/TeeSource;", "Lokio/Source;", "upstream", "sideChannel", "Ljava/io/File;", "callback", "Lcom/chuckerteam/chucker/internal/support/TeeSource$Callback;", "readBytesLimit", "", "(Lokio/Source;Ljava/io/File;Lcom/chuckerteam/chucker/internal/support/TeeSource$Callback;J)V", "isFailure", "", "isReadLimitExceeded", "isUpstreamExhausted", "sideStream", "Lokio/BufferedSink;", "kotlin.jvm.PlatformType", "totalBytesRead", "callSideChannelFailure", "", "exception", "Ljava/io/IOException;", "close", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "Callback", "com.github.ChuckerTeam.Chucker.library"})
public final class TeeSource
implements Source {
    private final BufferedSink sideStream;
    private long totalBytesRead;
    private boolean isReadLimitExceeded;
    private boolean isUpstreamExhausted;
    private boolean isFailure;
    private final Source upstream;
    private final File sideChannel;
    private final Callback callback;
    private final long readBytesLimit;

    public long read(@NotNull Buffer sink, long byteCount) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        try {
            l = this.upstream.read(sink, byteCount);
        }
        catch (IOException e) {
            this.callSideChannelFailure(e);
            throw (Throwable)e;
        }
        long bytesRead = l;
        if (bytesRead == -1L) {
            this.isUpstreamExhausted = true;
            this.sideStream.close();
            return -1L;
        }
        this.totalBytesRead += bytesRead;
        if (!this.isReadLimitExceeded && this.totalBytesRead <= this.readBytesLimit) {
            long offset = sink.size() - bytesRead;
            sink.copyTo(this.sideStream.buffer(), offset, bytesRead);
            this.sideStream.emitCompleteSegments();
            return bytesRead;
        }
        if (!this.isReadLimitExceeded) {
            this.isReadLimitExceeded = true;
            this.sideStream.close();
            this.callSideChannelFailure(new IOException("Capacity of " + this.readBytesLimit + " bytes exceeded"));
        }
        return bytesRead;
    }

    public void close() {
        this.sideStream.close();
        this.upstream.close();
        if (this.isUpstreamExhausted) {
            if (!this.isFailure) {
                this.callback.onSuccess(this.sideChannel);
            }
        } else {
            this.callSideChannelFailure(new IOException("Upstream was not fully consumed"));
        }
    }

    @NotNull
    public Timeout timeout() {
        Timeout timeout = this.upstream.timeout();
        Intrinsics.checkExpressionValueIsNotNull((Object)timeout, (String)"upstream.timeout()");
        return timeout;
    }

    private final void callSideChannelFailure(IOException exception) {
        if (!this.isFailure) {
            this.isFailure = true;
            this.callback.onFailure(exception, this.sideChannel);
        }
    }

    public TeeSource(@NotNull Source upstream, @NotNull File sideChannel, @NotNull Callback callback, long readBytesLimit) {
        Intrinsics.checkParameterIsNotNull((Object)upstream, (String)"upstream");
        Intrinsics.checkParameterIsNotNull((Object)sideChannel, (String)"sideChannel");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.upstream = upstream;
        this.sideChannel = sideChannel;
        this.callback = callback;
        this.readBytesLimit = readBytesLimit;
        this.sideStream = Okio.buffer((Sink)Okio.sink((File)this.sideChannel));
    }

    public /* synthetic */ TeeSource(Source source, File file, Callback callback, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = Long.MAX_VALUE;
        }
        this(source, file, callback, l);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lcom/chuckerteam/chucker/internal/support/TeeSource$Callback;", "", "onFailure", "", "exception", "Ljava/io/IOException;", "file", "Ljava/io/File;", "onSuccess", "com.github.ChuckerTeam.Chucker.library"})
    public static interface Callback {
        public void onSuccess(@NotNull File var1);

        public void onFailure(@NotNull IOException var1, @NotNull File var2);
    }
}

