/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.support.SearchHighlightUtilKt;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadItem;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\r\u0010\u0018\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadViewHolder;", "bodyItems", "", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadItem;", "(Ljava/util/List;)V", "getItemCount", "", "getItemViewType", "position", "highlightQueryWithColors", "", "newText", "", "backgroundColor", "foregroundColor", "highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "resetHighlight", "resetHighlight$com_github_ChuckerTeam_Chucker_library", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionBodyAdapter
extends RecyclerView.Adapter<TransactionPayloadViewHolder> {
    private final List<TransactionPayloadItem> bodyItems;
    private static final int TYPE_HEADERS = 1;
    private static final int TYPE_BODY_LINE = 2;
    private static final int TYPE_IMAGE = 3;
    public static final Companion Companion = new Companion(null);

    public void onBindViewHolder(@NotNull TransactionPayloadViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        holder.bind(this.bodyItems.get(position));
    }

    @NotNull
    public TransactionPayloadViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        TransactionPayloadViewHolder transactionPayloadViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 1: {
                View view;
                View view2 = view = inflater.inflate(R.layout.chucker_transaction_item_headers, parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
                transactionPayloadViewHolder = new TransactionPayloadViewHolder.HeaderViewHolder(view2);
                break;
            }
            case 2: {
                View view;
                View view3 = view = inflater.inflate(R.layout.chucker_transaction_item_body_line, parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view");
                transactionPayloadViewHolder = new TransactionPayloadViewHolder.BodyLineViewHolder(view3);
                break;
            }
            default: {
                View view;
                View view4 = view = inflater.inflate(R.layout.chucker_transaction_item_image, parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view");
                transactionPayloadViewHolder = new TransactionPayloadViewHolder.ImageViewHolder(view4);
            }
        }
        return transactionPayloadViewHolder;
    }

    public int getItemCount() {
        return this.bodyItems.size();
    }

    public int getItemViewType(int position) {
        int n;
        TransactionPayloadItem transactionPayloadItem = this.bodyItems.get(position);
        if (transactionPayloadItem instanceof TransactionPayloadItem.HeaderItem) {
            n = 1;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.BodyLineItem) {
            n = 2;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.ImageItem) {
            n = 3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final void highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library(@NotNull String newText, int backgroundColor, int foregroundColor) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)newText, (String)"newText");
        Iterable $this$filterIsInstance$iv = this.bodyItems;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TransactionPayloadItem.BodyLineItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue $dstr$index$item = (IndexedValue)element$iv;
            boolean bl = false;
            int index = $dstr$index$item.component1();
            TransactionPayloadItem.BodyLineItem item = (TransactionPayloadItem.BodyLineItem)$dstr$index$item.component2();
            if (StringsKt.contains$default((CharSequence)((CharSequence)item.getLine()), (CharSequence)newText, (boolean)false, (int)2, null)) {
                item.getLine().clearSpans();
                String string2 = item.getLine().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"item.line.toString()");
                item.setLine(SearchHighlightUtilKt.highlightWithDefinedColors(string2, newText, backgroundColor, foregroundColor));
                this.notifyItemChanged(index + 1);
                continue;
            }
            Object[] spans = item.getLine().getSpans(0, item.getLine().length() - 1, Object.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            Object[] objectArray = spans;
            boolean bl2 = false;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (!(!(objectArray2.length == 0))) continue;
            item.getLine().clearSpans();
            this.notifyItemChanged(index + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void resetHighlight$com_github_ChuckerTeam_Chucker_library() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.bodyItems;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TransactionPayloadItem.BodyLineItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue $dstr$index$item = (IndexedValue)element$iv;
            boolean bl = false;
            int index = $dstr$index$item.component1();
            TransactionPayloadItem.BodyLineItem item = (TransactionPayloadItem.BodyLineItem)$dstr$index$item.component2();
            Object[] spans = item.getLine().getSpans(0, item.getLine().length() - 1, Object.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            Object[] objectArray = spans;
            boolean bl2 = false;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (!(!(objectArray2.length == 0))) continue;
            item.getLine().clearSpans();
            this.notifyItemChanged(index + 1);
        }
    }

    public TransactionBodyAdapter(@NotNull List<? extends TransactionPayloadItem> bodyItems) {
        Intrinsics.checkParameterIsNotNull(bodyItems, (String)"bodyItems");
        this.bodyItems = bodyItems;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$Companion;", "", "()V", "TYPE_BODY_LINE", "", "TYPE_HEADERS", "TYPE_IMAGE", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

