/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.entity.RecordedThrowableTuple;
import com.chuckerteam.chucker.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.internal.support.NotificationHelper;
import com.chuckerteam.chucker.internal.ui.MainViewModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "currentFilter", "Landroidx/lifecycle/MutableLiveData;", "", "errors", "Landroidx/lifecycle/LiveData;", "", "Lcom/chuckerteam/chucker/internal/data/entity/RecordedThrowableTuple;", "getErrors", "()Landroidx/lifecycle/LiveData;", "transactions", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "getTransactions", "clearErrors", "", "clearTransactions", "updateItemsFilter", "searchQuery", "com.github.ChuckerTeam.Chucker.library"})
public final class MainViewModel
extends ViewModel {
    private final MutableLiveData<String> currentFilter = new MutableLiveData((Object)"");
    @NotNull
    private final LiveData<List<HttpTransactionTuple>> transactions;
    @NotNull
    private final LiveData<List<RecordedThrowableTuple>> errors;

    @NotNull
    public final LiveData<List<HttpTransactionTuple>> getTransactions() {
        return this.transactions;
    }

    @NotNull
    public final LiveData<List<RecordedThrowableTuple>> getErrors() {
        return this.errors;
    }

    public final void updateItemsFilter(@NotNull String searchQuery) {
        Intrinsics.checkParameterIsNotNull((Object)searchQuery, (String)"searchQuery");
        this.currentFilter.setValue((Object)searchQuery);
    }

    public final void clearTransactions() {
        RepositoryProvider.INSTANCE.transaction().deleteAllTransactions();
        NotificationHelper.Companion.clearBuffer();
    }

    public final void clearErrors() {
        RepositoryProvider.INSTANCE.throwable().deleteAllThrowables();
    }

    public MainViewModel() {
        LiveData liveData = Transformations.switchMap((LiveData)((LiveData)this.currentFilter), (Function)transactions.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.switchMa\u2026        }\n        }\n    }");
        this.transactions = liveData;
        LiveData liveData2 = Transformations.map(RepositoryProvider.INSTANCE.throwable().getSortedThrowablesTuples(), (Function)errors.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData2, (String)"Transformations.map(\n   \u2026\n            it\n        }");
        this.errors = liveData2;
    }
}

