/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.LongSparseArray;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.internal.support.ClearDatabaseService;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0014J\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/chuckerteam/chucker/internal/support/NotificationHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "errorsScreenIntent", "Landroid/app/PendingIntent;", "kotlin.jvm.PlatformType", "getErrorsScreenIntent", "()Landroid/app/PendingIntent;", "errorsScreenIntent$delegate", "Lkotlin/Lazy;", "notificationManager", "Landroid/app/NotificationManager;", "transactionsScreenIntent", "getTransactionsScreenIntent", "transactionsScreenIntent$delegate", "addToBuffer", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "createClearAction", "Landroidx/core/app/NotificationCompat$Action;", "clearAction", "Lcom/chuckerteam/chucker/internal/support/ClearDatabaseService$ClearAction;", "dismissErrorsNotification", "dismissTransactionsNotification", "show", "throwable", "Lcom/chuckerteam/chucker/internal/data/entity/RecordedThrowable;", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class NotificationHelper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final NotificationManager notificationManager;
    private final Lazy transactionsScreenIntent$delegate;
    private final Lazy errorsScreenIntent$delegate;
    @NotNull
    private final Context context;
    private static final String TRANSACTIONS_CHANNEL_ID = "chucker_transactions";
    private static final String ERRORS_CHANNEL_ID = "chucker_errors";
    private static final int TRANSACTION_NOTIFICATION_ID = 1138;
    private static final int ERROR_NOTIFICATION_ID = 3546;
    private static final int BUFFER_SIZE = 10;
    private static final int INTENT_REQUEST_CODE = 11;
    private static final LongSparseArray<HttpTransaction> transactionBuffer;
    private static final HashSet<Long> transactionIdsSet;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NotificationHelper.class), "transactionsScreenIntent", "getTransactionsScreenIntent()Landroid/app/PendingIntent;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NotificationHelper.class), "errorsScreenIntent", "getErrorsScreenIntent()Landroid/app/PendingIntent;"))};
        Companion = new Companion(null);
        transactionBuffer = new LongSparseArray();
        transactionIdsSet = new HashSet();
    }

    private final PendingIntent getTransactionsScreenIntent() {
        Lazy lazy = this.transactionsScreenIntent$delegate;
        NotificationHelper notificationHelper = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (PendingIntent)lazy.getValue();
    }

    private final PendingIntent getErrorsScreenIntent() {
        Lazy lazy = this.errorsScreenIntent$delegate;
        NotificationHelper notificationHelper = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (PendingIntent)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToBuffer(HttpTransaction transaction) {
        if (transaction.getId() == 0L) {
            return;
        }
        LongSparseArray<HttpTransaction> longSparseArray = transactionBuffer;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (longSparseArray) {
            boolean bl3 = false;
            transactionIdsSet.add(transaction.getId());
            transactionBuffer.put(transaction.getId(), (Object)transaction);
            if (transactionBuffer.size() > 10) {
                transactionBuffer.removeAt(0);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(@NotNull HttpTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        this.addToBuffer(transaction);
        if (!BaseChuckerActivity.Companion.isInForeground()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, TRANSACTIONS_CHANNEL_ID).setContentIntent(this.getTransactionsScreenIntent()).setLocalOnly(true).setSmallIcon(R.drawable.chucker_ic_transaction_notification_24dp).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.chucker_color_primary)).setContentTitle((CharSequence)this.context.getString(R.string.chucker_http_notification_title)).setAutoCancel(true).addAction(this.createClearAction(ClearDatabaseService.ClearAction.Transaction.INSTANCE));
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            LongSparseArray<HttpTransaction> longSparseArray = transactionBuffer;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (longSparseArray) {
                boolean bl3 = false;
                int count = 0;
                Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)(transactionBuffer.size() - 1), (int)0);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl4 = false;
                    if (count < 10) {
                        if (count == 0) {
                            builder.setContentText((CharSequence)((HttpTransaction)transactionBuffer.valueAt(i)).getNotificationText());
                        }
                        inboxStyle.addLine((CharSequence)((HttpTransaction)transactionBuffer.valueAt(i)).getNotificationText());
                    }
                    int n = count;
                    count = n + 1;
                }
                builder.setStyle((NotificationCompat.Style)inboxStyle);
                NotificationCompat.Builder builder2 = Build.VERSION.SDK_INT >= 24 ? builder.setSubText((CharSequence)String.valueOf(transactionIdsSet.size())) : builder.setNumber(transactionIdsSet.size());
            }
            this.notificationManager.notify(1138, builder.build());
        }
    }

    public final void show(@NotNull RecordedThrowable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        if (!BaseChuckerActivity.Companion.isInForeground()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, ERRORS_CHANNEL_ID).setContentIntent(this.getErrorsScreenIntent()).setLocalOnly(true).setSmallIcon(R.drawable.chucker_ic_error_notifications_24dp).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.chucker_status_error)).setContentTitle((CharSequence)throwable.getClazz()).setAutoCancel(true).setContentText((CharSequence)throwable.getMessage()).addAction(this.createClearAction(ClearDatabaseService.ClearAction.Error.INSTANCE));
            this.notificationManager.notify(3546, builder.build());
        }
    }

    private final NotificationCompat.Action createClearAction(ClearDatabaseService.ClearAction clearAction) {
        String clearTitle = this.context.getString(R.string.chucker_clear);
        Intent intent = new Intent(this.context, ClearDatabaseService.class);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.putExtra("EXTRA_ITEM_TO_CLEAR", (Serializable)clearAction);
        Intent deleteIntent = intent;
        PendingIntent intent2 = PendingIntent.getService((Context)this.context, (int)11, (Intent)deleteIntent, (int)0x40000000);
        return new NotificationCompat.Action(R.drawable.chucker_ic_delete_white_24dp, (CharSequence)clearTitle, intent2);
    }

    public final void dismissTransactionsNotification() {
        this.notificationManager.cancel(1138);
    }

    public final void dismissErrorsNotification() {
        this.notificationManager.cancel(3546);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public NotificationHelper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        this.notificationManager = (NotificationManager)object;
        this.transactionsScreenIntent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PendingIntent>(this){
            final /* synthetic */ NotificationHelper this$0;

            public final PendingIntent invoke() {
                return PendingIntent.getActivity((Context)this.this$0.getContext(), (int)1138, (Intent)Chucker.getLaunchIntent(this.this$0.getContext(), 1), (int)0x8000000);
            }
            {
                this.this$0 = notificationHelper;
                super(0);
            }
        }));
        this.errorsScreenIntent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PendingIntent>(this){
            final /* synthetic */ NotificationHelper this$0;

            public final PendingIntent invoke() {
                return PendingIntent.getActivity((Context)this.this$0.getContext(), (int)3546, (Intent)Chucker.getLaunchIntent(this.this$0.getContext(), 2), (int)0x8000000);
            }
            {
                this.this$0 = notificationHelper;
                super(0);
            }
        }));
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel transactionsChannel = new NotificationChannel(TRANSACTIONS_CHANNEL_ID, (CharSequence)this.context.getString(R.string.chucker_networks_notification_category), 2);
            NotificationChannel errorsChannel = new NotificationChannel(ERRORS_CHANNEL_ID, (CharSequence)this.context.getString(R.string.chucker_errors_notification_category), 2);
            this.notificationManager.createNotificationChannels(CollectionsKt.listOf((Object[])new NotificationChannel[]{transactionsChannel, errorsChannel}));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/chuckerteam/chucker/internal/support/NotificationHelper$Companion;", "", "()V", "BUFFER_SIZE", "", "ERRORS_CHANNEL_ID", "", "ERROR_NOTIFICATION_ID", "INTENT_REQUEST_CODE", "TRANSACTIONS_CHANNEL_ID", "TRANSACTION_NOTIFICATION_ID", "transactionBuffer", "Landroid/util/LongSparseArray;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "transactionIdsSet", "Ljava/util/HashSet;", "", "clearBuffer", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearBuffer() {
            LongSparseArray longSparseArray = transactionBuffer;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (longSparseArray) {
                boolean bl3 = false;
                transactionBuffer.clear();
                transactionIdsSet.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

