/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ShareCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelProviders;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPagerAdapter;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModelFactory;
import com.google.android.material.tabs.TabLayout;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0014J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionActivity;", "Lcom/chuckerteam/chucker/internal/ui/BaseChuckerActivity;", "()V", "title", "Landroid/widget/TextView;", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onResume", "setupViewPager", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "share", "transactionDetailsText", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionActivity
extends BaseChuckerActivity {
    private TextView title;
    private TransactionViewModel viewModel;
    private static final String MIME_TYPE = "text/plain";
    private static final String EXTRA_TRANSACTION_ID = "transaction_id";
    private static int selectedTabPosition;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        block2: {
            super.onCreate(savedInstanceState);
            this.setContentView(R.layout.chucker_activity_transaction);
            long transactionId = this.getIntent().getLongExtra(EXTRA_TRANSACTION_ID, 0L);
            ViewModel viewModel = ViewModelProviders.of((FragmentActivity)((FragmentActivity)this), (ViewModelProvider.Factory)new TransactionViewModelFactory(transactionId)).get(TransactionViewModel.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProviders\n     \u2026ionViewModel::class.java)");
            TransactionViewModel transactionViewModel = this.viewModel = (TransactionViewModel)viewModel;
            if (transactionViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            transactionViewModel.loadTransaction();
            Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
            this.setSupportActionBar(toolbar);
            View view = this.findViewById(R.id.toolbar_title);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.toolbar_title)");
            this.title = (TextView)view;
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.setDisplayHomeAsUpEnabled(true);
            }
            ViewPager viewPager = (ViewPager)this.findViewById(R.id.viewpager);
            if (viewPager == null) break block2;
            ViewPager viewPager2 = viewPager;
            boolean bl = false;
            boolean bl2 = false;
            ViewPager viewPager3 = viewPager2;
            boolean bl3 = false;
            this.setupViewPager(viewPager3);
            ((TabLayout)this.findViewById(R.id.tabs)).setupWithViewPager(viewPager3);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        TransactionViewModel transactionViewModel = this.viewModel;
        if (transactionViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        transactionViewModel.getTransactionTitle$com_github_ChuckerTeam_Chucker_library().observe((LifecycleOwner)this, (Observer)new Observer<String>(this){
            final /* synthetic */ TransactionActivity this$0;

            public final void onChanged(String it) {
                TransactionActivity.access$getTitle$p(this.this$0).setText((CharSequence)it);
            }
            {
                this.this$0 = transactionActivity;
            }
        });
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.chucker_transaction, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.share_text) {
            Context context = (Context)this;
            TransactionViewModel transactionViewModel = this.viewModel;
            if (transactionViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            Object object = transactionViewModel.getTransaction$com_github_ChuckerTeam_Chucker_library().getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"viewModel.transaction.value!!");
            this.share(FormatUtils.INSTANCE.getShareText(context, (HttpTransaction)object));
            bl = true;
        } else if (n == R.id.share_curl) {
            TransactionViewModel transactionViewModel = this.viewModel;
            if (transactionViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            Object object = transactionViewModel.getTransaction$com_github_ChuckerTeam_Chucker_library().getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"viewModel.transaction.value!!");
            this.share(FormatUtils.INSTANCE.getShareCurlCommand((HttpTransaction)object));
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    private final void setupViewPager(ViewPager viewPager) {
        Context context = (Context)this;
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        viewPager.setAdapter((PagerAdapter)new TransactionPagerAdapter(context, fragmentManager));
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                TransactionActivity.access$setSelectedTabPosition$cp(position);
            }
        });
        viewPager.setCurrentItem(selectedTabPosition);
    }

    private final void share(String transactionDetailsText) {
        this.startActivity(ShareCompat.IntentBuilder.from((Activity)((Activity)this)).setType(MIME_TYPE).setChooserTitle((CharSequence)this.getString(R.string.chucker_share_transaction_title)).setSubject(this.getString(R.string.chucker_share_transaction_subject)).setText((CharSequence)transactionDetailsText).createChooserIntent());
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ TextView access$getTitle$p(TransactionActivity $this) {
        TextView textView = $this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        }
        return textView;
    }

    public static final /* synthetic */ void access$setTitle$p(TransactionActivity $this, TextView textView) {
        $this.title = textView;
    }

    public static final /* synthetic */ int access$getSelectedTabPosition$cp() {
        return selectedTabPosition;
    }

    public static final /* synthetic */ void access$setSelectedTabPosition$cp(int n) {
        selectedTabPosition = n;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionActivity$Companion;", "", "()V", "EXTRA_TRANSACTION_ID", "", "MIME_TYPE", "selectedTabPosition", "", "start", "", "context", "Landroid/content/Context;", "transactionId", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        public final void start(@NotNull Context context, long transactionId) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intent intent = new Intent(context, TransactionActivity.class);
            intent.putExtra(TransactionActivity.EXTRA_TRANSACTION_ID, transactionId);
            context.startActivity(intent);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

