/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.support;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.util.LongSparseArray;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.api.internal.support.ClearTransactionsService;
import com.chuckerteam.chucker.api.internal.ui.BaseChuckerActivity;
import java.util.HashSet;

public class NotificationHelper {
    private static final String CHANNEL_ID = "chucker";
    private static final int TRANSACTION_NOTIFICATION_ID = 1138;
    private static final int ERROR_NOTIFICATION_ID = 3546;
    private static final int BUFFER_SIZE = 10;
    private static final LongSparseArray<HttpTransaction> transactionBuffer = new LongSparseArray();
    private static final HashSet<Long> transactionIdsSet = new HashSet();
    private final Context context;
    private final NotificationManager notificationManager;

    public static synchronized void clearBuffer() {
        transactionBuffer.clear();
        transactionIdsSet.clear();
    }

    private static synchronized void addToBuffer(HttpTransaction transaction) {
        if (transaction.getId() == 0L) {
            return;
        }
        transactionIdsSet.add(transaction.getId());
        transactionBuffer.put(transaction.getId(), (Object)transaction);
        if (transactionBuffer.size() > 10) {
            transactionBuffer.removeAt(0);
        }
    }

    public NotificationHelper(Context context) {
        this.context = context;
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            this.notificationManager.createNotificationChannel(new NotificationChannel(CHANNEL_ID, (CharSequence)context.getString(R.string.chucker_notification_category), 2));
        }
    }

    public synchronized void show(HttpTransaction transaction) {
        NotificationHelper.addToBuffer(transaction);
        if (!BaseChuckerActivity.isInForeground()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, CHANNEL_ID).setContentIntent(PendingIntent.getActivity((Context)this.context, (int)1138, (Intent)Chucker.getLaunchIntent(this.context, 1), (int)0x8000000)).setLocalOnly(true).setSmallIcon(R.drawable.chucker_ic_notification).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.chucker_primary_color)).setContentTitle((CharSequence)this.context.getString(R.string.chucker_http_notification_title)).addAction(this.createClearAction(0));
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            int count = 0;
            for (int i = transactionBuffer.size() - 1; i >= 0; --i) {
                if (count < 10) {
                    if (count == 0) {
                        builder.setContentText((CharSequence)((HttpTransaction)transactionBuffer.valueAt(i)).getNotificationText());
                    }
                    inboxStyle.addLine((CharSequence)((HttpTransaction)transactionBuffer.valueAt(i)).getNotificationText());
                }
                ++count;
            }
            builder.setAutoCancel(true);
            builder.setStyle((NotificationCompat.Style)inboxStyle);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setSubText((CharSequence)String.valueOf(transactionIdsSet.size()));
            } else {
                builder.setNumber(transactionIdsSet.size());
            }
            this.notificationManager.notify(1138, builder.build());
        }
    }

    public void show(RecordedThrowable throwable) {
        if (!BaseChuckerActivity.isInForeground()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, CHANNEL_ID).setContentIntent(PendingIntent.getActivity((Context)this.context, (int)3546, (Intent)Chucker.getLaunchIntent(this.context, 2), (int)0x8000000)).setLocalOnly(true).setSmallIcon(R.drawable.chucker_ic_subject_white_24dp).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.chucker_status_error)).setContentTitle((CharSequence)throwable.getClazz()).setAutoCancel(true).setContentText((CharSequence)throwable.getMessage()).addAction(this.createClearAction(1));
            this.notificationManager.notify(3546, builder.build());
        }
    }

    @NonNull
    private NotificationCompat.Action createClearAction(@ClearTransactionsService.Clear int itemsToClear) {
        String clearTitle = this.context.getString(R.string.chucker_clear);
        Intent deleteIntent = new Intent(this.context, ClearTransactionsService.class);
        deleteIntent.putExtra("EXTRA_ITEM_TO_CLEAR", itemsToClear);
        PendingIntent intent = PendingIntent.getService((Context)this.context, (int)11, (Intent)deleteIntent, (int)0x40000000);
        return new NotificationCompat.Action(R.drawable.chucker_ic_delete_white_24dp, (CharSequence)clearTitle, intent);
    }

    public void dismissTransactionsNotification() {
        this.notificationManager.cancel(1138);
    }

    public void dismissErrorsNotification() {
        this.notificationManager.cancel(3546);
    }
}

