/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.support;

import android.content.Context;
import android.text.TextUtils;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.support.JsonConvertor;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class FormatUtils {
    public static String formatHeaders(List<HttpHeader> httpHeaders, boolean withMarkup) {
        String out = "";
        if (httpHeaders != null) {
            for (HttpHeader header : httpHeaders) {
                out = out + (withMarkup ? "<b>" : "") + header.getName() + ": " + (withMarkup ? "</b>" : "") + header.getValue() + (withMarkup ? "<br />" : "\n");
            }
        }
        return out;
    }

    public static String formatByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.US, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String formatJson(String json) {
        try {
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(json);
            return JsonConvertor.getInstance().toJson(je);
        }
        catch (Exception e) {
            return json;
        }
    }

    public static String formatXml(String xml) {
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer serializer = transformerFactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes())));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray());
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static String getShareText(Context context, HttpTransaction transaction) {
        String text = "";
        text = text + context.getString(R.string.chucker_url) + ": " + FormatUtils.v(transaction.getUrl()) + "\n";
        text = text + context.getString(R.string.chucker_method) + ": " + FormatUtils.v(transaction.getMethod()) + "\n";
        text = text + context.getString(R.string.chucker_protocol) + ": " + FormatUtils.v(transaction.getProtocol()) + "\n";
        text = text + context.getString(R.string.chucker_status) + ": " + FormatUtils.v(transaction.getStatus().toString()) + "\n";
        text = text + context.getString(R.string.chucker_response) + ": " + FormatUtils.v(transaction.getResponseSummaryText()) + "\n";
        text = text + context.getString(R.string.chucker_ssl) + ": " + FormatUtils.v(context.getString(transaction.isSsl() ? R.string.chucker_yes : R.string.chucker_no)) + "\n";
        text = text + "\n";
        text = text + context.getString(R.string.chucker_request_time) + ": " + FormatUtils.v(transaction.getRequestDateString()) + "\n";
        text = text + context.getString(R.string.chucker_response_time) + ": " + FormatUtils.v(transaction.getResponseDateString()) + "\n";
        text = text + context.getString(R.string.chucker_duration) + ": " + FormatUtils.v(transaction.getDurationString()) + "\n";
        text = text + "\n";
        text = text + context.getString(R.string.chucker_request_size) + ": " + FormatUtils.v(transaction.getRequestSizeString()) + "\n";
        text = text + context.getString(R.string.chucker_response_size) + ": " + FormatUtils.v(transaction.getResponseSizeString()) + "\n";
        text = text + context.getString(R.string.chucker_total_size) + ": " + FormatUtils.v(transaction.getTotalSizeString()) + "\n";
        text = text + "\n";
        text = text + "---------- " + context.getString(R.string.chucker_request) + " ----------\n\n";
        String headers = FormatUtils.formatHeaders(transaction.getParsedRequestHeaders(), false);
        if (!TextUtils.isEmpty((CharSequence)headers)) {
            text = text + headers + "\n";
        }
        text = text + (transaction.isRequestBodyPlainText() ? FormatUtils.v(transaction.getFormattedRequestBody()) : context.getString(R.string.chucker_body_omitted));
        text = text + "\n\n";
        text = text + "---------- " + context.getString(R.string.chucker_response) + " ----------\n\n";
        headers = FormatUtils.formatHeaders(transaction.getParsedResponseHeaders(), false);
        if (!TextUtils.isEmpty((CharSequence)headers)) {
            text = text + headers + "\n";
        }
        text = text + (transaction.isResponseBodyPlainText() ? FormatUtils.v(transaction.getFormattedResponseBody()) : context.getString(R.string.chucker_body_omitted));
        return text;
    }

    public static String getShareCurlCommand(HttpTransaction transaction) {
        boolean compressed = false;
        String curlCmd = "curl";
        curlCmd = curlCmd + " -X " + transaction.getMethod();
        List<HttpHeader> headers = transaction.getParsedRequestHeaders();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            String name = headers.get(i).getName();
            String value = headers.get(i).getValue();
            if ("Accept-Encoding".equalsIgnoreCase(name) && "gzip".equalsIgnoreCase(value)) {
                compressed = true;
            }
            curlCmd = curlCmd + " -H \"" + name + ": " + value + "\"";
        }
        String requestBody = transaction.getRequestBody();
        if (requestBody != null && requestBody.length() > 0) {
            curlCmd = curlCmd + " --data $'" + requestBody.replace("\n", "\\n") + "'";
        }
        curlCmd = curlCmd + (compressed ? " --compressed " : " ") + transaction.getUrl();
        return curlCmd;
    }

    public static String formatThrowable(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    private static String v(String string2) {
        return string2 != null ? string2 : "";
    }
}

