/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui.transaction;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.ui.transaction.TransactionFragment;

public class TransactionPayloadFragment
extends Fragment
implements TransactionFragment {
    public static final int TYPE_REQUEST = 0;
    public static final int TYPE_RESPONSE = 1;
    private static final String ARG_TYPE = "type";
    TextView headers;
    TextView body;
    private int type;
    private HttpTransaction transaction;

    public static TransactionPayloadFragment newInstance(int type) {
        TransactionPayloadFragment fragment = new TransactionPayloadFragment();
        Bundle b = new Bundle();
        b.putInt(ARG_TYPE, type);
        fragment.setArguments(b);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.type = this.getArguments().getInt(ARG_TYPE);
        this.setRetainInstance(true);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chuck_fragment_transaction_payload, container, false);
        this.headers = (TextView)view.findViewById(R.id.headers);
        this.body = (TextView)view.findViewById(R.id.body);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.populateUI();
    }

    @Override
    public void transactionUpdated(HttpTransaction transaction) {
        this.transaction = transaction;
        this.populateUI();
    }

    private void populateUI() {
        if (this.isAdded() && this.transaction != null) {
            switch (this.type) {
                case 0: {
                    this.setText(this.transaction.getRequestHeadersString(true), this.transaction.getFormattedRequestBody(), this.transaction.requestBodyIsPlainText());
                    break;
                }
                case 1: {
                    this.setText(this.transaction.getResponseHeadersString(true), this.transaction.getFormattedResponseBody(), this.transaction.responseBodyIsPlainText());
                }
            }
        }
    }

    private void setText(String headersString, String bodyString, boolean isPlainText) {
        this.headers.setVisibility(TextUtils.isEmpty((CharSequence)headersString) ? 8 : 0);
        this.headers.setText((CharSequence)Html.fromHtml((String)headersString));
        if (!isPlainText) {
            this.body.setText((CharSequence)this.getString(R.string.chuck_body_omitted));
        } else {
            this.body.setText((CharSequence)bodyString);
        }
    }
}

