/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui.transaction;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.support.NotificationHelper;
import com.readystatesoftware.chuck.internal.support.SQLiteUtils;
import com.readystatesoftware.chuck.internal.ui.transaction.TransactionAdapter;

public class TransactionListFragment
extends Fragment
implements SearchView.OnQueryTextListener,
LoaderManager.LoaderCallbacks<Cursor> {
    private String currentFilter;
    private OnListFragmentInteractionListener listener;
    private TransactionAdapter adapter;

    public static TransactionListFragment newInstance() {
        return new TransactionListFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chuck_fragment_transaction_list, container, false);
        if (view instanceof RecyclerView) {
            Context context = view.getContext();
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
            this.adapter = new TransactionAdapter(this.getContext(), this.listener);
            recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        }
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnListFragmentInteractionListener)) {
            throw new RuntimeException(context.toString() + " must implement OnListFragmentInteractionListener");
        }
        this.listener = (OnListFragmentInteractionListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.chuck_transactions_list, menu2);
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)searchMenuItem.getActionView();
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.getContext().getContentResolver().delete(ChuckContentProvider.TRANSACTION_URI, null, null);
            NotificationHelper.clearBuffer();
            return true;
        }
        if (item.getItemId() == R.id.browse_sql) {
            SQLiteUtils.browseDatabase(this.getContext());
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        CursorLoader loader = new CursorLoader(this.getContext());
        loader.setUri(ChuckContentProvider.TRANSACTION_URI);
        if (!TextUtils.isEmpty((CharSequence)this.currentFilter)) {
            if (TextUtils.isDigitsOnly((CharSequence)this.currentFilter)) {
                loader.setSelection("responseCode LIKE ?");
                loader.setSelectionArgs(new String[]{this.currentFilter + "%"});
            } else {
                loader.setSelection("path LIKE ?");
                loader.setSelectionArgs(new String[]{"%" + this.currentFilter + "%"});
            }
        }
        loader.setProjection(HttpTransaction.PARTIAL_PROJECTION);
        loader.setSortOrder("requestDate DESC");
        return loader;
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor data) {
        this.adapter.swapCursor(data);
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
        this.adapter.swapCursor(null);
    }

    public boolean onQueryTextSubmit(String query) {
        return true;
    }

    public boolean onQueryTextChange(String newText) {
        this.currentFilter = newText;
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    public static interface OnListFragmentInteractionListener {
        public void onListFragmentInteraction(HttpTransaction var1);
    }
}

