/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.api;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import com.readystatesoftware.chuck.api.RetentionManager;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.data.RecordedThrowable;
import com.readystatesoftware.chuck.internal.support.NotificationHelper;

public class ChuckCollector {
    private static final Period DEFAULT_RETENTION = Period.ONE_WEEK;
    private final Context context;
    private final NotificationHelper notificationHelper;
    private RetentionManager retentionManager;
    private boolean showNotification;

    public ChuckCollector(Context context) {
        this.context = context;
        this.notificationHelper = new NotificationHelper(this.context);
        this.showNotification = true;
        this.retentionManager = new RetentionManager(context, DEFAULT_RETENTION);
    }

    public Uri onRequestSent(HttpTransaction transaction) {
        ContentValues values = LocalCupboard.getInstance().withEntity(HttpTransaction.class).toContentValues((Object)transaction);
        Uri uri = this.context.getContentResolver().insert(ChuckContentProvider.TRANSACTION_URI, values);
        transaction.setId(Long.valueOf(uri.getLastPathSegment()));
        if (this.showNotification) {
            this.notificationHelper.show(transaction);
        }
        this.retentionManager.doMaintenance();
        return uri;
    }

    public int onResponseReceived(HttpTransaction transaction, Uri uri) {
        ContentValues values = LocalCupboard.getInstance().withEntity(HttpTransaction.class).toContentValues((Object)transaction);
        int updated = this.context.getContentResolver().update(uri, values, null, null);
        if (this.showNotification && updated > 0) {
            this.notificationHelper.show(transaction);
        }
        return updated;
    }

    public void onError(String tag, Throwable throwable) {
        RecordedThrowable recordedThrowable = new RecordedThrowable(tag, throwable);
        ContentValues values = LocalCupboard.getInstance().withEntity(RecordedThrowable.class).toContentValues((Object)recordedThrowable);
        this.context.getContentResolver().insert(ChuckContentProvider.ERROR_URI, values);
        if (this.showNotification) {
            this.notificationHelper.show(recordedThrowable);
        }
        this.retentionManager.doMaintenance();
    }

    public ChuckCollector showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public ChuckCollector retentionManager(RetentionManager retentionManager) {
        this.retentionManager = retentionManager;
        return this;
    }

    public static enum Period {
        ONE_HOUR,
        ONE_DAY,
        ONE_WEEK,
        FOREVER;

    }
}

