/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.graphics.Paint;
import android.text.TextUtils;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0010\u0010\f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0010\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lcom/core/util/StringUtil;", "", "()V", "getTextWidth", "", "textSize", "", "text", "", "isBoolean", "", "str", "isDecimalNumber", "isEmpty", "isInteger", "removeZero", "formatString", "XUtils_release"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE;

    @NotNull
    public final String removeZero(@NotNull String formatString) {
        Intrinsics.checkNotNullParameter((Object)formatString, (String)"formatString");
        CharSequence charSequence = formatString;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String string = new BigDecimal(formatString).stripTrailingZeros().toPlainString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigDecimal(formatString)\u2026ngZeros().toPlainString()");
            return string;
        }
        return formatString;
    }

    public final int getTextWidth(float textSize, @Nullable String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 0;
        }
        Paint paint = new Paint();
        paint.setTextSize(textSize);
        return (int)paint.measureText(text);
    }

    public final boolean isEmpty(@Nullable String str) {
        boolean bl;
        if (str == null) {
            bl = true;
        } else {
            CharSequence charSequence = str;
            boolean bl2 = false;
            bl = charSequence.length() == 0;
        }
        return bl;
    }

    public final boolean isInteger(@Nullable String str) {
        return this.isEmpty(str) ? false : TextUtils.isDigitsOnly((CharSequence)str);
    }

    public final boolean isBoolean(@Nullable String str) {
        return this.isEmpty(str) ? false : Intrinsics.areEqual((Object)str, (Object)"false") || Intrinsics.areEqual((Object)str, (Object)"true");
    }

    public final boolean isDecimalNumber(@Nullable String str) {
        boolean bl;
        if (this.isEmpty(str)) {
            bl = false;
        } else {
            if (this.isInteger(str)) {
                return false;
            }
            Pattern pattern = Pattern.compile("[+-]?[0-9]+(\\.[0-9]+)?");
            bl = pattern.matcher(str).matches();
        }
        return bl;
    }

    private StringUtil() {
    }

    static {
        StringUtil stringUtil;
        INSTANCE = stringUtil = new StringUtil();
    }
}

