/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.FileProvider;
import com.core.util.ActivityUtil;
import com.core.util.EncryptUtil;
import com.core.util.FileUtil;
import com.core.util.IntentUtil;
import com.core.util.ProcessUtil;
import com.core.util.R;
import com.core.util.ShellUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r\"\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ-\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\r\"\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u001d\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010$J'\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010'\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0003J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u0011H\u0007J\u0018\u00100\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u000eH\u0007J\u001a\u00100\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u00010\u0011H\u0007J\u0018\u00103\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0011H\u0007J\u0010\u00104\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u00105\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u00105\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u00106\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u00106\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\u0018\u00107\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\u0010\u00108\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u00108\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J \u00109\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020:2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0004H\u0007J\u0018\u00109\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J \u0010<\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020:2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0004H\u0007J\u0018\u0010<\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J \u0010=\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\u0005\u0010\b\u00a8\u0006@"}, d2={"Lcom/core/util/AppUtil;", "", "()V", "INSTALL_CODE", "", "isAppRoot", "", "isAppRoot$annotations", "()Z", "cleanAppData", "context", "Landroid/content/Context;", "dirs", "", "Ljava/io/File;", "(Landroid/content/Context;[Ljava/io/File;)Z", "dirPaths", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "dealOSystemBuild", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "getAllAppsInfo", "", "Lcom/core/util/AppUtil$AppInfo;", "getAppDetailsSettings", "", "packageName", "getAppIcon", "Landroid/graphics/drawable/Drawable;", "getAppInfo", "getAppName", "getAppPackageName", "getAppPath", "getAppSignature", "Landroid/content/pm/Signature;", "(Landroid/content/Context;)[Landroid/content/pm/Signature;", "(Landroid/content/Context;Ljava/lang/String;)[Landroid/content/pm/Signature;", "getAppSignatureSHA1", "getAppVersionCode", "getAppVersionName", "getBean", "pm", "Landroid/content/pm/PackageManager;", "pi", "Landroid/content/pm/PackageInfo;", "installAPK", "APK_PATH", "installApp", "apkFile", "filePath", "installAppSilent", "isAppBackground", "isAppDebug", "isAppForeground", "isInstallApp", "isSystemApp", "launchApp", "Landroid/app/Activity;", "requestCode", "uninstallApp", "uninstallAppSilent", "isKeepData", "AppInfo", "XUtils_release"})
public final class AppUtil {
    public static final int INSTALL_CODE = 10110;
    @NotNull
    public static final AppUtil INSTANCE;

    @JvmStatic
    public static final void installApp(@NotNull AppCompatActivity activity, @Nullable String filePath) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        File apkFile = new File(filePath);
        AppUtil.installApp(activity, apkFile);
    }

    @JvmStatic
    public static final void installApp(@NotNull AppCompatActivity activity, @NotNull File apkFile) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        if (ActivityUtil.INSTANCE.isDestroy(activity)) {
            return;
        }
        if (!apkFile.exists()) {
            return;
        }
        if (!INSTANCE.dealOSystemBuild(activity)) {
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setFlags(1);
            intent.setFlags(2);
            ApplicationInfo applicationInfo = activity.getApplicationInfo();
            Uri contentUri = FileProvider.getUriForFile((Context)((Context)activity), (String)(applicationInfo.packageName + ".fileprovider"), (File)apkFile);
            intent.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
        }
        activity.startActivity(intent);
        activity.overridePendingTransition(R.anim.in_from_right, R.anim.no_anim_400);
        activity.finish();
    }

    private final boolean dealOSystemBuild(AppCompatActivity activity) {
        Context application;
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        Context context = application = activity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"application");
        if (context.getPackageManager().canRequestPackageInstalls()) {
            return true;
        }
        Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES", Uri.parse((String)("package:" + application.getPackageName())));
        activity.startActivityForResult(intent, 10110);
        activity.overridePendingTransition(R.anim.in_from_right, R.anim.no_anim_400);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean installAppSilent(@NotNull Context context, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = FileUtil.getFileByPath(filePath);
        if (!FileUtil.isFileExists(file)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install " + filePath;
        ShellUtil.CommandResult commandResult = ShellUtil.execCmd(command, !AppUtil.isSystemApp(context), true);
        if (commandResult.getSuccessMsg() == null) return false;
        String string = commandResult.getSuccessMsg();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)"success", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isSystemApp(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.isSystemApp(context, context.getPackageName());
    }

    @JvmStatic
    public static final boolean isSystemApp(@NotNull Context context, @Nullable String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = packageName;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || charSequence.length() == 0) {
            bl = false;
        } else {
            boolean bl4;
            try {
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                ApplicationInfo applicationInfo = pm.getApplicationInfo(string, 0);
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(packageName!!, 0)");
                ApplicationInfo ai = applicationInfo;
                bl4 = (ai.flags & 1) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                bl4 = false;
            }
            bl = bl4;
        }
        return bl;
    }

    @JvmStatic
    public static final void uninstallApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return;
        }
        context.startActivity(IntentUtil.getUninstallAppIntent(packageName));
    }

    @JvmStatic
    public static final void uninstallApp(@NotNull Activity activity, @NotNull String packageName, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return;
        }
        activity.startActivityForResult(IntentUtil.getUninstallAppIntent(packageName), requestCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean uninstallAppSilent(@NotNull Context context, @NotNull String packageName, boolean isKeepData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        ShellUtil.CommandResult commandResult = ShellUtil.execCmd(command, !AppUtil.isSystemApp(context), true);
        if (commandResult.getSuccessMsg() == null) return false;
        String string = commandResult.getSuccessMsg();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"success", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    public static /* synthetic */ void isAppRoot$annotations() {
    }

    public static final boolean isAppRoot() {
        ShellUtil.CommandResult result = ShellUtil.execCmd("echo root", true);
        if (result.getResult() == 0) {
            return true;
        }
        if (result.getErrorMsg() != null) {
            String string = result.getErrorMsg();
            Intrinsics.checkNotNull((Object)string);
            Log.d((String)"isAppRoot", (String)string);
        }
        return false;
    }

    @JvmStatic
    public static final void launchApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return;
        }
        context.startActivity(IntentUtil.getLaunchAppIntent(context, packageName));
    }

    @JvmStatic
    public static final void launchApp(@NotNull Activity activity, @NotNull String packageName, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return;
        }
        activity.startActivityForResult(IntentUtil.getLaunchAppIntent((Context)activity, packageName), requestCode);
    }

    @JvmStatic
    @NotNull
    public static final String getAppPackageName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return string;
    }

    @JvmStatic
    public static final void getAppDetailsSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AppUtil.getAppDetailsSettings(context, context.getPackageName());
    }

    @JvmStatic
    public static final void getAppDetailsSettings(@NotNull Context context, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        context.startActivity(IntentUtil.getAppDetailsSettingsIntent(packageName));
    }

    @JvmStatic
    @Nullable
    public static final String getAppName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppName(context, context.getPackageName());
    }

    @JvmStatic
    @Nullable
    public static final String getAppName(@NotNull Context context, @Nullable String packageName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence2 = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            charSequence = null;
        } else {
            try {
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                PackageInfo pi = pm.getPackageInfo(string, 0);
                Object object = pi;
                charSequence2 = object != null && (object = ((PackageInfo)object).applicationInfo) != null && (object = object.loadLabel(pm)) != null ? object.toString() : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                charSequence2 = null;
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    @JvmStatic
    @Nullable
    public static final Drawable getAppIcon(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppIcon(context, context.getPackageName());
    }

    @JvmStatic
    @Nullable
    public static final Drawable getAppIcon(@NotNull Context context, @Nullable String packageName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence2 = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            charSequence = null;
        } else {
            try {
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                PackageInfo pi = pm.getPackageInfo(string, 0);
                PackageInfo packageInfo = pi;
                charSequence2 = packageInfo != null && (packageInfo = packageInfo.applicationInfo) != null ? packageInfo.loadIcon(pm) : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                charSequence2 = null;
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    @JvmStatic
    @Nullable
    public static final String getAppPath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppPath(context, context.getPackageName());
    }

    @JvmStatic
    @Nullable
    public static final String getAppPath(@NotNull Context context, @Nullable String packageName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence2 = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            charSequence = null;
        } else {
            try {
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                PackageInfo pi = pm.getPackageInfo(string, 0);
                PackageInfo packageInfo = pi;
                charSequence2 = packageInfo != null && (packageInfo = packageInfo.applicationInfo) != null ? packageInfo.sourceDir : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                charSequence2 = null;
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    @JvmStatic
    @Nullable
    public static final String getAppVersionName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppVersionName(context, context.getPackageName());
    }

    @JvmStatic
    @Nullable
    public static final String getAppVersionName(@NotNull Context context, @Nullable String packageName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence2 = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            charSequence = null;
        } else {
            try {
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                PackageInfo packageInfo = pi = pm.getPackageInfo(string, 0);
                charSequence2 = packageInfo != null ? packageInfo.versionName : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                charSequence2 = null;
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    @JvmStatic
    public static final int getAppVersionCode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppVersionCode(context, context.getPackageName());
    }

    @JvmStatic
    public static final int getAppVersionCode(@NotNull Context context, @Nullable String packageName) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            n = -1;
        } else {
            int n2;
            try {
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                PackageInfo packageInfo = pi = pm.getPackageInfo(string, 0);
                n2 = packageInfo != null ? packageInfo.versionCode : -1;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                n2 = -1;
            }
            n = n2;
        }
        return n;
    }

    @JvmStatic
    public static final boolean isAppDebug(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.isAppDebug(context, context.getPackageName());
    }

    @JvmStatic
    public static final boolean isAppDebug(@NotNull Context context, @Nullable String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = packageName;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || charSequence.length() == 0) {
            bl = false;
        } else {
            boolean bl4;
            try {
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                ApplicationInfo applicationInfo = pm.getApplicationInfo(string, 0);
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(packageName!!, 0)");
                ApplicationInfo ai = applicationInfo;
                bl4 = ai != null && (ai.flags & 2) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                bl4 = false;
            }
            bl = bl4;
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Signature[] getAppSignature(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppSignature(context, context.getPackageName());
    }

    @JvmStatic
    @SuppressLint(value={"PackageManagerGetSignatures"})
    @Nullable
    public static final Signature[] getAppSignature(@NotNull Context context, @Nullable String packageName) {
        Signature[] signatureArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Signature[] signatureArray2 = (Signature[])packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (signatureArray2 == null || signatureArray2.length() == 0) {
            signatureArray = null;
        } else {
            try {
                PackageInfo pi;
                PackageManager pm = context.getPackageManager();
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                PackageInfo packageInfo = pi = pm.getPackageInfo(string, 64);
                signatureArray2 = packageInfo != null ? packageInfo.signatures : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                signatureArray2 = null;
            }
            signatureArray = signatureArray2;
        }
        return signatureArray;
    }

    @JvmStatic
    @Nullable
    public static final String getAppSignatureSHA1(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AppUtil.getAppSignatureSHA1(context, context.getPackageName());
    }

    @JvmStatic
    @Nullable
    public static final String getAppSignatureSHA1(@NotNull Context context, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Signature[] signatureArray = AppUtil.getAppSignature(context, packageName);
        if (signatureArray == null) {
            return null;
        }
        Signature[] signature = signatureArray;
        CharSequence charSequence = EncryptUtil.encryptSHA1ToString(signature[0].toByteArray());
        String string = "(?<=[0-9A-F]{2})[0-9A-F]{2}";
        boolean bl = false;
        string = new Regex(string);
        String string2 = ":$0";
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    @JvmStatic
    public static final boolean isAppForeground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        List infos = manager.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.importance != 100) continue;
            return Intrinsics.areEqual((Object)info.processName, (Object)context.getPackageName());
        }
        return false;
    }

    @JvmStatic
    public static final boolean isAppForeground(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence.length() == 0) && Intrinsics.areEqual((Object)packageName, (Object)ProcessUtil.getForegroundProcessName(context));
    }

    @JvmStatic
    public static final boolean isInstallApp(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence.length() == 0) && IntentUtil.getLaunchAppIntent(context, packageName) != null;
    }

    @JvmStatic
    public static final void installAPK(@NotNull Context context, @NotNull String APK_PATH) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)APK_PATH, (String)"APK_PATH");
        Intent i = new Intent("android.intent.action.VIEW");
        i.setFlags(0x10000000);
        i.setDataAndType(Uri.parse((String)("file://" + APK_PATH)), "application/vnd.android.package-archive");
        context.startActivity(i);
    }

    @JvmStatic
    @Nullable
    public static final AppInfo getAppInfo(@NotNull Context context) {
        AppInfo appInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = null;
        try {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            pi = pm.getPackageInfo(context2.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PackageInfo packageInfo = pi;
        if (packageInfo != null) {
            PackageInfo packageInfo2 = packageInfo;
            boolean bl = false;
            boolean bl2 = false;
            PackageInfo it = packageInfo2;
            boolean bl3 = false;
            PackageManager packageManager = pm;
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"pm");
            appInfo = AppUtil.getBean(packageManager, it);
        } else {
            appInfo = null;
        }
        return appInfo;
    }

    @JvmStatic
    private static final AppInfo getBean(PackageManager pm, PackageInfo pi) {
        ApplicationInfo ai = pi.applicationInfo;
        String name = ((Object)ai.loadLabel(pm)).toString();
        Drawable icon = ai.loadIcon(pm);
        String packageName = pi.packageName;
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSD = (1 & ai.flags) != 1;
        boolean isUser = (1 & ai.flags) != 1;
        return new AppInfo(name, icon, packageName, packagePath, versionName, versionCode, isSD, isUser);
    }

    @JvmStatic
    @NotNull
    public static final List<AppInfo> getAllAppsInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = new ArrayList();
        PackageManager pm = context.getPackageManager();
        List list2 = pm.getInstalledPackages(0);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"pm.getInstalledPackages(0)");
        List installedPackages = list2;
        for (PackageInfo pi : installedPackages) {
            if (pi == null) continue;
            PackageManager packageManager = pm;
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"pm");
            list.add(AppUtil.getBean(packageManager, pi));
        }
        return list;
    }

    @JvmStatic
    public static final boolean isAppBackground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List tasks = am.getRunningTasks(1);
        if (!tasks.isEmpty()) {
            ComponentName topActivity;
            ComponentName componentName = topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity;
            Intrinsics.checkNotNull((Object)componentName);
            return Intrinsics.areEqual((Object)componentName.getPackageName(), (Object)context.getPackageName()) ^ true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean cleanAppData(@NotNull Context context, String ... dirPaths) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dirPaths, (String)"dirPaths");
        File[] dirs = new File[dirPaths.length];
        int i = 0;
        for (String dirPath : dirPaths) {
            dirs[i++] = new File(dirPath);
        }
        return AppUtil.cleanAppData(context, Arrays.copyOf(dirs, dirs.length));
    }

    @JvmStatic
    public static final boolean cleanAppData(@NotNull Context context, File ... dirs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        boolean isSuccess = FileUtil.cleanInternalCache(context);
        isSuccess &= FileUtil.cleanInternalDbs(context);
        isSuccess &= FileUtil.cleanInternalSP(context);
        isSuccess &= FileUtil.cleanInternalFiles(context);
        isSuccess &= FileUtil.cleanExternalCache(context);
        for (File dir : dirs) {
            isSuccess &= FileUtil.cleanCustomCache(dir);
        }
        return isSuccess;
    }

    private AppUtil() {
    }

    static {
        AppUtil appUtil;
        INSTANCE = appUtil = new AppUtil();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\u0018\u00002\u00020\u0001BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0013\"\u0004\b\u0016\u0010\u0015R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/core/util/AppUtil$AppInfo;", "", "name", "", "icon", "Landroid/graphics/drawable/Drawable;", "packageName", "packagePath", "versionName", "versionCode", "", "isSD", "", "isUser", "(Ljava/lang/String;Landroid/graphics/drawable/Drawable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZZ)V", "getIcon", "()Landroid/graphics/drawable/Drawable;", "setIcon", "(Landroid/graphics/drawable/Drawable;)V", "()Z", "setSD", "(Z)V", "setUser", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPackageName", "setPackageName", "getPackagePath", "setPackagePath", "getVersionCode", "()I", "setVersionCode", "(I)V", "getVersionName", "setVersionName", "XUtils_release"})
    public static final class AppInfo {
        @Nullable
        private String name;
        @Nullable
        private Drawable icon;
        @Nullable
        private String packageName;
        @Nullable
        private String packagePath;
        @Nullable
        private String versionName;
        private int versionCode;
        private boolean isSD;
        private boolean isUser;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final Drawable getIcon() {
            return this.icon;
        }

        public final void setIcon(@Nullable Drawable drawable2) {
            this.icon = drawable2;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(@Nullable String string) {
            this.packageName = string;
        }

        @Nullable
        public final String getPackagePath() {
            return this.packagePath;
        }

        public final void setPackagePath(@Nullable String string) {
            this.packagePath = string;
        }

        @Nullable
        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(@Nullable String string) {
            this.versionName = string;
        }

        public final int getVersionCode() {
            return this.versionCode;
        }

        public final void setVersionCode(int n) {
            this.versionCode = n;
        }

        public final boolean isSD() {
            return this.isSD;
        }

        public final void setSD(boolean bl) {
            this.isSD = bl;
        }

        public final boolean isUser() {
            return this.isUser;
        }

        public final void setUser(boolean bl) {
            this.isUser = bl;
        }

        public AppInfo(@Nullable String name, @Nullable Drawable icon, @Nullable String packageName, @Nullable String packagePath, @Nullable String versionName, int versionCode, boolean isSD, boolean isUser) {
            this.name = name;
            this.icon = icon;
            this.packageName = packageName;
            this.packagePath = packagePath;
            this.versionName = versionName;
            this.versionCode = versionCode;
            this.isSD = isSD;
            this.isUser = isUser;
        }
    }
}

