/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.FragmentManager;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0011\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0016H\u0007J\u0012\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0017\u001a\u00020\u000bH\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0019H\u0007J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u001cJ$\u0010\u001d\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0007J\u0012\u0010\u001f\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J6\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0010\u0010!\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00162\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0007JB\u0010&\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0010\u0010!\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00162\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0007R$\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006*"}, d2={"Lcom/core/util/ActivityUtil;", "", "()V", "activityStack", "Ljava/util/Stack;", "Landroid/app/Activity;", "getActivityStack", "()Ljava/util/Stack;", "setActivityStack", "(Ljava/util/Stack;)V", "AppExit", "", "context", "Landroid/content/Context;", "addActivity", "activity", "currentActivity", "finishActivity", "mContext", "isTransition", "", "cls", "Ljava/lang/Class;", "finishAllActivity", "getLauncherActivity", "", "packageName", "isDestroy", "Landroidx/appcompat/app/AppCompatActivity;", "isExistActivity", "className", "removeActivity", "skipActivityForResult", "goal", "bundle", "Landroid/os/Bundle;", "requestCode", "", "skipActivityTransition", "view", "Landroid/view/View;", "elementName", "XUtils_release"})
public final class ActivityUtil {
    @Nullable
    private static Stack<Activity> activityStack;
    @NotNull
    public static final ActivityUtil INSTANCE;

    @Nullable
    public final Stack<Activity> getActivityStack() {
        return activityStack;
    }

    public final void setActivityStack(@Nullable Stack<Activity> stack) {
        activityStack = stack;
    }

    public final boolean isDestroy(@NotNull AppCompatActivity activity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        AppCompatActivity appCompatActivity = activity;
        boolean bl2 = false;
        boolean bl3 = false;
        AppCompatActivity $this$run = appCompatActivity;
        boolean bl4 = false;
        if (Build.VERSION.SDK_INT < 17) {
            boolean bl5 = $this$run.isFinishing() | $this$run.getSupportFragmentManager() == null;
            FragmentManager fragmentManager = $this$run.getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"supportFragmentManager");
            bl = bl5 | fragmentManager.isDestroyed();
        } else {
            bl = $this$run.isFinishing() | $this$run.isDestroyed();
        }
        return bl;
    }

    @JvmStatic
    public static final void addActivity(@Nullable Activity activity) {
        block1: {
            if (activityStack == null) {
                activityStack = new Stack();
            }
            Stack<Activity> stack = activityStack;
            if (stack == null) break block1;
            stack.add(activity);
        }
    }

    @JvmStatic
    public static final void removeActivity(@Nullable Activity activity) {
        block2: {
            if (activity == null) break block2;
            Stack<Activity> stack = activityStack;
            Intrinsics.checkNotNull(stack);
            if (stack.contains(activity)) {
                Stack<Activity> stack2 = activityStack;
                if (stack2 != null) {
                    stack2.remove(activity);
                }
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Activity currentActivity() {
        Stack<Activity> stack = activityStack;
        return stack != null ? (Activity)stack.lastElement() : null;
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity(boolean isTransition) {
        block1: {
            Activity activity;
            block0: {
                Stack<Activity> stack = activityStack;
                Object object = activity = stack != null ? (Activity)stack.lastElement() : null;
                if (!isTransition) break block0;
                Activity activity2 = activity;
                if (activity2 == null) break block1;
                activity2.onBackPressed();
                break block1;
            }
            Activity activity3 = activity;
            if (activity3 == null) break block1;
            activity3.finish();
        }
    }

    public static /* synthetic */ void finishActivity$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ActivityUtil.finishActivity(bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity() {
        ActivityUtil.finishActivity$default(false, 1, null);
    }

    @JvmStatic
    public static final void finishActivity(@NotNull Class<? extends Activity> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Stack<Activity> stack = activityStack;
        Intrinsics.checkNotNull(stack);
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            Activity activity;
            Activity activity2 = activity = (Activity)iterator.next();
            Intrinsics.checkNotNull((Object)activity2);
            if (!Intrinsics.areEqual(activity2.getClass(), cls)) continue;
            ActivityUtil.finishActivity$default((Context)activity, false, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void finishAllActivity() {
        Stack<Activity> stack = activityStack;
        Intrinsics.checkNotNull(stack);
        int size = stack.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            Stack<Activity> stack2 = activityStack;
            Intrinsics.checkNotNull(stack2);
            if (stack2.get((int)i) != null) {
                Stack<Activity> stack3 = activityStack;
                Intrinsics.checkNotNull(stack3);
                Object e = stack3.get((int)i);
                Intrinsics.checkNotNull(e);
                ((Activity)e).finish();
            }
            ++i;
        }
        Stack<Activity> stack4 = activityStack;
        Intrinsics.checkNotNull(stack4);
        stack4.clear();
    }

    @JvmStatic
    public static final void AppExit(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ActivityUtil.finishAllActivity();
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager activityManager = (ActivityManager)object;
            activityManager.restartPackage(context.getPackageName());
            int n = 0;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @JvmStatic
    public static final boolean isExistActivity(@NotNull Context context, @Nullable String packageName, @Nullable String className) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent();
        String string = packageName;
        Intrinsics.checkNotNull((Object)string);
        String string2 = className;
        Intrinsics.checkNotNull((Object)string2);
        intent.setClassName(string, string2);
        return context.getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(context.getPackageManager()) != null && context.getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityForResult(@NotNull Activity context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent((Context)context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivityForResult(intent, requestCode);
    }

    public static /* synthetic */ void skipActivityForResult$default(Activity activity, Class clazz, Bundle bundle, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bundle = null;
        }
        ActivityUtil.skipActivityForResult(activity, clazz, bundle, n);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityForResult(@NotNull Activity context, @Nullable Class<? extends Activity> goal, int requestCode) {
        ActivityUtil.skipActivityForResult$default(context, goal, null, requestCode, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityTransition(@NotNull Context mContext, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, @Nullable View view, @Nullable String elementName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intent intent = new Intent(mContext, goal);
        Activity activity = (Activity)mContext;
        View view2 = view;
        Intrinsics.checkNotNull((Object)view2);
        String string = elementName;
        Intrinsics.checkNotNull((Object)string);
        Bundle bundle1 = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (View)view2, (String)string).toBundle();
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        mContext.startActivity(intent, bundle1);
    }

    public static /* synthetic */ void skipActivityTransition$default(Context context, Class clazz, Bundle bundle, View view, String string, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        ActivityUtil.skipActivityTransition(context, clazz, bundle, view, string);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityTransition(@NotNull Context mContext, @Nullable Class<? extends Activity> goal, @Nullable View view, @Nullable String elementName) {
        ActivityUtil.skipActivityTransition$default(mContext, goal, null, view, elementName, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final String getLauncherActivity(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        PackageManager pm = context.getPackageManager();
        List list = pm.queryIntentActivities(intent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pm.queryIntentActivities(intent, 0)");
        List infos = list;
        for (ResolveInfo info : infos) {
            if (!Intrinsics.areEqual((Object)info.activityInfo.packageName, (Object)packageName)) continue;
            String string = info.activityInfo.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.activityInfo.name");
            return string;
        }
        return "no " + packageName;
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity(@NotNull Context mContext, boolean isTransition) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        ActivityUtil.removeActivity((Activity)mContext);
        if (isTransition) {
            ((Activity)mContext).onBackPressed();
        } else {
            ((Activity)mContext).finish();
        }
    }

    public static /* synthetic */ void finishActivity$default(Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ActivityUtil.finishActivity(context, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity(@NotNull Context mContext) {
        ActivityUtil.finishActivity$default(mContext, false, 2, null);
    }

    private ActivityUtil() {
    }

    static {
        ActivityUtil activityUtil;
        INSTANCE = activityUtil = new ActivityUtil();
    }
}

