/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glcanvas.TextureMatrixTransformer;
import com.chillingvan.canvasgl.glview.texture.GLTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import java.util.Arrays;

public abstract class TwoTextureFilter
extends BasicTextureFilter {
    public static final String VARYING_TEXTURE_COORD2 = "vTextureCoord2";
    public static final String UNIFORM_TEXTURE_SAMPLER2 = "uTextureSampler2";
    private static final String TEXTURE_MATRIX_UNIFORM2 = "uTextureMatrix2";
    private static final String VERTEX_SHADER = " \nattribute vec2 aPosition;\nvarying vec2 vTextureCoord;\nvarying vec2 vTextureCoord2;\nuniform mat4 uMatrix;\nuniform mat4 uTextureMatrix;\nuniform mat4 uTextureMatrix2;\n \nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n    gl_Position = uMatrix * pos;\n    vTextureCoord = (uTextureMatrix * pos).xy;\n    vTextureCoord2 = (uTextureMatrix2 * pos).xy;\n}";
    protected final float[] mTempTextureMatrix = new float[16];
    protected Bitmap secondBitmap;
    private RectF mTempSrcRectF = new RectF();
    protected GLTexture secondRawTexture;

    public TwoTextureFilter(@NonNull Bitmap secondBitmap) {
        this.secondBitmap = secondBitmap;
    }

    public TwoTextureFilter() {
    }

    public void setSecondRawTexture(GLTexture secondRawTexture) {
        this.secondRawTexture = secondRawTexture;
    }

    public void setBitmap(@NonNull Bitmap secondBitmap) {
        this.secondBitmap = secondBitmap;
    }

    @Override
    public String getVertexShader() {
        return VERTEX_SHADER;
    }

    private void resetMatrix() {
        Arrays.fill(this.mTempTextureMatrix, 0.0f);
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        if (this.useSecondBitmap()) {
            this.handleSecondBitmapTexture(program, canvas);
            return;
        }
        if (this.secondRawTexture != null) {
            this.handleSecondRawTexture(program, canvas);
        }
    }

    private void handleSecondBitmapTexture(int program, ICanvasGL canvas) {
        BitmapTexture secondTexture = canvas.bindBitmapToTexture(33987, this.secondBitmap);
        this.resetMatrix();
        Matrix.setIdentityM((float[])this.mTempTextureMatrix, (int)0);
        TextureMatrixTransformer.copyTextureCoordinates(secondTexture, this.mTempSrcRectF);
        TextureMatrixTransformer.convertCoordinate(this.mTempSrcRectF, secondTexture);
        TextureMatrixTransformer.setTextureMatrix(this.mTempSrcRectF, this.mTempTextureMatrix);
        GLES20Canvas.printMatrix("two tex matrix", this.mTempTextureMatrix, 0);
        int textureMatrixPosition = GLES20.glGetUniformLocation((int)program, (String)TEXTURE_MATRIX_UNIFORM2);
        GLES20.glUniformMatrix4fv((int)textureMatrixPosition, (int)1, (boolean)false, (float[])this.mTempTextureMatrix, (int)0);
        int sampler2 = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_TEXTURE_SAMPLER2);
        GLES20Canvas.checkError();
        GLES20.glUniform1i((int)sampler2, (int)3);
        GLES20Canvas.checkError();
    }

    private void handleSecondRawTexture(int program, ICanvasGL canvas) {
        RawTexture rawTexture = this.secondRawTexture.getRawTexture();
        canvas.bindRawTexture(33987, rawTexture);
        this.resetMatrix();
        this.secondRawTexture.getSurfaceTexture().getTransformMatrix(this.mTempTextureMatrix);
        int textureMatrixPosition = GLES20.glGetUniformLocation((int)program, (String)TEXTURE_MATRIX_UNIFORM2);
        GLES20.glUniformMatrix4fv((int)textureMatrixPosition, (int)1, (boolean)false, (float[])this.mTempTextureMatrix, (int)0);
        int sampler2 = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_TEXTURE_SAMPLER2);
        GLES20Canvas.checkError();
        GLES20.glUniform1i((int)sampler2, (int)3);
        GLES20Canvas.checkError();
    }

    @Override
    public String getOesFragmentProgram() {
        if (this.useSecondBitmap()) {
            return "#extension GL_OES_EGL_image_external : require\n" + this.getFragmentShader().replaceFirst("sampler2D", "samplerExternalOES");
        }
        return "#extension GL_OES_EGL_image_external : require\n" + this.getFragmentShader().replaceAll("sampler2D", "samplerExternalOES");
    }

    private boolean useSecondBitmap() {
        return this.secondBitmap != null;
    }
}

