/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.SurfaceTexture;
import androidx.annotation.Nullable;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.MultiTexOffScreenCanvas;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glview.texture.GLMultiTexProducerView;
import com.chillingvan.canvasgl.glview.texture.GLSurfaceTextureProducerView;
import com.chillingvan.canvasgl.glview.texture.GLTexture;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import java.util.List;

public abstract class OffScreenCanvas
extends MultiTexOffScreenCanvas {
    private BasicTexture outsideSharedTexture;
    private SurfaceTexture outsideSharedSurfaceTexture;

    public OffScreenCanvas() {
    }

    public OffScreenCanvas(int width, int height) {
        super(width, height);
    }

    public OffScreenCanvas(Object surface) {
        super(surface);
    }

    public OffScreenCanvas(int width, int height, Object surface) {
        super(width, height, surface);
    }

    public OffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext, Object surface) {
        super(width, height, sharedEglContext, surface);
    }

    public OffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext) {
        super(width, height, sharedEglContext);
    }

    public void setOnSurfaceTextureSet(final GLSurfaceTextureProducerView.OnSurfaceTextureSet onSurfaceTextureSet) {
        this.setSurfaceTextureCreatedListener(new GLMultiTexProducerView.SurfaceTextureCreatedListener(){

            @Override
            public void onCreated(List<GLTexture> glTextureList) {
                GLTexture glTexture = glTextureList.get(0);
                onSurfaceTextureSet.onSet(glTexture.getSurfaceTexture(), glTexture.getRawTexture());
            }
        });
    }

    public void setSharedTexture(RawTexture outsideTexture, @Nullable SurfaceTexture outsideSurfaceTexture) {
        this.outsideSharedTexture = outsideTexture;
        this.outsideSharedSurfaceTexture = outsideSurfaceTexture;
        if (this.consumedTextures.isEmpty()) {
            this.consumedTextures.add(new GLTexture(outsideTexture, outsideSurfaceTexture));
        }
    }

    @Override
    protected final void onGLDraw(ICanvasGL canvas, List<GLTexture> producedTextures, List<GLTexture> consumedTextures) {
        GLTexture glTexture = producedTextures.get(0);
        if (!consumedTextures.isEmpty()) {
            GLTexture consumeTexture = consumedTextures.get(0);
            this.onGLDraw(canvas, glTexture.getSurfaceTexture(), glTexture.getRawTexture(), consumeTexture.getSurfaceTexture(), consumeTexture.getRawTexture());
        } else {
            this.onGLDraw(canvas, glTexture.getSurfaceTexture(), glTexture.getRawTexture(), null, null);
        }
    }

    protected abstract void onGLDraw(ICanvasGL var1, SurfaceTexture var2, RawTexture var3, @Nullable SurfaceTexture var4, @Nullable BasicTexture var5);
}

