/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.util.AttributeSet;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glview.texture.BaseGLCanvasTextureView;
import com.chillingvan.canvasgl.glview.texture.GLTexture;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class GLMultiTexConsumerView
extends BaseGLCanvasTextureView {
    protected List<GLTexture> consumedTextures = new ArrayList<GLTexture>();
    protected EglContextWrapper mSharedEglContext;

    public GLMultiTexConsumerView(Context context) {
        super(context);
    }

    public GLMultiTexConsumerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GLMultiTexConsumerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setSharedEglContext(EglContextWrapper sharedEglContext) {
        this.mSharedEglContext = sharedEglContext;
        this.glThreadBuilder.setSharedEglContext(sharedEglContext);
        this.createGLThread();
    }

    @Override
    protected void createGLThread() {
        if (this.mSharedEglContext != null) {
            super.createGLThread();
        }
    }

    public void addConsumeGLTexture(GLTexture glTexture) {
        this.consumedTextures.add(glTexture);
    }

    protected abstract void onGLDraw(ICanvasGL var1, List<GLTexture> var2);

    @Override
    protected final void onGLDraw(ICanvasGL canvas) {
        Iterator<GLTexture> iterator = this.consumedTextures.iterator();
        while (iterator.hasNext()) {
            GLTexture next = iterator.next();
            if (!next.getRawTexture().isRecycled()) continue;
            iterator.remove();
        }
        this.onGLDraw(canvas, this.consumedTextures);
    }

    @Override
    protected void surfaceDestroyed() {
        super.surfaceDestroyed();
        this.mSharedEglContext = null;
        this.consumedTextures.clear();
    }
}

