/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.androidCanvas;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.chillingvan.canvasgl.androidCanvas.IAndroidCanvasHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class AndroidCanvasHelperAsync
implements IAndroidCanvasHelper {
    private int width;
    private int height;
    private Bitmap bitmapBoard;
    private Bitmap bitmapBoardCached;
    private Canvas canvas;
    private ExecutorService executors = Executors.newSingleThreadExecutor();
    private volatile boolean isAvailable = true;
    private Lock lock = new ReentrantLock();

    AndroidCanvasHelperAsync() {
    }

    @Override
    public void init(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.bitmapBoard = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bitmapBoardCached = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas = new Canvas(this.bitmapBoard);
        }
    }

    @Override
    public void draw(final IAndroidCanvasHelper.CanvasPainter canvasPainter) {
        if (this.canvas == null) {
            throw new IllegalStateException("DrawTextHelper has not init.");
        }
        if (!this.isAvailable) {
            return;
        }
        this.swap();
        this.executors.execute(new Runnable(){

            @Override
            public void run() {
                AndroidCanvasHelperAsync.this.lock.lock();
                AndroidCanvasHelperAsync.this.isAvailable = false;
                canvasPainter.draw(AndroidCanvasHelperAsync.this.canvas, AndroidCanvasHelperAsync.this.bitmapBoard);
                AndroidCanvasHelperAsync.this.isAvailable = true;
                AndroidCanvasHelperAsync.this.lock.unlock();
            }
        });
    }

    private void swap() {
        this.lock.lock();
        Bitmap temp = this.bitmapBoardCached;
        this.bitmapBoardCached = this.bitmapBoard;
        this.bitmapBoard = temp;
        this.canvas.setBitmap(this.bitmapBoard);
        this.lock.unlock();
    }

    @Override
    public Bitmap getOutputBitmap() {
        return this.bitmapBoardCached;
    }
}

