/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.GLES11Ext;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.util.Log;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20IdImpl;
import com.chillingvan.canvasgl.glcanvas.GLId;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.IntArray;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glcanvas.TextureMatrixTransformer;
import com.chillingvan.canvasgl.shapeFilter.DrawShapeFilter;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import com.chillingvan.canvasgl.util.Loggers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GLES20Canvas
implements GLCanvas {
    private static final String TAG = GLES20Canvas.class.getSimpleName();
    private static final int FLOAT_SIZE = 4;
    private static final float OPAQUE_ALPHA = 0.95f;
    private static final int COORDS_PER_VERTEX = 2;
    private static final int VERTEX_STRIDE = 8;
    private static final int COUNT_FILL_VERTEX = 4;
    private static final int COUNT_LINE_VERTEX = 2;
    private static final int COUNT_RECT_VERTEX = 4;
    private static final int OFFSET_FILL_RECT = 0;
    private static final int OFFSET_DRAW_LINE = 4;
    private static final int OFFSET_DRAW_RECT = 6;
    private static final float[] BOX_COORDINATES = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] BOUNDS_COORDINATES = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    public static final String POSITION_ATTRIBUTE = "aPosition";
    public static final String COLOR_UNIFORM = "uColor";
    public static final String MATRIX_UNIFORM = "uMatrix";
    public static final String TEXTURE_MATRIX_UNIFORM = "uTextureMatrix";
    public static final String TEXTURE_SAMPLER_UNIFORM = "uTextureSampler";
    public static final String ALPHA_UNIFORM = "uAlpha";
    public static final String TEXTURE_COORD_ATTRIBUTE = "aTextureCoordinate";
    public static final String MESH_VERTEX_SHADER = "uniform mat4 uMatrix;\nattribute vec2 aPosition;\nattribute vec2 aTextureCoordinate;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n  vTextureCoord = aTextureCoordinate;\n}\n";
    public static final int INITIAL_RESTORE_STATE_SIZE = 8;
    private static final int MATRIX_SIZE = 16;
    private Map<DrawShapeFilter, Integer> mDrawShapeFilterMapProgramId = new HashMap<DrawShapeFilter, Integer>();
    private Map<TextureFilter, Integer> mTextureFilterMapProgramId = new HashMap<TextureFilter, Integer>();
    private Map<TextureFilter, Integer> mOESTextureFilterMapProgramId = new HashMap<TextureFilter, Integer>();
    private float[] mMatrices = new float[128];
    private float[] mAlphas = new float[8];
    private IntArray mSaveFlags = new IntArray();
    private int mCurrentAlphaIndex = 0;
    private int mCurrentMatrixIndex = 0;
    private int mWidth;
    private int mHeight;
    private float[] mProjectionMatrix = new float[16];
    private int mScreenWidth;
    private int mScreenHeight;
    private int mDrawProgram;
    private int mTextureProgram;
    private int mOesTextureProgram;
    private int mMeshProgram;
    private int mBoxCoordinates;
    private static final int INDEX_POSITION = 0;
    private static final int INDEX_MATRIX = 1;
    private static final int INDEX_COLOR = 2;
    private static final int INDEX_TEXTURE_MATRIX = 2;
    private static final int INDEX_TEXTURE_SAMPLER = 3;
    private static final int INDEX_ALPHA = 4;
    private static final int INDEX_TEXTURE_COORD = 2;
    private TextureFilter mTextureFilter;
    private DrawShapeFilter mDrawShapeFilter;
    private GLCanvas.OnPreDrawTextureListener onPreDrawTextureListener;
    private GLCanvas.OnPreDrawShapeListener onPreDrawShapeListener;
    ShaderParameter[] mDrawParameters = new ShaderParameter[]{new AttributeShaderParameter("aPosition"), new UniformShaderParameter("uMatrix"), new UniformShaderParameter("uColor")};
    ShaderParameter[] mTextureParameters = new ShaderParameter[]{new AttributeShaderParameter("aPosition"), new UniformShaderParameter("uMatrix"), new UniformShaderParameter("uTextureMatrix"), new UniformShaderParameter("uTextureSampler"), new UniformShaderParameter("uAlpha")};
    ShaderParameter[] mOesTextureParameters = new ShaderParameter[]{new AttributeShaderParameter("aPosition"), new UniformShaderParameter("uMatrix"), new UniformShaderParameter("uTextureMatrix"), new UniformShaderParameter("uTextureSampler"), new UniformShaderParameter("uAlpha")};
    ShaderParameter[] mMeshParameters = new ShaderParameter[]{new AttributeShaderParameter("aPosition"), new UniformShaderParameter("uMatrix"), new AttributeShaderParameter("aTextureCoordinate"), new UniformShaderParameter("uTextureSampler"), new UniformShaderParameter("uAlpha")};
    private final IntArray mUnboundTextures = new IntArray();
    private final IntArray mDeleteBuffers = new IntArray();
    private int mCountDrawMesh = 0;
    private int mCountTextureRect = 0;
    private int mCountFillRect = 0;
    private int mCountDrawLine = 0;
    private int[] mFrameBuffer = new int[1];
    private ArrayList<RawTexture> mTargetTextures = new ArrayList();
    private final float[] mTempMatrix = new float[32];
    private final float[] mTempColor = new float[4];
    private final RectF mTempSourceRect = new RectF();
    private final RectF mTempTargetRect = new RectF();
    private final float[] mTempTextureMatrix = new float[16];
    private final int[] mTempIntArray = new int[1];
    private static final GLId mGLId = new GLES20IdImpl();

    public GLES20Canvas() {
        Matrix.setIdentityM((float[])this.mTempTextureMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mMatrices, (int)this.mCurrentMatrixIndex);
        this.mAlphas[this.mCurrentAlphaIndex] = 1.0f;
        this.mTargetTextures.add(null);
        FloatBuffer boxBuffer = GLES20Canvas.createBuffer(BOX_COORDINATES);
        this.mBoxCoordinates = this.uploadBuffer(boxBuffer);
        this.mDrawProgram = GLES20Canvas.assembleProgram(GLES20Canvas.loadShader(35633, "uniform mat4 uMatrix;\nattribute vec2 aPosition;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n}\n"), GLES20Canvas.loadShader(35632, "precision mediump float;\nuniform vec4 uColor;\nvoid main() {\n  gl_FragColor = uColor;\n}\n"), this.mDrawParameters, this.mTempIntArray);
        int textureFragmentShader = GLES20Canvas.loadShader(35632, "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform sampler2D uTextureSampler;\nvoid main() {\n  gl_FragColor = texture2D(uTextureSampler, vTextureCoord);\n  gl_FragColor *= uAlpha;\n}\n");
        int meshVertexShader = GLES20Canvas.loadShader(35633, MESH_VERTEX_SHADER);
        this.setupMeshProgram(meshVertexShader, textureFragmentShader);
        GLES20.glBlendFunc((int)1, (int)771);
        GLES20Canvas.checkError();
    }

    private void setupMeshProgram(int meshVertexShader, int textureFragmentShader) {
        this.mMeshProgram = GLES20Canvas.assembleProgram(meshVertexShader, textureFragmentShader, this.mMeshParameters, this.mTempIntArray);
    }

    private static FloatBuffer createBuffer(float[] values) {
        int size = values.length * 4;
        FloatBuffer buffer = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buffer.put(values, 0, values.length).position(0);
        return buffer;
    }

    private static int assembleProgram(int vertexShader, int fragmentShader, ShaderParameter[] params, int[] linkStatus) {
        int program = GLES20.glCreateProgram();
        GLES20Canvas.checkError();
        if (program == 0) {
            throw new RuntimeException("Cannot create GL program: " + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GLES20Canvas.checkError();
        GLES20.glAttachShader((int)program, (int)fragmentShader);
        GLES20Canvas.checkError();
        GLES20.glLinkProgram((int)program);
        GLES20Canvas.checkError();
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        GLES20Canvas.loadHandles(params, program);
        return program;
    }

    private static void loadHandles(ShaderParameter[] params, int program) {
        for (int i = 0; i < params.length; ++i) {
            params[i].loadHandle(program);
        }
    }

    private static int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)shaderCode);
        GLES20Canvas.checkError();
        GLES20.glCompileShader((int)shader);
        GLES20Canvas.checkError();
        return shader;
    }

    @Override
    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.checkError();
        Matrix.setIdentityM((float[])this.mMatrices, (int)this.mCurrentMatrixIndex);
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)0.0f, (float)width, (float)0.0f, (float)height, (float)-1.0f, (float)1.0f);
        if (this.getTargetTexture() == null) {
            this.mScreenWidth = width;
            this.mScreenHeight = height;
            Matrix.translateM((float[])this.mMatrices, (int)this.mCurrentMatrixIndex, (float)0.0f, (float)height, (float)0.0f);
            Matrix.scaleM((float[])this.mMatrices, (int)this.mCurrentMatrixIndex, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
    }

    @Override
    public void clearBuffer() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20Canvas.checkError();
        GLES20.glClear((int)16384);
        GLES20Canvas.checkError();
    }

    @Override
    public void clearBuffer(float[] argb) {
        GLES20.glClearColor((float)argb[1], (float)argb[2], (float)argb[3], (float)argb[0]);
        GLES20Canvas.checkError();
        GLES20.glClear((int)16384);
        GLES20Canvas.checkError();
    }

    @Override
    public float getAlpha() {
        return this.mAlphas[this.mCurrentAlphaIndex];
    }

    @Override
    public void setAlpha(float alpha) {
        this.mAlphas[this.mCurrentAlphaIndex] = alpha;
    }

    @Override
    public void multiplyAlpha(float alpha) {
        this.setAlpha(this.getAlpha() * alpha);
    }

    @Override
    public void translate(float x, float y, float z) {
        Matrix.translateM((float[])this.mMatrices, (int)this.mCurrentMatrixIndex, (float)x, (float)y, (float)z);
    }

    @Override
    public void translate(float x, float y) {
        int index = this.mCurrentMatrixIndex;
        float[] m = this.mMatrices;
        int n = index + 12;
        m[n] = m[n] + (m[index + 0] * x + m[index + 4] * y);
        int n2 = index + 13;
        m[n2] = m[n2] + (m[index + 1] * x + m[index + 5] * y);
        int n3 = index + 14;
        m[n3] = m[n3] + (m[index + 2] * x + m[index + 6] * y);
        int n4 = index + 15;
        m[n4] = m[n4] + (m[index + 3] * x + m[index + 7] * y);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        Matrix.scaleM((float[])this.mMatrices, (int)this.mCurrentMatrixIndex, (float)sx, (float)sy, (float)sz);
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        if (angle == 0.0f) {
            return;
        }
        float[] temp = this.mTempMatrix;
        Matrix.setRotateM((float[])temp, (int)0, (float)angle, (float)x, (float)y, (float)z);
        float[] matrix = this.mMatrices;
        int index = this.mCurrentMatrixIndex;
        Matrix.multiplyMM((float[])temp, (int)16, (float[])matrix, (int)index, (float[])temp, (int)0);
        System.arraycopy(temp, 16, matrix, index, 16);
    }

    @Override
    public void multiplyMatrix(float[] matrix, int offset) {
        float[] temp = this.mTempMatrix;
        float[] currentMatrix = this.mMatrices;
        int index = this.mCurrentMatrixIndex;
        Matrix.multiplyMM((float[])temp, (int)0, (float[])currentMatrix, (int)index, (float[])matrix, (int)offset);
        System.arraycopy(temp, 0, currentMatrix, index, 16);
    }

    @Override
    public void save() {
        this.save(-1);
    }

    @Override
    public void save(int saveFlags) {
        boolean saveMatrix;
        boolean saveAlpha;
        boolean bl = saveAlpha = (saveFlags & 1) == 1;
        if (saveAlpha) {
            float currentAlpha = this.getAlpha();
            ++this.mCurrentAlphaIndex;
            if (this.mAlphas.length <= this.mCurrentAlphaIndex) {
                this.mAlphas = Arrays.copyOf(this.mAlphas, this.mAlphas.length * 2);
            }
            this.mAlphas[this.mCurrentAlphaIndex] = currentAlpha;
        }
        boolean bl2 = saveMatrix = (saveFlags & 2) == 2;
        if (saveMatrix) {
            int currentIndex = this.mCurrentMatrixIndex;
            this.mCurrentMatrixIndex += 16;
            if (this.mMatrices.length <= this.mCurrentMatrixIndex) {
                this.mMatrices = Arrays.copyOf(this.mMatrices, this.mMatrices.length * 2);
            }
            System.arraycopy(this.mMatrices, currentIndex, this.mMatrices, this.mCurrentMatrixIndex, 16);
        }
        this.mSaveFlags.add(saveFlags);
    }

    @Override
    public void restore() {
        boolean restoreMatrix;
        boolean restoreAlpha;
        int restoreFlags = this.mSaveFlags.removeLast();
        boolean bl = restoreAlpha = (restoreFlags & 1) == 1;
        if (restoreAlpha) {
            --this.mCurrentAlphaIndex;
        }
        boolean bl2 = restoreMatrix = (restoreFlags & 2) == 2;
        if (restoreMatrix) {
            this.mCurrentMatrixIndex -= 16;
        }
    }

    @Override
    public void drawCircle(float x, float y, float radius, GLPaint paint, DrawShapeFilter drawShapeFilter) {
        this.setupDrawShapeFilter(drawShapeFilter);
        this.draw(5, 0, 4, x, y, 2.0f * radius, 2.0f * radius, paint.getColor(), 0.0f);
    }

    @Override
    public void drawLine(float x1, float y1, float x2, float y2, GLPaint paint, DrawShapeFilter drawShapeFilter) {
        this.setupDrawShapeFilter(drawShapeFilter);
        this.draw(3, 4, 2, x1, y1, x2 - x1, y2 - y1, paint);
        ++this.mCountDrawLine;
    }

    @Override
    public void drawRect(float x, float y, float width, float height, GLPaint paint, DrawShapeFilter drawShapeFilter) {
        this.setupDrawShapeFilter(drawShapeFilter);
        this.draw(2, 6, 4, x, y, width, height, paint);
        ++this.mCountDrawLine;
    }

    private void draw(int type, int offset, int count, float x, float y, float width, float height, GLPaint paint) {
        this.draw(type, offset, count, x, y, width, height, paint.getColor(), paint.getLineWidth());
    }

    private void draw(int type, int offset, int count, float x, float y, float width, float height, int color, float lineWidth) {
        this.prepareDraw(offset, color, lineWidth);
        if (this.onPreDrawShapeListener != null) {
            this.onPreDrawShapeListener.onPreDraw(this.mDrawProgram, this.mDrawShapeFilter);
        }
        this.draw(this.mDrawParameters, type, count, x, y, width, height, null);
    }

    private void prepareDraw(int offset, int color, float lineWidth) {
        GLES20.glUseProgram((int)this.mDrawProgram);
        GLES20Canvas.checkError();
        if (lineWidth > 0.0f) {
            GLES20.glLineWidth((float)lineWidth);
            GLES20Canvas.checkError();
        }
        float[] colorArray = this.getColor(color);
        GLES20Canvas.enableBlending(true);
        GLES20.glBlendColor((float)colorArray[0], (float)colorArray[1], (float)colorArray[2], (float)colorArray[3]);
        GLES20Canvas.checkError();
        GLES20.glUniform4fv((int)this.mDrawParameters[2].handle, (int)1, (float[])colorArray, (int)0);
        this.setPosition(this.mDrawParameters, offset);
        GLES20Canvas.checkError();
    }

    private float[] getColor(int color) {
        float alpha = (float)(color >>> 24 & 0xFF) / 255.0f * this.getAlpha();
        float red = (float)(color >>> 16 & 0xFF) / 255.0f * alpha;
        float green = (float)(color >>> 8 & 0xFF) / 255.0f * alpha;
        float blue = (float)(color & 0xFF) / 255.0f * alpha;
        this.mTempColor[0] = red;
        this.mTempColor[1] = green;
        this.mTempColor[2] = blue;
        this.mTempColor[3] = alpha;
        return this.mTempColor;
    }

    private static void enableBlending(boolean enableBlending) {
        if (enableBlending) {
            GLES20.glEnable((int)3042);
            GLES20Canvas.checkError();
        } else {
            GLES20.glDisable((int)3042);
            GLES20Canvas.checkError();
        }
    }

    private void setPosition(ShaderParameter[] params, int offset) {
        GLES20.glBindBuffer((int)34962, (int)this.mBoxCoordinates);
        GLES20Canvas.checkError();
        GLES20.glVertexAttribPointer((int)params[0].handle, (int)2, (int)5126, (boolean)false, (int)8, (int)(offset * 8));
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20Canvas.checkError();
    }

    private void draw(ShaderParameter[] params, int type, int count, float x, float y, float width, float height, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        this.setMatrix(params, x, y, width, height, customMVPMatrix);
        int positionHandle = params[0].handle;
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20Canvas.checkError();
        GLES20.glDrawArrays((int)type, (int)0, (int)count);
        GLES20Canvas.checkError();
        GLES20.glDisableVertexAttribArray((int)positionHandle);
        GLES20Canvas.checkError();
    }

    private void setMatrix(ShaderParameter[] params, float x, float y, float width, float height, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        if (customMVPMatrix != null) {
            GLES20.glUniformMatrix4fv((int)params[1].handle, (int)1, (boolean)false, (float[])customMVPMatrix.getMVPMatrix(this.mScreenWidth, this.mScreenHeight, x, y, width, height), (int)0);
            GLES20Canvas.checkError();
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.mScreenWidth, (int)this.mScreenHeight);
        Matrix.translateM((float[])this.mTempMatrix, (int)0, (float[])this.mMatrices, (int)this.mCurrentMatrixIndex, (float)x, (float)y, (float)0.0f);
        Matrix.scaleM((float[])this.mTempMatrix, (int)0, (float)width, (float)height, (float)1.0f);
        Matrix.multiplyMM((float[])this.mTempMatrix, (int)16, (float[])this.mProjectionMatrix, (int)0, (float[])this.mTempMatrix, (int)0);
        GLES20Canvas.printMatrix("translate matrix:", this.mTempMatrix, 16);
        GLES20.glUniformMatrix4fv((int)params[1].handle, (int)1, (boolean)false, (float[])this.mTempMatrix, (int)16);
        GLES20Canvas.checkError();
    }

    @Override
    public void fillRect(float x, float y, float width, float height, int color, DrawShapeFilter drawShapeFilter) {
        this.setupDrawShapeFilter(drawShapeFilter);
        this.draw(5, 0, 4, x, y, width, height, color, 0.0f);
        ++this.mCountFillRect;
    }

    @Override
    public void drawTexture(BasicTexture texture, int x, int y, int width, int height, TextureFilter textureFilter, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.setupTextureFilter(texture.getTarget(), textureFilter);
        TextureMatrixTransformer.copyTextureCoordinates(texture, this.mTempSourceRect);
        this.mTempTargetRect.set((float)x, (float)y, (float)(x + width), (float)(y + height));
        TextureMatrixTransformer.convertCoordinate(this.mTempSourceRect, texture);
        GLES20Canvas.changeTargetIfNeeded(this.mTempSourceRect, this.mTempTargetRect, texture);
        this.drawTextureRect(texture, this.mTempSourceRect, this.mTempTargetRect, customMVPMatrix);
    }

    @Override
    public void drawTexture(BasicTexture texture, RectF source, RectF target, TextureFilter textureFilter, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        if (target.width() <= 0.0f || target.height() <= 0.0f) {
            return;
        }
        this.setupTextureFilter(texture.getTarget(), textureFilter);
        this.mTempSourceRect.set(source);
        this.mTempTargetRect.set(target);
        TextureMatrixTransformer.convertCoordinate(this.mTempSourceRect, texture);
        GLES20Canvas.changeTargetIfNeeded(this.mTempSourceRect, this.mTempTargetRect, texture);
        this.drawTextureRect(texture, this.mTempSourceRect, this.mTempTargetRect, customMVPMatrix);
    }

    @Override
    public void drawTexture(BasicTexture texture, float[] textureTransform, int x, int y, int w, int h, TextureFilter textureFilter, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        if (w <= 0 || h <= 0) {
            return;
        }
        this.setupTextureFilter(texture.getTarget(), textureFilter);
        this.mTempTargetRect.set((float)x, (float)y, (float)(x + w), (float)(y + h));
        this.drawTextureRect(texture, textureTransform, this.mTempTargetRect, customMVPMatrix);
    }

    private void drawTextureRect(BasicTexture texture, RectF source, RectF target, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        TextureMatrixTransformer.setTextureMatrix(source, this.mTempTextureMatrix);
        this.drawTextureRect(texture, this.mTempTextureMatrix, target, customMVPMatrix);
    }

    private static void changeTargetIfNeeded(RectF source, RectF target, BasicTexture texture) {
        float yBound = (float)texture.getHeight() / (float)texture.getTextureHeight();
        float xBound = (float)texture.getWidth() / (float)texture.getTextureWidth();
        if (source.right > xBound) {
            target.right = target.left + target.width() * (xBound - source.left) / source.width();
        }
        if (source.bottom > yBound) {
            target.bottom = target.top + target.height() * (yBound - source.top) / source.height();
        }
    }

    private void drawTextureRect(BasicTexture texture, float[] textureMatrix, RectF target, GLCanvas.ICustomMVPMatrix customMVPMatrix) {
        ShaderParameter[] params = this.prepareTexture(texture);
        this.setPosition(params, 0);
        GLES20.glUniformMatrix4fv((int)params[2].handle, (int)1, (boolean)false, (float[])textureMatrix, (int)0);
        if (this.onPreDrawTextureListener != null) {
            this.onPreDrawTextureListener.onPreDraw(texture.getTarget() == 3553 ? this.mTextureProgram : this.mOesTextureProgram, texture, this.mTextureFilter);
        }
        GLES20Canvas.checkError();
        if (texture.isFlippedVertically()) {
            this.save(2);
            this.translate(0.0f, target.centerY());
            this.scale(1.0f, -1.0f, 1.0f);
            this.translate(0.0f, -target.centerY());
        }
        this.draw(params, 5, 4, target.left, target.top, target.width(), target.height(), customMVPMatrix);
        if (texture.isFlippedVertically()) {
            this.restore();
        }
        ++this.mCountTextureRect;
    }

    private ShaderParameter[] prepareTexture(BasicTexture texture) {
        int program;
        ShaderParameter[] params;
        if (texture.getTarget() == 3553) {
            params = this.mTextureParameters;
            program = this.mTextureProgram;
        } else {
            params = this.mOesTextureParameters;
            program = this.mOesTextureProgram;
        }
        this.prepareTexture(texture, program, params);
        return params;
    }

    private void prepareTexture(BasicTexture texture, int program, ShaderParameter[] params) {
        GLES20.glUseProgram((int)program);
        GLES20Canvas.checkError();
        GLES20Canvas.enableBlending(!texture.isOpaque() || this.getAlpha() < 0.95f);
        GLES20.glActiveTexture((int)33984);
        GLES20Canvas.checkError();
        texture.onBind(this);
        GLES20.glBindTexture((int)texture.getTarget(), (int)texture.getId());
        GLES20Canvas.checkError();
        GLES20.glUniform1i((int)params[3].handle, (int)0);
        GLES20Canvas.checkError();
        GLES20.glUniform1f((int)params[4].handle, (float)this.getAlpha());
        GLES20Canvas.checkError();
    }

    @Override
    public void drawMesh(BasicTexture texture, int x, int y, int xyBuffer, int uvBuffer, int indexBuffer, int indexCount, int mode) {
        this.prepareTexture(texture, this.mMeshProgram, this.mMeshParameters);
        GLES20.glBindBuffer((int)34963, (int)indexBuffer);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)xyBuffer);
        GLES20Canvas.checkError();
        int positionHandle = this.mMeshParameters[0].handle;
        GLES20.glVertexAttribPointer((int)positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)uvBuffer);
        GLES20Canvas.checkError();
        int texCoordHandle = this.mMeshParameters[2].handle;
        GLES20.glVertexAttribPointer((int)texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20Canvas.checkError();
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20Canvas.checkError();
        GLES20.glEnableVertexAttribArray((int)texCoordHandle);
        GLES20Canvas.checkError();
        this.setMatrix(this.mMeshParameters, x, y, 1.0f, 1.0f, null);
        GLES20.glDrawElements((int)mode, (int)indexCount, (int)5121, (int)0);
        GLES20Canvas.checkError();
        GLES20.glDisableVertexAttribArray((int)positionHandle);
        GLES20Canvas.checkError();
        GLES20.glDisableVertexAttribArray((int)texCoordHandle);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34963, (int)0);
        GLES20Canvas.checkError();
        ++this.mCountDrawMesh;
    }

    @Override
    public void drawMixed(BasicTexture texture, int toColor, float ratio, int x, int y, int w, int h, DrawShapeFilter drawShapeFilter) {
        TextureMatrixTransformer.copyTextureCoordinates(texture, this.mTempSourceRect);
        this.mTempTargetRect.set((float)x, (float)y, (float)(x + w), (float)(y + h));
        this.drawMixed(texture, toColor, ratio, this.mTempSourceRect, this.mTempTargetRect, drawShapeFilter);
    }

    @Override
    public void drawMixed(BasicTexture texture, int toColor, float ratio, RectF source, RectF target, DrawShapeFilter drawShapeFilter) {
        if (target.width() <= 0.0f || target.height() <= 0.0f) {
            return;
        }
        this.save(1);
        float currentAlpha = this.getAlpha();
        float cappedRatio = Math.min(1.0f, Math.max(0.0f, ratio));
        float textureAlpha = (1.0f - cappedRatio) * currentAlpha;
        this.setAlpha(textureAlpha);
        this.drawTexture(texture, source, target, new BasicTextureFilter(), null);
        float colorAlpha = cappedRatio * currentAlpha;
        this.setAlpha(colorAlpha);
        this.fillRect(target.left, target.top, target.width(), target.height(), toColor, drawShapeFilter);
        this.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unloadTexture(BasicTexture texture) {
        boolean unload = texture.isLoaded();
        if (unload) {
            IntArray intArray = this.mUnboundTextures;
            synchronized (intArray) {
                this.mUnboundTextures.add(texture.getId());
            }
        }
        return unload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBuffer(int bufferId) {
        IntArray intArray = this.mUnboundTextures;
        synchronized (intArray) {
            this.mDeleteBuffers.add(bufferId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecycledResources() {
        IntArray intArray = this.mUnboundTextures;
        synchronized (intArray) {
            IntArray ids = this.mUnboundTextures;
            if (this.mUnboundTextures.size() > 0) {
                mGLId.glDeleteTextures(ids.size(), ids.getInternalArray(), 0);
                ids.clear();
            }
            if ((ids = this.mDeleteBuffers).size() > 0) {
                mGLId.glDeleteBuffers(ids.size(), ids.getInternalArray(), 0);
                ids.clear();
            }
        }
    }

    @Override
    public void dumpStatisticsAndClear() {
        String line = String.format("MESH:%d, TEX_RECT:%d, FILL_RECT:%d, LINE:%d", this.mCountDrawMesh, this.mCountTextureRect, this.mCountFillRect, this.mCountDrawLine);
        this.mCountDrawMesh = 0;
        this.mCountTextureRect = 0;
        this.mCountFillRect = 0;
        this.mCountDrawLine = 0;
        Log.d((String)TAG, (String)line);
    }

    @Override
    public void endRenderTarget() {
        RawTexture oldTexture = this.mTargetTextures.remove(this.mTargetTextures.size() - 1);
        RawTexture texture = this.getTargetTexture();
        this.setRenderTarget(oldTexture, texture);
        this.restore();
    }

    @Override
    public void beginRenderTarget(RawTexture texture) {
        this.save();
        RawTexture oldTexture = this.getTargetTexture();
        this.mTargetTextures.add(texture);
        this.setRenderTarget(oldTexture, texture);
    }

    private RawTexture getTargetTexture() {
        return this.mTargetTextures.get(this.mTargetTextures.size() - 1);
    }

    private void setRenderTarget(BasicTexture oldTexture, RawTexture texture) {
        if (oldTexture == null && texture != null) {
            if (texture.getTarget() == 3553) {
                GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffer, (int)0);
                GLES20Canvas.checkError();
                GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffer[0]);
                GLES20Canvas.checkError();
            } else {
                GLES11Ext.glGenFramebuffersOES((int)1, (int[])this.mFrameBuffer, (int)0);
                GLES20Canvas.checkError();
                GLES11Ext.glBindFramebufferOES((int)36160, (int)this.mFrameBuffer[0]);
                GLES20Canvas.checkError();
            }
        } else if (oldTexture != null && texture == null) {
            if (oldTexture.getTarget() == 3553) {
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20Canvas.checkError();
                GLES20.glDeleteFramebuffers((int)1, (int[])this.mFrameBuffer, (int)0);
                GLES20Canvas.checkError();
            } else {
                GLES11Ext.glBindFramebufferOES((int)36160, (int)0);
                GLES20Canvas.checkError();
                GLES11Ext.glDeleteFramebuffersOES((int)1, (int[])this.mFrameBuffer, (int)0);
                GLES20Canvas.checkError();
            }
        }
        if (texture == null) {
            this.setSize(this.mScreenWidth, this.mScreenHeight);
        } else {
            this.setSize(texture.getWidth(), texture.getHeight());
            if (!texture.isLoaded()) {
                texture.prepare(this);
            }
            if (texture.getTarget() == 3553) {
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)texture.getTarget(), (int)texture.getId(), (int)0);
                GLES20Canvas.checkError();
                GLES20Canvas.checkFramebufferStatus();
            } else {
                GLES11Ext.glFramebufferTexture2DOES((int)36160, (int)36064, (int)texture.getTarget(), (int)texture.getId(), (int)0);
                GLES20Canvas.checkError();
                GLES20Canvas.checkFramebufferStatusOes();
            }
        }
    }

    private static void checkFramebufferStatus() {
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            String msg = "";
            switch (status) {
                case 36054: {
                    msg = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                    break;
                }
                case 36057: {
                    msg = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                    break;
                }
                case 36055: {
                    msg = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                    break;
                }
                case 36061: {
                    msg = "GL_FRAMEBUFFER_UNSUPPORTED";
                }
            }
            throw new RuntimeException(msg + ":" + Integer.toHexString(status));
        }
    }

    private static void checkFramebufferStatusOes() {
        int status = GLES11Ext.glCheckFramebufferStatusOES((int)36160);
        if (status != 36053) {
            String msg = "";
            switch (status) {
                case 36054: {
                    msg = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                    break;
                }
                case 36057: {
                    msg = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                    break;
                }
                case 36055: {
                    msg = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                    break;
                }
                case 36061: {
                    msg = "GL_FRAMEBUFFER_UNSUPPORTED";
                }
            }
            throw new RuntimeException(msg + ":" + Integer.toHexString(status));
        }
    }

    @Override
    public void setTextureParameters(BasicTexture texture) {
        int target = texture.getTarget();
        GLES20.glBindTexture((int)target, (int)texture.getId());
        GLES20Canvas.checkError();
        GLES20.glTexParameteri((int)target, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10243, (int)33071);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
    }

    @Override
    public void initializeTextureSize(BasicTexture texture, int format, int type) {
        int target = texture.getTarget();
        GLES20.glBindTexture((int)target, (int)texture.getId());
        GLES20Canvas.checkError();
        int width = texture.getTextureWidth();
        int height = texture.getTextureHeight();
        GLES20.glTexImage2D((int)target, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)type, null);
    }

    @Override
    public void initializeTexture(BasicTexture texture, Bitmap bitmap) {
        int target = texture.getTarget();
        GLES20.glBindTexture((int)target, (int)texture.getId());
        GLES20Canvas.checkError();
        GLUtils.texImage2D((int)target, (int)0, (Bitmap)bitmap, (int)0);
    }

    @Override
    public void texSubImage2D(BasicTexture texture, int xOffset, int yOffset, Bitmap bitmap, int format, int type) {
        int target = texture.getTarget();
        GLES20.glBindTexture((int)target, (int)texture.getId());
        GLES20Canvas.checkError();
        GLUtils.texSubImage2D((int)target, (int)0, (int)xOffset, (int)yOffset, (Bitmap)bitmap, (int)format, (int)type);
    }

    @Override
    public int uploadBuffer(FloatBuffer buf) {
        return this.uploadBuffer(buf, 4);
    }

    @Override
    public int uploadBuffer(ByteBuffer buf) {
        return this.uploadBuffer(buf, 1);
    }

    private int uploadBuffer(Buffer buffer, int elementSize) {
        mGLId.glGenBuffers(1, this.mTempIntArray, 0);
        GLES20Canvas.checkError();
        int bufferId = this.mTempIntArray[0];
        GLES20.glBindBuffer((int)34962, (int)bufferId);
        GLES20Canvas.checkError();
        GLES20.glBufferData((int)34962, (int)(buffer.capacity() * elementSize), (Buffer)buffer, (int)35044);
        GLES20Canvas.checkError();
        return bufferId;
    }

    public static void checkError() {
        int error = GLES20.glGetError();
        if (error != 0) {
            Throwable t = new Throwable();
            Log.e((String)TAG, (String)("GL error: " + error), (Throwable)t);
        }
    }

    public static void printMatrix(String message, float[] m, int offset) {
        if (!Loggers.DEBUG) {
            return;
        }
        StringBuilder b = new StringBuilder(message);
        b.append('\n');
        int size = 4;
        for (int i = 0; i < size; ++i) {
            String format = "%.6f";
            b.append(String.format(format, Float.valueOf(m[offset + i])));
            b.append(", ");
            b.append(String.format(format, Float.valueOf(m[offset + 4 + i])));
            b.append(", ");
            b.append(String.format(format, Float.valueOf(m[offset + 8 + i])));
            b.append(", ");
            b.append(String.format(format, Float.valueOf(m[offset + 12 + i])));
            if (i < size - 1) {
                b.append(", ");
            }
            b.append('\n');
        }
        Loggers.v(TAG, b.toString());
    }

    @Override
    public void recoverFromLightCycle() {
        GLES20.glDisable((int)2929);
        GLES20.glBlendFunc((int)1, (int)771);
        GLES20Canvas.checkError();
    }

    @Override
    public void getBounds(Rect bounds, int x, int y, int width, int height) {
        Matrix.translateM((float[])this.mTempMatrix, (int)0, (float[])this.mMatrices, (int)this.mCurrentMatrixIndex, (float)x, (float)y, (float)0.0f);
        Matrix.scaleM((float[])this.mTempMatrix, (int)0, (float)width, (float)height, (float)1.0f);
        Matrix.multiplyMV((float[])this.mTempMatrix, (int)16, (float[])this.mTempMatrix, (int)0, (float[])BOUNDS_COORDINATES, (int)0);
        Matrix.multiplyMV((float[])this.mTempMatrix, (int)20, (float[])this.mTempMatrix, (int)0, (float[])BOUNDS_COORDINATES, (int)4);
        bounds.left = Math.round(this.mTempMatrix[16]);
        bounds.right = Math.round(this.mTempMatrix[20]);
        bounds.top = Math.round(this.mTempMatrix[17]);
        bounds.bottom = Math.round(this.mTempMatrix[21]);
        bounds.sort();
    }

    @Override
    public GLId getGLId() {
        return mGLId;
    }

    private void setupDrawShapeFilter(DrawShapeFilter drawShapeFilter) {
        if (drawShapeFilter == null) {
            throw new NullPointerException("draw shape filter is null.");
        }
        this.mDrawShapeFilter = drawShapeFilter;
        if (this.mDrawShapeFilterMapProgramId.containsKey(drawShapeFilter)) {
            this.mDrawProgram = this.mDrawShapeFilterMapProgramId.get(drawShapeFilter);
            GLES20Canvas.loadHandles(this.mDrawParameters, this.mDrawProgram);
            return;
        }
        this.mDrawProgram = this.loadAndAssemble(this.mDrawParameters, drawShapeFilter.getVertexShader(), drawShapeFilter.getFragmentShader());
        this.mDrawShapeFilterMapProgramId.put(drawShapeFilter, this.mDrawProgram);
    }

    private void setupTextureFilter(int target, TextureFilter textureFilter) {
        if (textureFilter == null) {
            throw new NullPointerException("Texture filter is null.");
        }
        this.mTextureFilter = textureFilter;
        if (target == 3553) {
            if (this.mTextureFilterMapProgramId.containsKey(textureFilter)) {
                this.mTextureProgram = this.mTextureFilterMapProgramId.get(textureFilter);
                GLES20Canvas.loadHandles(this.mTextureParameters, this.mTextureProgram);
                return;
            }
            this.mTextureProgram = this.loadAndAssemble(this.mTextureParameters, textureFilter.getVertexShader(), textureFilter.getFragmentShader());
            this.mTextureFilterMapProgramId.put(textureFilter, this.mTextureProgram);
        } else {
            if (this.mOESTextureFilterMapProgramId.containsKey(textureFilter)) {
                this.mOesTextureProgram = this.mOESTextureFilterMapProgramId.get(textureFilter);
                GLES20Canvas.loadHandles(this.mOesTextureParameters, this.mOesTextureProgram);
                return;
            }
            this.mOesTextureProgram = this.loadAndAssemble(this.mOesTextureParameters, textureFilter.getVertexShader(), textureFilter.getOesFragmentProgram());
            this.mOESTextureFilterMapProgramId.put(textureFilter, this.mOesTextureProgram);
        }
    }

    private int loadAndAssemble(ShaderParameter[] shaderParameters, String vertexProgram, String fragmentProgram) {
        int vertexShaderHandle = GLES20Canvas.loadShader(35633, vertexProgram);
        int fragmentShaderHandle = GLES20Canvas.loadShader(35632, fragmentProgram);
        return GLES20Canvas.assembleProgram(vertexShaderHandle, fragmentShaderHandle, shaderParameters, this.mTempIntArray);
    }

    @Override
    public void setOnPreDrawTextureListener(GLCanvas.OnPreDrawTextureListener l) {
        this.onPreDrawTextureListener = l;
    }

    @Override
    public void setOnPreDrawShapeListener(GLCanvas.OnPreDrawShapeListener l) {
        this.onPreDrawShapeListener = l;
    }

    private static class AttributeShaderParameter
    extends ShaderParameter {
        public AttributeShaderParameter(String name) {
            super(name);
        }

        @Override
        public void loadHandle(int program) {
            this.handle = GLES20.glGetAttribLocation((int)program, (String)this.mName);
            GLES20Canvas.checkError();
        }
    }

    private static class UniformShaderParameter
    extends ShaderParameter {
        public UniformShaderParameter(String name) {
            super(name);
        }

        @Override
        public void loadHandle(int program) {
            this.handle = GLES20.glGetUniformLocation((int)program, (String)this.mName);
            GLES20Canvas.checkError();
        }
    }

    private static abstract class ShaderParameter {
        public int handle;
        protected final String mName;

        public ShaderParameter(String name) {
            this.mName = name;
        }

        public abstract void loadHandle(int var1);
    }
}

