/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.matrix.BaseBitmapMatrix;
import com.chillingvan.canvasgl.matrix.IBitmapMatrix;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;

public interface ICanvasGL {
    public BitmapTexture bindBitmapToTexture(int var1, Bitmap var2);

    public void beginRenderTarget(RawTexture var1);

    public void endRenderTarget();

    public GLCanvas getGlCanvas();

    public void drawSurfaceTexture(BasicTexture var1, @Nullable SurfaceTexture var2, int var3, int var4, int var5, int var6);

    public void drawSurfaceTexture(BasicTexture var1, @Nullable SurfaceTexture var2, int var3, int var4, int var5, int var6, TextureFilter var7);

    public void drawBitmap(Bitmap var1, @NonNull IBitmapMatrix var2);

    public void drawBitmap(Bitmap var1, IBitmapMatrix var2, @NonNull TextureFilter var3);

    public void drawBitmap(Bitmap var1, Rect var2, RectF var3);

    public void drawBitmap(Bitmap var1, int var2, int var3);

    public void drawBitmap(Bitmap var1, int var2, int var3, @NonNull TextureFilter var4);

    public void drawBitmap(Bitmap var1, Rect var2, Rect var3);

    public void drawBitmap(Bitmap var1, RectF var2, RectF var3, @NonNull TextureFilter var4);

    public void drawBitmap(Bitmap var1, int var2, int var3, int var4, int var5);

    public void drawBitmap(Bitmap var1, int var2, int var3, int var4, int var5, @NonNull TextureFilter var6);

    public void invalidateTextureContent(Bitmap var1);

    public void drawCircle(float var1, float var2, float var3, GLPaint var4);

    public void drawLine(float var1, float var2, float var3, float var4, GLPaint var5);

    public void drawRect(@NonNull RectF var1, @NonNull GLPaint var2);

    public void drawRect(@NonNull Rect var1, @NonNull GLPaint var2);

    public void drawRect(float var1, float var2, float var3, float var4, GLPaint var5);

    public void save();

    public void save(int var1);

    public void restore();

    public void rotate(float var1);

    public void rotate(float var1, float var2, float var3);

    public void scale(float var1, float var2);

    public void scale(float var1, float var2, float var3, float var4);

    public void translate(float var1, float var2);

    public void clearBuffer();

    public void clearBuffer(int var1);

    public void setSize(int var1, int var2);

    public int getWidth();

    public int getHeight();

    public void resume();

    public void pause();

    public void setAlpha(@IntRange(from=0L, to=255L) int var1);

    public static class OrthoBitmapMatrix
    extends BaseBitmapMatrix {
        public OrthoBitmapMatrix() {
            this.reset();
        }

        public void translate(float dx, float dy) {
            this.transform[0] = this.transform[0] + dx;
            this.transform[1] = this.transform[1] + dy;
        }

        public void scale(float sx, float sy) {
            this.transform[2] = this.transform[2] * sx;
            this.transform[3] = this.transform[3] * sy;
        }

        public void rotateZ(float degrees) {
            this.transform[6] = this.transform[6] + degrees;
        }

        @Override
        public float[] obtainResultMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
            float ratio = (float)viewportW / (float)viewportH;
            this.transform[0] = this.transform[0] + x;
            this.transform[1] = this.transform[1] + y;
            GLES20.glViewport((int)0, (int)0, (int)viewportW, (int)viewportH);
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)0.0f, (float)ratio, (float)0.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mViewMatrix, (int)0);
            Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model init:", this.mModelMatrix, 0);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[6], (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model rotated:", this.mModelMatrix, 0);
            float transX = this.transform[0] / (float)viewportW;
            float transY = this.transform[1] / (float)viewportH - 1.0f;
            Matrix.translateM((float[])this.tempMultiplyMatrix4, (int)0, (float[])this.mModelMatrix, (int)0, (float)transX, (float)transY, (float)0.0f);
            GLES20Canvas.printMatrix("model translated:", this.tempMultiplyMatrix4, 0);
            Matrix.scaleM((float[])this.tempMultiplyMatrix4, (int)0, (float)(this.transform[2] * drawW / (float)viewportW * ratio), (float)(this.transform[3] * drawH / (float)viewportH), (float)1.0f);
            GLES20Canvas.printMatrix("model scaled:", this.tempMultiplyMatrix4, 0);
            Matrix.multiplyMM((float[])this.mvp, (int)0, (float[])this.viewProjectionMatrix, (int)0, (float[])this.tempMultiplyMatrix4, (int)0);
            GLES20Canvas.printMatrix("ultra matrix:", this.mvp, 0);
            return this.mvp;
        }
    }

    public static class BitmapMatrix
    extends BaseBitmapMatrix {
        public BitmapMatrix() {
            this.reset();
        }

        public void translate(float dx, float dy) {
            this.transform[0] = this.transform[0] + dx;
            this.transform[1] = this.transform[1] + dy;
        }

        public void scale(float sx, float sy) {
            this.transform[2] = this.transform[2] * sx;
            this.transform[3] = this.transform[3] * sy;
        }

        public void rotateX(float degrees) {
            this.transform[4] = this.transform[4] + degrees;
        }

        public void rotateY(float degrees) {
            this.transform[5] = this.transform[5] + degrees;
        }

        public void rotateZ(float degrees) {
            this.transform[6] = this.transform[6] + degrees;
        }

        @Override
        public float[] obtainResultMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
            float ratio = (float)viewportW / (float)viewportH;
            this.transform[0] = this.transform[0] + x;
            this.transform[1] = this.transform[1] + y;
            int viewPortRatio = 2;
            float absTransX = Math.abs(this.transform[0]);
            float absTransY = Math.abs(this.transform[1]);
            int viewportX = (int)(drawW / 2.0f - (float)viewPortRatio / 2.0f * (float)viewportW + this.transform[0] - absTransX);
            int viewportY = (int)(-(drawH / 2.0f + this.transform[1] + absTransY + ((float)viewPortRatio - 2.0f) / 2.0f * (float)viewportH));
            int realViewportW = (int)((float)(viewPortRatio * viewportW) + 2.0f * absTransX);
            int realViewportH = (int)((float)(viewPortRatio * viewportH) + 2.0f * absTransY);
            GLES20.glViewport((int)viewportX, (int)viewportY, (int)realViewportW, (int)realViewportH);
            float realViewPortRatio = (float)realViewportW / (float)realViewportH;
            Matrix.frustumM((float[])this.mProjectionMatrix, (int)0, (float)(-ratio), (float)ratio, (float)-1.0f, (float)1.0f, (float)1.0f, (float)10.0f);
            Matrix.setLookAtM((float[])this.mViewMatrix, (int)0, (float)0.0f, (float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mViewMatrix, (int)0);
            Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model init:", this.mModelMatrix, 0);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[4], (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[5], (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[6], (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model rotated:", this.mModelMatrix, 0);
            float realW = ratio * drawW / (float)viewportW * 5.5f * 2.0f / 2.0f / (realViewPortRatio / ratio);
            float realH = drawH / (float)viewportH * 5.5f * 2.0f / 2.0f;
            Matrix.translateM((float[])this.tempMultiplyMatrix4, (int)0, (float[])this.mModelMatrix, (int)0, (float)(-realW / 2.0f), (float)(-realH / 2.0f), (float)-0.5f);
            GLES20Canvas.printMatrix("model translated:", this.tempMultiplyMatrix4, 0);
            Matrix.scaleM((float[])this.tempMultiplyMatrix4, (int)0, (float)(this.transform[2] * realW), (float)(this.transform[3] * realH), (float)1.0f);
            GLES20Canvas.printMatrix("model scaled:", this.tempMultiplyMatrix4, 0);
            Matrix.multiplyMM((float[])this.mvp, (int)0, (float[])this.viewProjectionMatrix, (int)0, (float[])this.tempMultiplyMatrix4, (int)0);
            GLES20Canvas.printMatrix("ultra matrix:", this.mvp, 0);
            return this.mvp;
        }
    }
}

