/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.AttributeSet;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public abstract class GLView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    protected CanvasGL mCanvas;
    private OnSizeChangeCallback onSizeChangeCallback;
    protected GL10 gl;

    public GLView(Context context) {
        super(context);
        this.init();
    }

    public GLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void init() {
        this.setZOrderOnTop(true);
        this.setEGLContextClientVersion(2);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        } else {
            this.setEGLConfigChooser(5, 6, 5, 8, 0, 0);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.setPreserveEGLContextOnPause(true);
        }
        this.getHolder().setFormat(-3);
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mCanvas = new CanvasGL();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mCanvas.setSize(width, height);
    }

    public void onDrawFrame(GL10 gl) {
        this.gl = gl;
        this.mCanvas.clearBuffer();
        this.onGLDraw(this.mCanvas);
    }

    protected abstract void onGLDraw(ICanvasGL var1);

    public void restart() {
        this.onResume();
    }

    public void stop() {
        this.onPause();
    }

    public void destroy() {
    }

    public void setOnSizeChangeCallback(OnSizeChangeCallback onSizeChangeCallback) {
        this.onSizeChangeCallback = onSizeChangeCallback;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.onSizeChangeCallback != null) {
            this.onSizeChangeCallback.onSizeChange(w, h, oldw, oldh);
        }
    }

    public void getDrawingBitmap(final Rect rect, final GetDrawingCacheCallback getDrawingCacheCallback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GLView.this.gl == null) {
                    return;
                }
                GLView.this.onDrawFrame(GLView.this.gl);
                GLView.this.onDrawFrame(GLView.this.gl);
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right, rect.bottom, GLView.this.getHeight());
                GLView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.requestRender();
    }

    public static interface GetDrawingCacheCallback {
        public void onFetch(Bitmap var1);
    }

    public static interface OnSizeChangeCallback {
        public void onSizeChange(int var1, int var2, int var3, int var4);
    }
}

