/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.os.Build;
import android.os.Handler;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.GLMultiTexProducerView;
import com.chillingvan.canvasgl.glview.texture.GLTexture;
import com.chillingvan.canvasgl.glview.texture.GLViewRenderer;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import com.chillingvan.canvasgl.util.Loggers;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLSurface;

public abstract class MultiTexOffScreenCanvas
implements GLViewRenderer {
    private List<GLTexture> producedTextureList = new ArrayList<GLTexture>();
    protected List<GLTexture> consumedTextures = new ArrayList<GLTexture>();
    protected final GLThread mGLThread;
    protected int width;
    protected int height;
    protected ICanvasGL mCanvas;
    private GLMultiTexProducerView.SurfaceTextureCreatedListener surfaceTextureCreatedListener;
    private Handler handler;
    private boolean isStart;
    private int producedTextureTarget = 3553;
    private int backgroundColor = 0;

    public MultiTexOffScreenCanvas() {
        this(0, 0, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER);
    }

    public MultiTexOffScreenCanvas(int width, int height) {
        this(width, height, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER);
    }

    public MultiTexOffScreenCanvas(Object surface) {
        this(0, 0, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER, surface);
    }

    public MultiTexOffScreenCanvas(int width, int height, Object surface) {
        this(width, height, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER, surface);
    }

    public MultiTexOffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext, Object surface) {
        this.width = width;
        this.height = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setSharedEglContext(sharedEglContext).setSurface(surface).setRenderer(this).createGLThread();
        this.handler = new Handler();
    }

    public MultiTexOffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext) {
        this.width = width;
        this.height = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setSharedEglContext(sharedEglContext).setEglWindowSurfaceFactory(new SurfaceFactory()).setRenderer(this).createGLThread();
        this.handler = new Handler();
    }

    public void addConsumeGLTexture(GLTexture glTexture) {
        this.consumedTextures.add(glTexture);
    }

    public GLTexture addProducedGLTexture(int width, int height, boolean opaque, int target) {
        GLTexture glTexture = GLTexture.createRaw(width, height, opaque, target, this.mCanvas);
        this.producedTextureList.add(glTexture);
        return glTexture;
    }

    public void setProducedTextureTarget(int producedTextureTarget) {
        this.producedTextureTarget = producedTextureTarget;
    }

    public void setOnCreateGLContextListener(GLThread.OnCreateGLContextListener onCreateGLContextListener) {
        this.mGLThread.setOnCreateGLContextListener(onCreateGLContextListener);
    }

    public void setSurfaceTextureCreatedListener(GLMultiTexProducerView.SurfaceTextureCreatedListener surfaceTextureCreatedListener) {
        this.surfaceTextureCreatedListener = surfaceTextureCreatedListener;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.isStart) {
            this.mGLThread.onWindowResize(width, height);
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void start() {
        this.mGLThread.start();
        this.mGLThread.surfaceCreated();
        this.mGLThread.onWindowResize(this.width, this.height);
        this.isStart = true;
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
        this.recycleProduceTexture();
    }

    public void end() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        this.recycleProduceTexture();
    }

    private void recycleProduceTexture() {
        for (GLTexture glTexture : this.producedTextureList) {
            if (!glTexture.getRawTexture().isRecycled()) {
                glTexture.getRawTexture().recycle();
            }
            if (Build.VERSION.SDK_INT >= 26) {
                if (glTexture.getSurfaceTexture().isReleased()) continue;
                glTexture.getSurfaceTexture().release();
                continue;
            }
            glTexture.getSurfaceTexture().release();
        }
        this.producedTextureList.clear();
    }

    protected void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }

    protected int getInitialTexCount() {
        return 1;
    }

    @Override
    public void onSurfaceCreated() {
        Loggers.d("OffScreenCanvas", "onSurfaceCreated: ");
        this.mCanvas = new CanvasGL();
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        Loggers.d("OffScreenCanvas", "onSurfaceChanged: ");
        this.mCanvas.setSize(width, height);
        if (this.producedTextureList.isEmpty()) {
            for (int i = 0; i < this.getInitialTexCount(); ++i) {
                this.producedTextureList.add(GLTexture.createRaw(width, height, false, this.producedTextureTarget, this.mCanvas));
            }
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (MultiTexOffScreenCanvas.this.surfaceTextureCreatedListener != null) {
                        MultiTexOffScreenCanvas.this.surfaceTextureCreatedListener.onCreated(MultiTexOffScreenCanvas.this.producedTextureList);
                    }
                }
            });
        } else {
            for (GLTexture glTexture : this.producedTextureList) {
                glTexture.getRawTexture().setSize(width, height);
            }
        }
    }

    @Override
    public void onDrawFrame() {
        this.mCanvas.clearBuffer(this.backgroundColor);
        if (this.producedTextureTarget != 3553) {
            for (GLTexture glTexture : this.producedTextureList) {
                glTexture.getSurfaceTexture().updateTexImage();
            }
        }
        this.onGLDraw(this.mCanvas, this.producedTextureList, this.consumedTextures);
    }

    protected int getRenderMode() {
        return 0;
    }

    protected abstract void onGLDraw(ICanvasGL var1, List<GLTexture> var2, List<GLTexture> var3);

    public void queueEvent(Runnable r) {
        if (this.mGLThread == null) {
            return;
        }
        this.mGLThread.queueEvent(r);
    }

    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        final Handler handler = new Handler();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                MultiTexOffScreenCanvas.this.onDrawFrame();
                MultiTexOffScreenCanvas.this.onDrawFrame();
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, MultiTexOffScreenCanvas.this.height);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.requestRender();
    }

    private class SurfaceFactory
    implements GLThread.EGLWindowSurfaceFactory {
        private SurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig config, Object nativeWindow) {
            int[] attribList = new int[]{12375, MultiTexOffScreenCanvas.this.width, 12374, MultiTexOffScreenCanvas.this.height, 12344};
            return egl.eglCreatePbufferSurface(display, config, attribList);
        }

        @Override
        public void destroySurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }

        @Override
        @TargetApi(value=17)
        public android.opengl.EGLSurface createWindowSurface(EGLDisplay display, android.opengl.EGLConfig config, Object nativeWindow) {
            int[] attribList = new int[]{12375, MultiTexOffScreenCanvas.this.width, 12374, MultiTexOffScreenCanvas.this.height, 12344};
            return EGL14.eglCreatePbufferSurface((EGLDisplay)display, (android.opengl.EGLConfig)config, (int[])attribList, (int)0);
        }

        @Override
        @TargetApi(value=17)
        public void destroySurface(EGLDisplay display, android.opengl.EGLSurface surface) {
            EGL14.eglDestroySurface((EGLDisplay)display, (android.opengl.EGLSurface)surface);
        }
    }
}

