/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterGroup
extends BasicTextureFilter {
    protected List<TextureFilter> mFilters;
    protected List<TextureFilter> mMergedFilters;
    private final List<RawTexture> rawTextureList = new ArrayList<RawTexture>();
    private BasicTexture outputTexture;
    private BasicTexture initialTexture;

    public FilterGroup(List<TextureFilter> mFilters) {
        this.mFilters = mFilters;
        this.updateMergedFilters();
    }

    private void createTextures(BasicTexture initialTexture) {
        this.recycleTextures();
        this.rawTextureList.clear();
        for (int i = 0; i < this.mMergedFilters.size(); ++i) {
            this.rawTextureList.add(new RawTexture(initialTexture.getWidth(), initialTexture.getHeight(), false));
        }
    }

    private void recycleTextures() {
        for (RawTexture rawTexture : this.rawTextureList) {
            rawTexture.recycle();
        }
    }

    public BasicTexture draw(BasicTexture initialTexture, GLCanvas glCanvas) {
        if (this.initialTexture == initialTexture && this.outputTexture != null) {
            return this.outputTexture;
        }
        this.initialTexture = initialTexture;
        this.createTextures(initialTexture);
        BasicTexture drawTexture = initialTexture;
        int size = this.rawTextureList.size();
        for (int i = 0; i < size; ++i) {
            RawTexture rawTexture = this.rawTextureList.get(i);
            TextureFilter textureFilter = this.mMergedFilters.get(i);
            glCanvas.beginRenderTarget(rawTexture);
            glCanvas.drawTexture(drawTexture, 0, 0, drawTexture.getWidth(), drawTexture.getHeight(), textureFilter, null);
            glCanvas.endRenderTarget();
            drawTexture = rawTexture;
        }
        this.outputTexture = drawTexture;
        return drawTexture;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.recycleTextures();
    }

    public List<TextureFilter> getMergedFilters() {
        return this.mMergedFilters;
    }

    public void updateMergedFilters() {
        if (this.mFilters == null) {
            return;
        }
        if (this.mMergedFilters == null) {
            this.mMergedFilters = new ArrayList<TextureFilter>();
        } else {
            this.mMergedFilters.clear();
        }
        for (TextureFilter filter : this.mFilters) {
            if (filter instanceof FilterGroup) {
                ((FilterGroup)filter).updateMergedFilters();
                List<TextureFilter> filters = ((FilterGroup)filter).getMergedFilters();
                if (filters == null || filters.isEmpty()) continue;
                this.mMergedFilters.addAll(filters);
                continue;
            }
            this.mMergedFilters.add(filter);
        }
    }
}

