/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.graphics.Bitmap;
import android.opengl.GLUtils;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import java.util.HashMap;
import junit.framework.Assert;

public abstract class UploadedTexture
extends BasicTexture {
    private static HashMap<BorderKey, Bitmap> sBorderLines = new HashMap();
    private static BorderKey sBorderKey = new BorderKey();
    private static final String TAG = "Texture";
    private boolean mContentValid = true;
    private boolean mIsUploading = false;
    private boolean mOpaque = false;
    private boolean mThrottled = false;
    private static int sUploadedCount;
    private static final int UPLOAD_LIMIT = 100;
    protected Bitmap mBitmap;
    private int mBorder;

    protected UploadedTexture() {
        this(false);
    }

    protected UploadedTexture(boolean hasBorder) {
        super(null, 0, 0);
        if (hasBorder) {
            this.setBorder(true);
            this.mBorder = 1;
        }
    }

    protected void setIsUploading(boolean uploading) {
        this.mIsUploading = uploading;
    }

    public boolean isUploading() {
        return this.mIsUploading;
    }

    protected void setThrottled(boolean throttled) {
        this.mThrottled = throttled;
    }

    private static Bitmap getBorderLine(boolean vertical, Bitmap.Config config, int length) {
        BorderKey key = sBorderKey;
        key.vertical = vertical;
        key.config = config;
        key.length = length;
        Bitmap bitmap = sBorderLines.get(key);
        if (bitmap == null) {
            bitmap = vertical ? Bitmap.createBitmap((int)1, (int)length, (Bitmap.Config)config) : Bitmap.createBitmap((int)length, (int)1, (Bitmap.Config)config);
            sBorderLines.put(key.clone(), bitmap);
        }
        return bitmap;
    }

    private Bitmap getBitmap() {
        if (this.mBitmap == null) {
            this.mBitmap = this.onGetBitmap();
            int w = this.mBitmap.getWidth() + this.mBorder * 2;
            int h = this.mBitmap.getHeight() + this.mBorder * 2;
            if (this.mWidth == -1) {
                this.setSize(w, h);
            }
        }
        return this.mBitmap;
    }

    private void freeBitmap() {
        Assert.assertTrue((this.mBitmap != null ? 1 : 0) != 0);
        this.onFreeBitmap(this.mBitmap);
        this.mBitmap = null;
    }

    @Override
    public int getWidth() {
        if (this.mWidth == -1) {
            this.getBitmap();
        }
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        if (this.mWidth == -1) {
            this.getBitmap();
        }
        return this.mHeight;
    }

    protected abstract Bitmap onGetBitmap();

    protected abstract void onFreeBitmap(Bitmap var1);

    public void invalidateContent() {
        if (this.mBitmap != null) {
            this.freeBitmap();
        }
        this.mContentValid = false;
        this.mWidth = -1;
        this.mHeight = -1;
    }

    public boolean isContentValid() {
        return this.isLoaded() && this.mContentValid;
    }

    public void updateContent(GLCanvas canvas) {
        if (!this.isLoaded()) {
            if (this.mThrottled && ++sUploadedCount > 100) {
                return;
            }
            this.uploadToCanvas(canvas);
        } else if (!this.mContentValid) {
            Bitmap bitmap = this.getBitmap();
            int format = GLUtils.getInternalFormat((Bitmap)bitmap);
            int type = GLUtils.getType((Bitmap)bitmap);
            canvas.texSubImage2D(this, this.mBorder, this.mBorder, bitmap, format, type);
            this.freeBitmap();
            this.mContentValid = true;
        }
    }

    public static void resetUploadLimit() {
        sUploadedCount = 0;
    }

    public static boolean uploadLimitReached() {
        return sUploadedCount > 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadToCanvas(GLCanvas canvas) {
        block8: {
            Bitmap bitmap = this.getBitmap();
            if (bitmap == null) {
                this.mState = -1;
                throw new RuntimeException("Texture load fail, no bitmap");
            }
            try {
                Bitmap line;
                int bWidth = bitmap.getWidth();
                int bHeight = bitmap.getHeight();
                int width = bWidth + this.mBorder * 2;
                int height = bHeight + this.mBorder * 2;
                int texWidth = this.getTextureWidth();
                int texHeight = this.getTextureHeight();
                Assert.assertTrue((bWidth <= texWidth && bHeight <= texHeight ? 1 : 0) != 0);
                this.mId = canvas.getGLId().generateTexture();
                canvas.setTextureParameters(this);
                if (bWidth == texWidth && bHeight == texHeight) {
                    canvas.initializeTexture(this, bitmap);
                    break block8;
                }
                int format = GLUtils.getInternalFormat((Bitmap)bitmap);
                int type = GLUtils.getType((Bitmap)bitmap);
                Bitmap.Config config = bitmap.getConfig();
                canvas.initializeTextureSize(this, format, type);
                canvas.texSubImage2D(this, this.mBorder, this.mBorder, bitmap, format, type);
                if (this.mBorder > 0) {
                    line = UploadedTexture.getBorderLine(true, config, texHeight);
                    canvas.texSubImage2D(this, 0, 0, line, format, type);
                    line = UploadedTexture.getBorderLine(false, config, texWidth);
                    canvas.texSubImage2D(this, 0, 0, line, format, type);
                }
                if (this.mBorder + bWidth < texWidth) {
                    line = UploadedTexture.getBorderLine(true, config, texHeight);
                    canvas.texSubImage2D(this, this.mBorder + bWidth, 0, line, format, type);
                }
                if (this.mBorder + bHeight < texHeight) {
                    line = UploadedTexture.getBorderLine(false, config, texWidth);
                    canvas.texSubImage2D(this, 0, this.mBorder + bHeight, line, format, type);
                }
            }
            finally {
                this.freeBitmap();
            }
        }
        this.setAssociatedCanvas(canvas);
        this.mState = 1;
        this.mContentValid = true;
    }

    @Override
    public boolean onBind(GLCanvas canvas) {
        this.updateContent(canvas);
        return this.isContentValid();
    }

    @Override
    public int getTarget() {
        return 3553;
    }

    public void setOpaque(boolean isOpaque) {
        this.mOpaque = isOpaque;
    }

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.mBitmap != null) {
            this.freeBitmap();
        }
    }

    private static class BorderKey
    implements Cloneable {
        public boolean vertical;
        public Bitmap.Config config;
        public int length;

        private BorderKey() {
        }

        public int hashCode() {
            int x = this.config.hashCode() ^ this.length;
            return this.vertical ? x : -x;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BorderKey)) {
                return false;
            }
            BorderKey o = (BorderKey)object;
            return this.vertical == o.vertical && this.config == o.config && this.length == o.length;
        }

        public BorderKey clone() {
            try {
                return (BorderKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

