/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public abstract class TextureSampling3mul3Filter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_TEXEL_WIDTH = "texelWidth";
    public static final String UNIFORM_TEXEL_HEIGHT = "texelHeight";
    public static final String VARYING_LEFT_TEXTURE_COORDINATE = "leftTextureCoordinate";
    public static final String VARYING_RIGHT_TEXTURE_COORDINATE = "rightTextureCoordinate";
    public static final String VARYING_TOP_TEXTURE_COORDINATE = "topTextureCoordinate";
    public static final String VARYING_TOP_LEFT_TEXTURE_COORDINATE = "topLeftTextureCoordinate";
    public static final String VARYING_TOP_RIGHT_TEXTURE_COORDINATE = "topRightTextureCoordinate";
    public static final String VARYING_BOTTOM_TEXTURE_COORDINATE = "bottomTextureCoordinate";
    public static final String VARYING_BOTTOM_LEFT_TEXTURE_COORDINATE = "bottomLeftTextureCoordinate";
    public static final String VARYING_BOTTOM_RIGHT_TEXTURE_COORDINATE = "bottomRightTextureCoordinate";
    public static final String THREE_X_THREE_TEXTURE_SAMPLING_VERTEX_SHADER = "attribute vec2 aPosition;\n\n\nuniform highp float texelWidth; \nuniform highp float texelHeight; \n\nvarying vec2 vTextureCoord;\nvarying vec2 leftTextureCoordinate;\nvarying vec2 rightTextureCoordinate;\n\nvarying vec2 topTextureCoordinate;\nvarying vec2 topLeftTextureCoordinate;\nvarying vec2 topRightTextureCoordinate;\n\nvarying vec2 bottomTextureCoordinate;\nvarying vec2 bottomLeftTextureCoordinate;\nvarying vec2 bottomRightTextureCoordinate;\n\nuniform mat4 uMatrix;\nuniform mat4 uTextureMatrix;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n    gl_Position = uMatrix * pos;\n\n    vec2 widthStep = vec2(texelWidth, 0.0);\n    vec2 heightStep = vec2(0.0, texelHeight);\n    vec2 widthHeightStep = vec2(texelWidth, texelHeight);\n    vec2 widthNegativeHeightStep = vec2(texelWidth, -texelHeight);\n\n    vTextureCoord = (uTextureMatrix * pos).xy;\n    leftTextureCoordinate = vTextureCoord.xy - widthStep;\n    rightTextureCoordinate = vTextureCoord.xy + widthStep;\n\n    topTextureCoordinate = vTextureCoord.xy - heightStep;\n    topLeftTextureCoordinate = vTextureCoord.xy - widthHeightStep;\n    topRightTextureCoordinate = vTextureCoord.xy + widthNegativeHeightStep;\n\n    bottomTextureCoordinate = vTextureCoord.xy + heightStep;\n    bottomLeftTextureCoordinate = vTextureCoord.xy - widthNegativeHeightStep;\n    bottomRightTextureCoordinate = vTextureCoord.xy + widthHeightStep;\n}";
    private int a;
    private int b;
    private boolean c = false;
    private boolean d = false;
    private float e;
    private float f;
    private float g = 1.0f;

    public TextureSampling3mul3Filter(@FloatRange(from=0.0, to=5.0) float lineSize) {
        this.g = lineSize;
    }

    @Override
    public String getVertexShader() {
        return THREE_X_THREE_TEXTURE_SAMPLING_VERTEX_SHADER;
    }

    public void setTexelWidth(float texelWidth) {
        this.c = true;
        this.e = texelWidth;
        this.setLineSize(this.g);
    }

    public void setTexelHeight(float texelHeight) {
        this.d = true;
        this.f = texelHeight;
        this.setLineSize(this.g);
    }

    public void setLineSize(@FloatRange(from=0.0, to=5.0) float size) {
        this.g = size;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        this.e = !this.c ? this.g / (float)texture.getWidth() : this.e;
        this.f = !this.d ? this.g / (float)texture.getHeight() : this.f;
        this.a = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_TEXEL_WIDTH);
        this.b = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_TEXEL_HEIGHT);
        if (this.e != 0.0f) {
            OpenGLUtil.setFloat(this.a, this.e);
            OpenGLUtil.setFloat(this.b, this.f);
        }
    }

    @Override
    public void setValue(@FloatRange(from=0.0, to=5.0) float lineSize) {
        this.setLineSize(lineSize);
    }
}

