/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public class SaturationFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_SATURATION = "saturation";
    public static final String SATURATION_FRAGMENT_SHADER = "precision mediump float;\n varying vec2 vTextureCoord;\n \n uniform sampler2D uTextureSampler;\n uniform float uAlpha;\n uniform float saturation;\n \n // Values from \"Graphics Shaders: Theory and Practice\" by Bailey and Cunningham\n const vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n \n void main() {\n     vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n    float luminance = dot(textureColor.rgb, luminanceWeighting);\n    vec3 greyScaleColor = vec3(luminance);\n    \n    gl_FragColor = vec4(mix(greyScaleColor, textureColor.rgb, saturation), textureColor.w);\n    gl_FragColor *= uAlpha;\n }";
    private float a;
    private int b;

    public SaturationFilter(@FloatRange(from=0.0, to=2.0) float mSaturation) {
        this.a = mSaturation;
    }

    @Override
    public String getFragmentShader() {
        return SATURATION_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        this.b = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_SATURATION);
        OpenGLUtil.setFloat(this.b, this.a);
    }

    @Override
    public void setValue(@FloatRange(from=0.0, to=2.0) float saturation) {
        this.a = saturation;
    }
}

