/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.opengl.GLES11;
import android.opengl.GLES20;
import android.opengl.GLException;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class OpenGLUtil {
    public static void setFloat(int location, float floatValue) {
        GLES20.glUniform1f((int)location, (float)floatValue);
    }

    public static Bitmap createBitmapFromGLSurface(int x, int y, int w, int h, int glHeight) throws OutOfMemoryError {
        int[] bitmapBuffer = new int[w * h];
        int[] bitmapSource = new int[w * h];
        IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
        intBuffer.position(0);
        try {
            GLES11.glReadPixels((int)x, (int)(glHeight - h - y), (int)w, (int)h, (int)6408, (int)5121, (Buffer)intBuffer);
            for (int i = 0; i < h; ++i) {
                int offset1 = i * w;
                int offset2 = (h - i - 1) * w;
                for (int j = 0; j < w; ++j) {
                    int pixel;
                    int texturePixel = bitmapBuffer[offset1 + j];
                    int blue = texturePixel >> 16 & 0xFF;
                    int red = texturePixel << 16 & 0xFF0000;
                    bitmapSource[offset2 + j] = pixel = texturePixel & 0xFF00FF00 | red | blue;
                }
            }
        }
        catch (GLException e) {
            return null;
        }
        return Bitmap.createBitmap((int[])bitmapSource, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

