/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture.gles;

import android.opengl.GLSurfaceView;
import android.support.annotation.NonNull;
import android.util.Log;
import com.chillingvan.canvasgl.glview.texture.gles.EglHelper;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLThread
extends Thread {
    public static final boolean LOG_PAUSE_RESUME = false;
    public static final boolean LOG_SURFACE = false;
    public static final boolean LOG_RENDERER = false;
    public static final boolean LOG_RENDERER_DRAW_FRAME = false;
    public static final boolean LOG_EGL = false;
    public static final boolean LOG_THREADS = false;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    private final GLThreadManager sGLThreadManager = new GLThreadManager();
    private int mRenderMode;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;
    private GLSurfaceView.Renderer mRenderer;
    private Object mSurface;
    private OnCreateGLContextListener onCreateGLContextListener;
    private boolean mPreserveEGLContextOnPause = true;
    private boolean mShouldExit;
    private boolean mExited;
    private boolean mRequestPaused;
    private boolean mPaused;
    private boolean mHasSurface;
    private boolean mSurfaceIsBad;
    private boolean mWaitingForSurface;
    private boolean mHaveEglContext;
    private boolean mHaveEglSurface;
    private boolean mFinishedCreatingEglSurface;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean mRequestRender = true;
    private boolean mWantRenderNotification;
    private boolean mRenderComplete;
    private ArrayList<Runnable> mEventQueue = new ArrayList();
    private boolean mSizeChanged = true;
    private boolean changeSurface = false;
    private EGLContext mEglContext = EGL10.EGL_NO_CONTEXT;
    private long mLastRunTime;
    private EglHelper mEglHelper;

    GLThread(EGLConfigChooser configChooser, EGLContextFactory eglContextFactory, EGLWindowSurfaceFactory eglWindowSurfaceFactory, GLSurfaceView.Renderer renderer, GLWrapper glWrapper, int debugFlags, int renderMode, Object surface, EGLContext sharedEglContext) {
        this.mRenderMode = renderMode;
        this.mWantRenderNotification = false;
        this.mEGLConfigChooser = configChooser;
        this.mEGLContextFactory = eglContextFactory;
        this.mEGLWindowSurfaceFactory = eglWindowSurfaceFactory;
        this.mDebugFlags = debugFlags;
        this.mSurface = surface;
        this.mRenderer = renderer;
        this.mGLWrapper = glWrapper;
        this.mEglContext = sharedEglContext;
    }

    public void setSurface(@NonNull Object surface) {
        if (this.mSurface != surface) {
            this.changeSurface = true;
        }
        this.mSurface = surface;
    }

    @Override
    public void run() {
        this.setName("GLThread " + this.getId());
        try {
            this.guardedRun();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.sGLThreadManager.threadExiting(this);
        }
    }

    public void setPreserveEGLContextOnPause(boolean mPreserveEGLContextOnPause) {
        this.mPreserveEGLContextOnPause = mPreserveEGLContextOnPause;
    }

    public void setDebugFlags(int debugFlags) {
        this.mDebugFlags = debugFlags;
    }

    private void stopEglSurfaceLocked() {
        if (this.mHaveEglSurface) {
            this.mHaveEglSurface = false;
            this.mEglHelper.destroySurface();
        }
    }

    private void stopEglContextLocked() {
        if (this.mHaveEglContext) {
            this.mEglHelper.finish();
            this.mHaveEglContext = false;
            this.sGLThreadManager.releaseEglContextLocked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void guardedRun() throws InterruptedException {
        block52: {
            this.mEglHelper = new EglHelper(this.mEGLConfigChooser, this.mEGLContextFactory, this.mEGLWindowSurfaceFactory, this.mGLWrapper, this.mDebugFlags);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            this.mWantRenderNotification = false;
            try {
                gl = null;
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                while (true) {
                    if ((now = System.currentTimeMillis()) - this.mLastRunTime < 1L) {
                        GLThread.sleep(1L - (now - this.mLastRunTime));
                    }
                    this.mLastRunTime = System.currentTimeMillis();
                    var15_14 = this.sGLThreadManager;
                    synchronized (var15_14) {
                        while (true) {
                            if (this.mShouldExit) {
                                // MONITOREXIT @DISABLED, blocks:[0, 51, 22, 23, 11] lbl26 : MonitorExitStatement: MONITOREXIT : var15_14
                                var16_16 = this.sGLThreadManager;
                                break block52;
                            }
                            if (!this.mEventQueue.isEmpty() && this.mHaveEglContext) {
                                event = this.mEventQueue.remove(0);
                                break;
                            }
                            pausing = false;
                            if (this.mPaused != this.mRequestPaused) {
                                pausing = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (lostEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                lostEglContext = false;
                            }
                            if (pausing && this.mHaveEglSurface) {
                                this.stopEglSurfaceLocked();
                            }
                            if (pausing && this.mHaveEglContext && !(preserveEglContextOnPause = this.mPreserveEGLContextOnPause)) {
                                this.stopEglContextLocked();
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                this.mWaitingForSurface = false;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (doRenderNotification) {
                                this.mWantRenderNotification = false;
                                doRenderNotification = false;
                                this.mRenderComplete = true;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (askedToReleaseEglContext) {
                                        askedToReleaseEglContext = false;
                                    } else if (this.sGLThreadManager.tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.mEglContext = this.mEglHelper.start(this.mEglContext);
                                            if (this.onCreateGLContextListener != null) {
                                                this.onCreateGLContextListener.onCreate(this.mEglContext);
                                            }
                                        }
                                        catch (RuntimeException t) {
                                            this.sGLThreadManager.releaseEglContextLocked(this);
                                            throw t;
                                        }
                                        this.mHaveEglContext = true;
                                        createEglContext = true;
                                        this.sGLThreadManager.notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    createEglSurface = true;
                                    createGlInterface = true;
                                    sizeChanged = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        sizeChanged = true;
                                        w = this.mWidth;
                                        h = this.mHeight;
                                        this.mWantRenderNotification = true;
                                        createEglSurface = true;
                                        this.mSizeChanged = false;
                                    }
                                    if (this.changeSurface) {
                                        createEglSurface = true;
                                        this.changeSurface = false;
                                    }
                                    this.mRequestRender = false;
                                    this.sGLThreadManager.notifyAll();
                                    if (!this.mWantRenderNotification) break;
                                    wantRenderNotification = true;
                                    break;
                                }
                            }
                            this.sGLThreadManager.wait();
                        }
                        ** if (event == null) goto lbl103
                    }
lbl-1000:
                    // 1 sources

                    {
                        event.run();
                        event = null;
                        continue;
                    }
lbl103:
                    // 1 sources

                    if (createEglSurface) {
                        if (this.mEglHelper.createSurface(this.mSurface)) {
                            var15_14 = this.sGLThreadManager;
                            synchronized (var15_14) {
                                this.mFinishedCreatingEglSurface = true;
                                this.sGLThreadManager.notifyAll();
                            }
                            createEglSurface = false;
                        } else {
                            var15_14 = this.sGLThreadManager;
                            synchronized (var15_14) {
                                this.mFinishedCreatingEglSurface = true;
                                this.mSurfaceIsBad = true;
                                this.sGLThreadManager.notifyAll();
                                continue;
                            }
                        }
                    }
                    if (createGlInterface) {
                        gl = (GL10)this.mEglHelper.createGL();
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        this.mRenderer.onSurfaceCreated(gl, this.mEglHelper.getEglConfig());
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        this.mRenderer.onSurfaceChanged(gl, w, h);
                        sizeChanged = false;
                    }
                    this.mRenderer.onDrawFrame(gl);
                    swapError = this.mEglHelper.swap();
                    switch (swapError) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            lostEglContext = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", swapError);
                            var16_18 = this.sGLThreadManager;
                            synchronized (var16_18) {
                                this.mSurfaceIsBad = true;
                                this.sGLThreadManager.notifyAll();
                                break;
                            }
                        }
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                    wantRenderNotification = false;
                }
            }
            catch (Throwable var22_21) {
                var23_22 = this.sGLThreadManager;
                synchronized (var23_22) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                    throw var22_21;
                }
            }
        }
        synchronized (var16_16) {
            this.stopEglSurfaceLocked();
            this.stopEglContextLocked();
            return;
        }
    }

    public boolean ableToDraw() {
        return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
    }

    private boolean readyToDraw() {
        return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
    }

    public EGLContext getEglContext() {
        return this.mEglContext;
    }

    public void setOnCreateGLContextListener(OnCreateGLContextListener onCreateGLContextListener) {
        this.onCreateGLContextListener = onCreateGLContextListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderMode(int renderMode) {
        if (0 > renderMode || renderMode > 1) {
            throw new IllegalArgumentException("renderMode");
        }
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mRenderMode = renderMode;
            this.sGLThreadManager.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRenderMode() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            return this.mRenderMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRender() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mRequestRender = true;
            this.sGLThreadManager.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRenderAndWait() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            if (Thread.currentThread() == this) {
                return;
            }
            this.mWantRenderNotification = true;
            this.mRequestRender = true;
            this.mRenderComplete = false;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mHasSurface = true;
            this.mFinishedCreatingEglSurface = false;
            this.sGLThreadManager.notifyAll();
            while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !this.mExited) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mHasSurface = false;
            this.sGLThreadManager.notifyAll();
            while (!this.mWaitingForSurface && !this.mExited) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mRequestPaused = true;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && !this.mPaused) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mRequestPaused = false;
            this.mRequestRender = true;
            this.mRenderComplete = false;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowResize(int w, int h) {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mWidth = w;
            this.mHeight = h;
            this.mSizeChanged = true;
            this.mRequestRender = true;
            this.mRenderComplete = false;
            if (Thread.currentThread() == this) {
                return;
            }
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExitAndWait() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mShouldExit = true;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mEventQueue.add(r);
            this.sGLThreadManager.notifyAll();
        }
    }

    public static class Builder {
        private EGLConfigChooser configChooser;
        private EGLContextFactory eglContextFactory;
        private EGLWindowSurfaceFactory eglWindowSurfaceFactory;
        private GLSurfaceView.Renderer renderer;
        private GLWrapper mGLWrapper = null;
        private int eglContextClientVersion = 2;
        private int debugFlags = 0;
        private int renderMode = 0;
        private Object surface;
        private EGLContext eglContext = EGL10.EGL_NO_CONTEXT;

        public Builder setSurface(Object surface) {
            this.surface = surface;
            return this;
        }

        public Builder setEGLConfigChooser(boolean needDepth) {
            this.setEGLConfigChooser(new SimpleEGLConfigChooser(needDepth, this.eglContextClientVersion));
            return this;
        }

        public Builder setEGLConfigChooser(EGLConfigChooser configChooser) {
            this.configChooser = configChooser;
            return this;
        }

        public Builder setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            this.setEGLConfigChooser(new ComponentSizeChooser(redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize, this.eglContextClientVersion));
            return this;
        }

        public Builder setEglContextFactory(EGLContextFactory eglContextFactory) {
            this.eglContextFactory = eglContextFactory;
            return this;
        }

        public Builder setEglWindowSurfaceFactory(EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
            this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
            return this;
        }

        public Builder setRenderer(GLSurfaceView.Renderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder setmGLWrapper(GLWrapper mGLWrapper) {
            this.mGLWrapper = mGLWrapper;
            return this;
        }

        public Builder setEglContextClientVersion(int eglContextClientVersion) {
            this.eglContextClientVersion = eglContextClientVersion;
            return this;
        }

        public Builder setDebugFlags(int debugFlags) {
            this.debugFlags = debugFlags;
            return this;
        }

        public Builder setRenderMode(int renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        public Builder setSharedEglContext(@NonNull EGLContext sharedEglContext) {
            this.eglContext = sharedEglContext;
            return this;
        }

        public GLThread createGLThread() {
            if (this.renderer == null) {
                throw new NullPointerException("renderer has not been set");
            }
            if (this.surface == null && this.eglWindowSurfaceFactory == null) {
                throw new NullPointerException("surface has not been set");
            }
            if (this.configChooser == null) {
                this.configChooser = new SimpleEGLConfigChooser(true, this.eglContextClientVersion);
            }
            if (this.eglContextFactory == null) {
                this.eglContextFactory = new DefaultContextFactory(this.eglContextClientVersion);
            }
            if (this.eglWindowSurfaceFactory == null) {
                this.eglWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
            }
            return new GLThread(this.configChooser, this.eglContextFactory, this.eglWindowSurfaceFactory, this.renderer, this.mGLWrapper, this.debugFlags, this.renderMode, this.surface, this.eglContext);
        }
    }

    public static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        @Override
        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            int[] surfaceAttribs = new int[]{12344};
            EGLSurface result = null;
            try {
                result = egl.eglCreateWindowSurface(display, config, nativeWindow, surfaceAttribs);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"DefaultWindow", (String)"eglCreateWindowSurface", (Throwable)e);
            }
            return result;
        }

        @Override
        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    public static class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private int contextClientVersion;

        public DefaultContextFactory(int contextClientVersion) {
            this.contextClientVersion = contextClientVersion;
        }

        @Override
        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config, EGLContext eglContext) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, this.contextClientVersion, 12344};
            return egl.eglCreateContext(display, config, eglContext, (int[])(this.contextClientVersion != 0 ? attrib_list : null));
        }

        @Override
        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                Log.e((String)"DefaultContextFactory", (String)("display:" + display + " context: " + context));
                EglHelper.throwEglException("eglDestroyContex", egl.eglGetError());
            }
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3, EGLContext var4);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean withDepthBuffer, int contextClientVersion) {
            super(8, 8, 8, 0, withDepthBuffer ? 16 : 0, 0, contextClientVersion);
        }
    }

    private static class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue = new int[1];
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize, int contextClientVersion) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344}, contextClientVersion);
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private static abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;
        private int contextClientVersion;

        public BaseConfigChooser(int[] configSpec, int contextClientVersion) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
            this.contextClientVersion = contextClientVersion;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] configSpec) {
            if (this.contextClientVersion != 2 && this.contextClientVersion != 3) {
                return configSpec;
            }
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = this.contextClientVersion == 2 ? 4 : 64;
            newConfigSpec[len + 1] = 12344;
            return newConfigSpec;
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class GLThreadManager {
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            thread.mExited = true;
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread || this.mEglOwner == null) {
                this.mEglOwner = thread;
                this.notifyAll();
                return true;
            }
            return true;
        }

        public void releaseEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }

    public static interface OnCreateGLContextListener {
        public void onCreate(EGLContext var1);
    }
}

