/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glview.texture.GLSharedContextView;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.opengles.GL10;

public abstract class GLSurfaceTextureProducerView
extends GLSharedContextView {
    private SurfaceTexture producedSurfaceTexture;
    private OnSurfaceTextureSet onSurfaceTextureSet;
    private RawTexture producedRawTexture;
    private int producedTextureTarget = 36197;

    public GLSurfaceTextureProducerView(Context context) {
        super(context);
    }

    public GLSurfaceTextureProducerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GLSurfaceTextureProducerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected final void onGLDraw(ICanvasGL canvas, @Nullable SurfaceTexture sharedSurfaceTexture, BasicTexture sharedTexture) {
        this.onGLDraw(canvas, this.producedSurfaceTexture, this.producedRawTexture, sharedSurfaceTexture, sharedTexture);
    }

    protected abstract void onGLDraw(ICanvasGL var1, SurfaceTexture var2, RawTexture var3, @Nullable SurfaceTexture var4, @Nullable BasicTexture var5);

    public void setOnSurfaceTextureSet(OnSurfaceTextureSet onSurfaceTextureSet) {
        this.onSurfaceTextureSet = onSurfaceTextureSet;
    }

    @Override
    protected final int getRenderMode() {
        return 0;
    }

    public void setProducedTextureTarget(int producedTextureTarget) {
        this.producedTextureTarget = producedTextureTarget;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
        if (this.mGLThread == null) {
            this.setSharedEglContext(EGL10.EGL_NO_CONTEXT);
        }
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        super.onSurfaceChanged(gl, width, height);
        if (this.producedRawTexture == null) {
            this.producedRawTexture = new RawTexture(width, height, false, this.producedTextureTarget);
            if (!this.producedRawTexture.isLoaded()) {
                this.producedRawTexture.prepare(this.mCanvas.getGlCanvas());
            }
            this.producedSurfaceTexture = new SurfaceTexture(this.producedRawTexture.getId());
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (GLSurfaceTextureProducerView.this.onSurfaceTextureSet != null) {
                        GLSurfaceTextureProducerView.this.onSurfaceTextureSet.onSet(GLSurfaceTextureProducerView.this.producedSurfaceTexture, GLSurfaceTextureProducerView.this.producedRawTexture);
                    }
                }
            });
        } else {
            this.producedRawTexture.setSize(width, height);
        }
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        this.producedSurfaceTexture.updateTexImage();
        super.onDrawFrame(gl);
    }

    @Override
    protected void surfaceDestroyed() {
        super.surfaceDestroyed();
        if (this.producedRawTexture != null) {
            this.producedRawTexture.recycle();
            this.producedRawTexture = null;
        }
        if (this.producedSurfaceTexture != null) {
            this.producedSurfaceTexture.release();
            this.producedSurfaceTexture = null;
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    public static interface OnSurfaceTextureSet {
        public void onSet(SurfaceTexture var1, RawTexture var2);
    }
}

